/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.itempipe.net;

import gregtech.api.pipenet.IRoutePath;
import gregtech.api.unification.material.properties.ItemPipeProperties;
import gregtech.api.util.FacingPos;
import gregtech.common.pipelike.itempipe.tile.TileEntityItemPipe;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import org.jetbrains.annotations.NotNull;

public class ItemRoutePath
implements IRoutePath<TileEntityItemPipe> {
    private final TileEntityItemPipe targetPipe;
    private final EnumFacing faceToHandler;
    private final int distance;
    private final ItemPipeProperties properties;
    private final Predicate<ItemStack> filters;

    public ItemRoutePath(TileEntityItemPipe targetPipe, EnumFacing facing, int distance, ItemPipeProperties properties, List<Predicate<ItemStack>> filters) {
        this.targetPipe = targetPipe;
        this.faceToHandler = facing;
        this.distance = distance;
        this.properties = properties;
        this.filters = stack -> {
            for (Predicate filter : filters) {
                if (filter.test(stack)) continue;
                return false;
            }
            return true;
        };
    }

    @Override
    @NotNull
    public TileEntityItemPipe getTargetPipe() {
        return this.targetPipe;
    }

    @Override
    @NotNull
    public EnumFacing getTargetFacing() {
        return this.faceToHandler;
    }

    @Override
    public int getDistance() {
        return this.distance;
    }

    public ItemPipeProperties getProperties() {
        return this.properties;
    }

    public boolean matchesFilters(ItemStack stack) {
        return this.filters.test(stack);
    }

    public IItemHandler getHandler() {
        return (IItemHandler)this.getTargetCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY);
    }

    public FacingPos toFacingPos() {
        return new FacingPos(this.getTargetPipePos(), this.faceToHandler);
    }
}

