/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.pipelike.cable.net;

import gregtech.api.pipenet.Node;
import gregtech.api.pipenet.PipeNet;
import gregtech.api.pipenet.WorldPipeNet;
import gregtech.api.unification.material.properties.WireProperties;
import gregtech.common.pipelike.cable.net.EnergyNetWalker;
import gregtech.common.pipelike.cable.net.EnergyRoutePath;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class EnergyNet
extends PipeNet<WireProperties> {
    private long lastEnergyFluxPerSec;
    private long energyFluxPerSec;
    private long lastTime;
    private final Map<BlockPos, List<EnergyRoutePath>> NET_DATA = new Object2ObjectOpenHashMap();

    protected EnergyNet(WorldPipeNet<WireProperties, EnergyNet> world) {
        super(world);
    }

    public List<EnergyRoutePath> getNetData(BlockPos pipePos) {
        List<EnergyRoutePath> data = this.NET_DATA.get(pipePos);
        if (data == null) {
            data = EnergyNetWalker.createNetData(this.getWorldData(), pipePos);
            if (data == null) {
                return Collections.emptyList();
            }
            data.sort(Comparator.comparingInt(EnergyRoutePath::getDistance));
            this.NET_DATA.put(pipePos, data);
        }
        return data;
    }

    public long getEnergyFluxPerSec() {
        World world = this.getWorldData();
        if (world != null && !world.field_72995_K && world.func_82737_E() - this.lastTime >= 20L) {
            this.lastTime = world.func_82737_E();
            this.clearCache();
        }
        return this.lastEnergyFluxPerSec;
    }

    public void addEnergyFluxPerSec(long energy) {
        this.energyFluxPerSec += energy;
    }

    public void clearCache() {
        this.lastEnergyFluxPerSec = this.energyFluxPerSec;
        this.energyFluxPerSec = 0L;
    }

    @Override
    public void onNeighbourUpdate(BlockPos fromPos) {
        this.NET_DATA.clear();
    }

    @Override
    public void onPipeConnectionsUpdate() {
        this.NET_DATA.clear();
    }

    @Override
    public void onChunkUnload() {
        this.NET_DATA.clear();
    }

    @Override
    protected void transferNodeData(Map<BlockPos, Node<WireProperties>> transferredNodes, PipeNet<WireProperties> parentNet) {
        super.transferNodeData(transferredNodes, parentNet);
        this.NET_DATA.clear();
        ((EnergyNet)parentNet).NET_DATA.clear();
    }

    @Override
    protected void writeNodeData(WireProperties nodeData, NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("voltage", nodeData.getVoltage());
        tagCompound.func_74768_a("amperage", nodeData.getAmperage());
        tagCompound.func_74768_a("loss", nodeData.getLossPerBlock());
    }

    @Override
    protected WireProperties readNodeData(NBTTagCompound tagCompound) {
        int voltage = tagCompound.func_74762_e("voltage");
        int amperage = tagCompound.func_74762_e("amperage");
        int lossPerBlock = tagCompound.func_74762_e("loss");
        return new WireProperties(voltage, amperage, lossPerBlock);
    }
}

