/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import gregtech.api.metatileentity.IDataInfoProvider;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.pipenet.longdist.ILDEndpoint;
import gregtech.api.pipenet.longdist.LongDistanceNetwork;
import gregtech.api.pipenet.longdist.LongDistancePipeType;
import gregtech.common.ConfigHolder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetaTileEntityLongDistanceEndpoint
extends MetaTileEntity
implements ILDEndpoint,
IDataInfoProvider {
    private final LongDistancePipeType pipeType;
    private ILDEndpoint.IOType ioType = ILDEndpoint.IOType.NONE;
    private ILDEndpoint link;
    private boolean placed = false;

    public MetaTileEntityLongDistanceEndpoint(ResourceLocation metaTileEntityId, LongDistancePipeType pipeType) {
        super(metaTileEntityId);
        this.pipeType = Objects.requireNonNull(pipeType);
    }

    public void updateNetwork() {
        List<LongDistanceNetwork> networks;
        LongDistanceNetwork network = LongDistanceNetwork.get(this.getWorld(), this.getPos());
        if (network != null) {
            network.onRemoveEndpoint(this);
        }
        if ((networks = this.findNetworks()).isEmpty()) {
            network = this.pipeType.createNetwork(this.getWorld());
            network.onPlaceEndpoint(this);
            this.setIoType(ILDEndpoint.IOType.NONE);
        } else if (networks.size() == 1) {
            networks.get(0).onPlaceEndpoint(this);
        } else {
            this.setIoType(ILDEndpoint.IOType.NONE);
        }
    }

    @Override
    public boolean onWrenchClick(EntityPlayer playerIn, EnumHand hand, EnumFacing wrenchSide, CuboidRayTraceResult hitResult) {
        return super.onWrenchClick(playerIn, hand, wrenchSide.func_176734_d(), hitResult);
    }

    @Override
    public void setFrontFacing(EnumFacing frontFacing) {
        this.placed = true;
        super.setFrontFacing(frontFacing);
        if (this.getWorld() != null && !this.getWorld().field_72995_K) {
            this.updateNetwork();
        }
    }

    @Override
    public boolean isValidFrontFacing(EnumFacing facing) {
        return !this.hasFrontFacing() || this.getFrontFacing() != facing;
    }

    @Override
    public void onRemoval() {
        if (this.link != null) {
            this.link.invalidateLink();
            this.invalidateLink();
        }
        this.setIoType(ILDEndpoint.IOType.NONE);
        LongDistanceNetwork network = LongDistanceNetwork.get(this.getWorld(), this.getPos());
        if (network != null) {
            network.onRemoveEndpoint(this);
        }
    }

    @Override
    public void onNeighborChanged() {
        if (!this.placed || this.getWorld() == null || this.getWorld().field_72995_K) {
            return;
        }
        List<LongDistanceNetwork> networks = this.findNetworks();
        LongDistanceNetwork network = LongDistanceNetwork.get(this.getWorld(), this.getPos());
        if (network == null) {
            if (networks.isEmpty()) {
                network = this.pipeType.createNetwork(this.getWorld());
                network.onPlaceEndpoint(this);
            } else if (networks.size() == 1) {
                networks.get(0).onPlaceEndpoint(this);
            }
        } else if (networks.size() > 1) {
            this.onRemoval();
        }
        if (networks.size() != 1) {
            this.setIoType(ILDEndpoint.IOType.NONE);
        }
    }

    private List<LongDistanceNetwork> findNetworks() {
        ArrayList<LongDistanceNetwork> networks = new ArrayList<LongDistanceNetwork>();
        LongDistanceNetwork network = LongDistanceNetwork.get(this.getWorld(), this.getPos().func_177972_a(this.getFrontFacing()));
        if (network != null && this.pipeType == network.getPipeType()) {
            networks.add(network);
            this.setIoType(ILDEndpoint.IOType.OUTPUT);
        }
        if ((network = LongDistanceNetwork.get(this.getWorld(), this.getPos().func_177972_a(this.getOutputFacing()))) != null && this.pipeType == network.getPipeType()) {
            networks.add(network);
            this.setIoType(ILDEndpoint.IOType.INPUT);
        }
        return networks;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        NBTTagCompound nbt = super.writeToNBT(data);
        data.func_74774_a("Type", (byte)this.ioType.ordinal());
        return nbt;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.ioType = ILDEndpoint.IOType.values()[data.func_74771_c("Type")];
    }

    @Override
    @NotNull
    public ILDEndpoint.IOType getIoType() {
        return this.ioType;
    }

    @Override
    public void setIoType(ILDEndpoint.IOType ioType) {
        this.ioType = Objects.requireNonNull(ioType);
    }

    @Override
    public ILDEndpoint getLink() {
        if (this.link == null) {
            LongDistanceNetwork network = LongDistanceNetwork.get(this.getWorld(), this.getPos());
            if (network != null && network.isValid()) {
                this.link = network.getOtherEndpoint(this);
            }
        } else if (!this.link.isValid()) {
            this.link.invalidateLink();
            this.link = null;
            LongDistanceNetwork network = LongDistanceNetwork.get(this.getWorld(), this.getPos());
            if (network != null) {
                network.invalidateEndpoints();
                if (network.isValid()) {
                    this.link = network.getOtherEndpoint(this);
                }
            }
        }
        return this.link;
    }

    @Override
    public void invalidateLink() {
        this.link = null;
    }

    @Override
    @NotNull
    public EnumFacing getOutputFacing() {
        return this.getFrontFacing().func_176734_d();
    }

    @Override
    @NotNull
    public LongDistancePipeType getPipeType() {
        return this.pipeType;
    }

    @Override
    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.endpoint.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.endpoint.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.endpoint.tooltip.3", (Object[])new Object[0]));
        if (this.pipeType.getMinLength() > 0) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.endpoint.tooltip.min_length", (Object[])new Object[]{this.pipeType.getMinLength()}));
        }
        if (ConfigHolder.machines.doTerrainExplosion && this.getIsWeatherOrTerrainResistant()) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.terrain_resist", (Object[])new Object[0]));
        }
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    @NotNull
    public List<ITextComponent> getDataInfo() {
        ArrayList<ITextComponent> textComponents = new ArrayList<ITextComponent>();
        LongDistanceNetwork network = LongDistanceNetwork.get(this.getWorld(), this.getPos());
        if (network == null) {
            textComponents.add((ITextComponent)new TextComponentString("No network found"));
        } else {
            textComponents.add((ITextComponent)new TextComponentString("Network:"));
            textComponents.add((ITextComponent)new TextComponentString(" - " + network.getTotalSize() + " pipes"));
            ILDEndpoint in = network.getActiveInputIndex();
            ILDEndpoint out = network.getActiveOutputIndex();
            textComponents.add((ITextComponent)new TextComponentString(" - input: " + (in == null ? "none" : in.pos())));
            textComponents.add((ITextComponent)new TextComponentString(" - output: " + (out == null ? "none" : out.pos())));
        }
        if (this.isInput()) {
            textComponents.add((ITextComponent)new TextComponentString("Input endpoint"));
        }
        if (this.isOutput()) {
            textComponents.add((ITextComponent)new TextComponentString("Output endpoint"));
        }
        return textComponents;
    }

    @Override
    public World world() {
        return this.getWorld();
    }

    @Override
    public BlockPos pos() {
        return this.getPos();
    }

    @Override
    public void onNeighborChanged(@NotNull EnumFacing facing) {
    }

    @Override
    public void markAsDirty() {
    }
}

