/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.storage;

import com.google.common.collect.Lists;
import gregtech.api.storage.ICraftingStorage;
import gregtech.api.util.DummyContainer;
import gregtech.common.inventory.IItemList;
import gregtech.common.inventory.itemsource.ItemSources;
import gregtech.common.inventory.itemsource.sources.TileItemSource;
import gregtech.common.metatileentities.storage.CachedRecipeData;
import gregtech.common.metatileentities.storage.CraftingRecipeMemory;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;

public class CraftingRecipeLogic {
    private final World world;
    private final ItemSources itemSources;
    private final ItemStackHandler craftingGrid;
    private final ItemStack[] oldCraftingGrid = new ItemStack[9];
    private final InventoryCrafting inventoryCrafting = new InventoryCrafting((Container)new DummyContainer(), 3, 3);
    private final IInventory craftingResultInventory = new InventoryCraftResult();
    private ItemStack oldResult = ItemStack.field_190927_a;
    private final CachedRecipeData cachedRecipeData;
    private final CraftingRecipeMemory recipeMemory;
    private IRecipe cachedRecipe = null;
    private int itemsCrafted = 0;
    public static short ALL_INGREDIENTS_PRESENT = (short)511;
    private short tintLocation = ALL_INGREDIENTS_PRESENT;

    public CraftingRecipeLogic(ICraftingStorage craftingStorage) {
        this.world = craftingStorage.getWorld();
        this.craftingGrid = craftingStorage.getCraftingGrid();
        this.recipeMemory = craftingStorage.getRecipeMemory();
        this.itemSources = new ItemSources(this.world);
        this.cachedRecipeData = new CachedRecipeData(this.itemSources, null, this.inventoryCrafting);
    }

    public ItemSources getItemSourceList() {
        return this.itemSources;
    }

    public IInventory getCraftingResultInventory() {
        return this.craftingResultInventory;
    }

    public int getItemsCraftedAmount() {
        return this.itemsCrafted;
    }

    public void setItemsCraftedAmount(int itemsCrafted) {
        this.itemsCrafted = itemsCrafted;
    }

    public void clearCraftingGrid() {
        this.fillCraftingGrid(Collections.emptyMap());
    }

    public void fillCraftingGrid(Map<Integer, ItemStack> ingredients) {
        for (int i = 0; i < this.craftingGrid.getSlots(); ++i) {
            this.craftingGrid.setStackInSlot(i, ingredients.getOrDefault(i + 1, ItemStack.field_190927_a));
        }
    }

    private boolean hasCraftingGridUpdated() {
        boolean craftingGridChanged = false;
        for (int i = 0; i < this.craftingGrid.getSlots(); ++i) {
            ItemStack oldStack = this.oldCraftingGrid[i];
            ItemStack newStack = this.craftingGrid.getStackInSlot(i);
            if (oldStack == null || oldStack.func_190926_b()) {
                if (newStack.func_190926_b()) continue;
                this.oldCraftingGrid[i] = oldStack = newStack;
                this.inventoryCrafting.func_70299_a(i, newStack.func_77946_l());
                craftingGridChanged = true;
                continue;
            }
            if (newStack.func_190926_b()) {
                this.oldCraftingGrid[i] = null;
                this.inventoryCrafting.func_70299_a(i, ItemStack.field_190927_a);
                craftingGridChanged = true;
                continue;
            }
            if (ItemStack.func_179545_c((ItemStack)oldStack, (ItemStack)newStack) && ItemStack.func_77970_a((ItemStack)oldStack, (ItemStack)newStack)) continue;
            this.oldCraftingGrid[i] = newStack;
            this.inventoryCrafting.func_70299_a(i, newStack.func_77946_l());
            craftingGridChanged = true;
        }
        return craftingGridChanged;
    }

    public boolean performRecipe(EntityPlayer player) {
        if (!this.isRecipeValid()) {
            return false;
        }
        if (!this.cachedRecipeData.consumeRecipeItems()) {
            return false;
        }
        ForgeHooks.setCraftingPlayer((EntityPlayer)player);
        NonNullList remainingItems = this.cachedRecipe.func_179532_b(this.inventoryCrafting);
        ForgeHooks.setCraftingPlayer(null);
        for (int i = 0; i < remainingItems.size(); ++i) {
            int remainingAmount;
            ItemStack itemStack = (ItemStack)remainingItems.get(i);
            if (itemStack.func_190926_b()) continue;
            ItemStack current = this.inventoryCrafting.func_70301_a(i);
            this.inventoryCrafting.func_70299_a(i, itemStack);
            if (!this.cachedRecipe.func_77569_a(this.inventoryCrafting, this.itemSources.getWorld())) {
                this.inventoryCrafting.func_70299_a(i, current);
            }
            if ((remainingAmount = itemStack.func_190916_E() - this.itemSources.insertItem(itemStack, itemStack.func_190916_E(), false, IItemList.InsertMode.HIGHEST_PRIORITY)) <= 0) continue;
            itemStack.func_190920_e(remainingAmount);
            player.func_191521_c(itemStack);
            if (itemStack.func_190916_E() <= 0) continue;
            player.func_146097_a(itemStack, false, false);
        }
        return true;
    }

    public void handleItemCraft(ItemStack itemStack, EntityPlayer player) {
        itemStack.func_77980_a(this.world, player, 1);
        itemStack.func_77973_b().func_77622_d(itemStack, this.world, player);
        FMLCommonHandler.instance().firePlayerCraftingEvent(player, itemStack, (IInventory)this.inventoryCrafting);
        if (this.cachedRecipe != null && !this.cachedRecipe.func_192399_d()) {
            player.func_192021_a((List)Lists.newArrayList((Object[])new IRecipe[]{this.cachedRecipe}));
        }
        if (this.cachedRecipe != null) {
            ItemStack resultStack = this.cachedRecipe.func_77572_b(this.inventoryCrafting);
            this.itemsCrafted += resultStack.func_190916_E();
            this.recipeMemory.notifyRecipePerformed((IItemHandler)this.craftingGrid, resultStack);
        }
    }

    public void refreshOutputSlot() {
        ItemStack itemStack = ItemStack.field_190927_a;
        if (this.cachedRecipe != null) {
            itemStack = this.cachedRecipe.func_77572_b(this.inventoryCrafting);
        }
        this.craftingResultInventory.func_70299_a(0, itemStack);
    }

    public boolean isRecipeValid() {
        return this.cachedRecipeData.getRecipe() != null && this.cachedRecipeData.matches(this.inventoryCrafting, this.world) && this.cachedRecipeData.attemptMatchRecipe() == ALL_INGREDIENTS_PRESENT;
    }

    private void updateCurrentRecipe() {
        if (!this.cachedRecipeData.matches(this.inventoryCrafting, this.world) || !ItemStack.func_77989_b((ItemStack)this.oldResult, (ItemStack)this.cachedRecipe.func_77572_b(this.inventoryCrafting))) {
            IRecipe newRecipe;
            this.cachedRecipe = newRecipe = CraftingManager.func_192413_b((InventoryCrafting)this.inventoryCrafting, (World)this.world);
            ItemStack resultStack = ItemStack.field_190927_a;
            if (newRecipe != null) {
                resultStack = newRecipe.func_77572_b(this.inventoryCrafting);
                this.oldResult = resultStack.func_77946_l();
            }
            this.craftingResultInventory.func_70299_a(0, resultStack);
            this.cachedRecipeData.setRecipe(newRecipe);
        }
    }

    public void update() {
        this.itemSources.update();
        this.tintLocation = this.getCachedRecipeData().getRecipe() != null ? this.getCachedRecipeData().attemptMatchRecipe() : ALL_INGREDIENTS_PRESENT;
        if (this.hasCraftingGridUpdated()) {
            this.updateCurrentRecipe();
        }
    }

    public short getTintLocations() {
        return this.tintLocation;
    }

    public void checkNeighbourInventories(BlockPos blockPos) {
        for (EnumFacing side : EnumFacing.field_82609_l) {
            TileItemSource itemSource = new TileItemSource(this.world, blockPos, side);
            this.itemSources.addItemHandler(itemSource);
        }
    }

    public CachedRecipeData getCachedRecipeData() {
        return this.cachedRecipeData;
    }
}

