/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.steam.boiler;

import gregtech.api.GTValues;
import gregtech.api.capability.IFilter;
import gregtech.api.capability.impl.CommonFluidFilters;
import gregtech.api.capability.impl.FilteredFluidHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.TankWidget;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.unification.material.Materials;
import gregtech.client.particle.VanillaParticleEffects;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.ConfigHolder;
import gregtech.common.metatileentities.steam.boiler.SteamBoiler;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class SteamLavaBoiler
extends SteamBoiler {
    private static final Object2IntMap<Fluid> BOILER_FUEL_TO_CONSUMPTION = new Object2IntOpenHashMap();
    private static boolean initialized;
    private static final IFilter<FluidStack> FUEL_FILTER;
    private FluidTank fuelFluidTank;

    private static void init() {
        SteamLavaBoiler.setBoilerFuelToConsumption(Materials.Lava.getFluid(), 100);
        SteamLavaBoiler.setBoilerFuelToConsumption(Materials.Creosote.getFluid(), 250);
    }

    @NotNull
    public static Object2IntMap<Fluid> getBoilerFuelToConsumption() {
        if (!initialized) {
            initialized = true;
            SteamLavaBoiler.init();
        }
        return Object2IntMaps.unmodifiable(BOILER_FUEL_TO_CONSUMPTION);
    }

    public static void setBoilerFuelToConsumption(@NotNull Fluid fluid, int amount) {
        Objects.requireNonNull(fluid, "fluid == null");
        if (amount <= 0) {
            throw new IllegalArgumentException("amount <= 0");
        }
        BOILER_FUEL_TO_CONSUMPTION.put((Object)fluid, amount);
    }

    public SteamLavaBoiler(ResourceLocation metaTileEntityId, boolean isHighPressure) {
        super(metaTileEntityId, isHighPressure, Textures.LAVA_BOILER_OVERLAY);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new SteamLavaBoiler(this.metaTileEntityId, this.isHighPressure);
    }

    @Override
    protected int getBaseSteamOutput() {
        return this.isHighPressure ? 600 : 240;
    }

    @Override
    protected FluidTankList createImportFluidHandler() {
        FluidTankList superHandler = super.createImportFluidHandler();
        this.fuelFluidTank = new FilteredFluidHandler(16000).setFilter(FUEL_FILTER);
        return new FluidTankList(false, superHandler, new IFluidTank[]{this.fuelFluidTank});
    }

    @Override
    protected void tryConsumeNewFuel() {
        FluidStack fluid = this.fuelFluidTank.getFluid();
        if (fluid == null || fluid.tag != null) {
            return;
        }
        int consumption = SteamLavaBoiler.getBoilerFuelToConsumption().getInt((Object)fluid.getFluid());
        if (consumption > 0 && this.fuelFluidTank.getFluidAmount() >= consumption) {
            this.fuelFluidTank.drain(consumption, true);
            this.setFuelMaxBurnTime(100);
        }
    }

    @Override
    protected int getCooldownInterval() {
        return this.isHighPressure ? 40 : 45;
    }

    @Override
    protected int getCoolDownRate() {
        return 1;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return this.createUITemplate(entityPlayer).widget(new TankWidget((IFluidTank)this.fuelFluidTank, 119, 26, 10, 54).setBackgroundTexture(GuiTextures.PROGRESS_BAR_BOILER_EMPTY.get(this.isHighPressure))).build(this.getHolder(), entityPlayer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void randomDisplayTick() {
        if (this.isActive()) {
            VanillaParticleEffects.RANDOM_LAVA_SMOKE.runEffect(this);
            if (ConfigHolder.machines.machineSounds && GTValues.RNG.nextDouble() < 0.1) {
                BlockPos pos = this.getPos();
                this.getWorld().func_184134_a((double)((float)pos.func_177958_n() + 0.5f), (double)((float)pos.func_177956_o() + 0.5f), (double)((float)pos.func_177952_p() + 0.5f), SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
        }
    }

    static {
        FUEL_FILTER = new IFilter<FluidStack>(){

            @Override
            public boolean test(@NotNull FluidStack fluidStack) {
                for (Fluid fluid : SteamLavaBoiler.getBoilerFuelToConsumption().keySet()) {
                    if (!CommonFluidFilters.matchesFluid(fluidStack, fluid)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public int getPriority() {
                return IFilter.whitelistPriority(SteamLavaBoiler.getBoilerFuelToConsumption().size());
            }
        };
    }
}

