/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.primitive;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import crafttweaker.annotations.ZenRegister;
import crafttweaker.api.block.IBlock;
import crafttweaker.api.minecraft.CraftTweakerMC;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IMultiblockController;
import gregtech.api.capability.IWorkable;
import gregtech.api.gui.ModularUI;
import gregtech.api.items.metaitem.MetaItem;
import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.items.behaviors.LighterBehaviour;
import gregtech.common.metatileentities.MetaTileEntities;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemFireball;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.gregtech.machines.CharcoalPileIgniter")
@ZenRegister
public class MetaTileEntityCharcoalPileIgniter
extends MultiblockControllerBase
implements IWorkable {
    private static final int MIN_RADIUS = 1;
    private static final int MIN_DEPTH = 2;
    private static final Set<Block> WALL_BLOCKS = new ObjectOpenHashSet();
    private final Collection<BlockPos> logPositions = new ObjectOpenHashSet();
    private int lDist = 0;
    private int rDist = 0;
    private int hDist = 0;
    private boolean isActive;
    private int progressTime = 0;
    private int maxProgress = 0;

    public MetaTileEntityCharcoalPileIgniter(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
        MinecraftForge.EVENT_BUS.register(MetaTileEntityCharcoalPileIgniter.class);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityCharcoalPileIgniter(this.metaTileEntityId);
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Textures.CHARCOAL_PILE_OVERLAY.renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive, true);
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.setActive(false);
        this.progressTime = 0;
        this.maxProgress = 0;
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.updateMaxProgressTime();
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        int i;
        if (this.getWorld() != null) {
            this.updateStructureDimensions();
        }
        if (this.lDist < 1) {
            this.lDist = 1;
        }
        if (this.rDist < 1) {
            this.rDist = 1;
        }
        if (this.hDist < 2) {
            this.hDist = 2;
        }
        if (this.frontFacing == EnumFacing.EAST || this.frontFacing == EnumFacing.WEST) {
            int tmp = this.lDist;
            this.lDist = this.rDist;
            this.rDist = tmp;
        }
        StringBuilder wallBuilder = new StringBuilder();
        StringBuilder floorBuilder = new StringBuilder();
        StringBuilder cornerBuilder = new StringBuilder();
        StringBuilder ctrlBuilder = new StringBuilder();
        StringBuilder woodBuilder = new StringBuilder();
        wallBuilder.append(" ");
        floorBuilder.append(" ");
        ctrlBuilder.append(" ");
        woodBuilder.append("X");
        for (i = 0; i < this.lDist; ++i) {
            cornerBuilder.append(" ");
            if (i <= 0) continue;
            wallBuilder.append("X");
            floorBuilder.append("B");
            ctrlBuilder.append("X");
            woodBuilder.append("C");
        }
        wallBuilder.append("X");
        floorBuilder.append("B");
        cornerBuilder.append(" ");
        ctrlBuilder.append("S");
        woodBuilder.append("C");
        for (i = 0; i < this.rDist; ++i) {
            cornerBuilder.append(" ");
            if (i >= this.rDist - 1) continue;
            wallBuilder.append("X");
            floorBuilder.append("B");
            ctrlBuilder.append("X");
            woodBuilder.append("C");
        }
        wallBuilder.append(" ");
        floorBuilder.append(" ");
        ctrlBuilder.append(" ");
        woodBuilder.append("X");
        Object[] wall = new String[this.hDist + 1];
        Arrays.fill(wall, wallBuilder.toString());
        wall[0] = cornerBuilder.toString();
        wall[wall.length - 1] = cornerBuilder.toString();
        Object[] slice = new String[this.hDist + 1];
        Arrays.fill(slice, woodBuilder.toString());
        slice[0] = floorBuilder.toString();
        String[] center = (String[])Arrays.copyOf(slice, slice.length);
        center[center.length - 1] = this.frontFacing == EnumFacing.EAST || this.frontFacing == EnumFacing.WEST ? ctrlBuilder.reverse().toString() : ctrlBuilder.toString();
        slice[slice.length - 1] = wallBuilder.toString();
        return FactoryBlockPattern.start().aisle((String[])wall).aisle((String[])slice).setRepeatable(0, 4).aisle(center).aisle((String[])slice).setRepeatable(0, 4).aisle((String[])wall).where('S', this.selfPredicate()).where('B', MetaTileEntityCharcoalPileIgniter.blocks(Blocks.field_150336_V)).where('X', MetaTileEntityCharcoalPileIgniter.blocks(WALL_BLOCKS.toArray(new Block[0]))).where('C', this.logPredicate()).where(' ', MetaTileEntityCharcoalPileIgniter.any()).build();
    }

    @NotNull
    private TraceabilityPredicate logPredicate() {
        return new TraceabilityPredicate(blockWorldState -> {
            if (blockWorldState.getBlockState().func_177230_c().isWood((IBlockAccess)blockWorldState.getWorld(), blockWorldState.getPos())) {
                this.logPositions.add(blockWorldState.getPos());
                return true;
            }
            return false;
        });
    }

    private boolean updateStructureDimensions() {
        World world = this.getWorld();
        EnumFacing left = this.getFrontFacing().func_176734_d().func_176735_f();
        EnumFacing right = left.func_176734_d();
        BlockPos.MutableBlockPos lPos = new BlockPos.MutableBlockPos(this.getPos()).func_189536_c(EnumFacing.DOWN);
        BlockPos.MutableBlockPos rPos = new BlockPos.MutableBlockPos(this.getPos()).func_189536_c(EnumFacing.DOWN);
        BlockPos.MutableBlockPos hPos = new BlockPos.MutableBlockPos(this.getPos());
        int lDist = 0;
        int rDist = 0;
        int hDist = 0;
        for (int i = 1; i < 6 && (lDist == 0 || rDist == 0 || hDist == 0); ++i) {
            if (lDist == 0 && MetaTileEntityCharcoalPileIgniter.isBlockWall(world, lPos, left)) {
                lDist = i;
            }
            if (rDist == 0 && MetaTileEntityCharcoalPileIgniter.isBlockWall(world, rPos, right)) {
                rDist = i;
            }
            if (hDist != 0 || !MetaTileEntityCharcoalPileIgniter.isBlockFloor(world, hPos)) continue;
            hDist = i;
        }
        if (lDist < 1 || rDist < 1 || hDist < 2) {
            this.invalidateStructure();
            return false;
        }
        this.lDist = lDist;
        this.rDist = rDist;
        this.hDist = hDist;
        this.writeCustomData(GregtechDataCodes.UPDATE_STRUCTURE_SIZE, buf -> {
            buf.writeInt(this.lDist);
            buf.writeInt(this.rDist);
            buf.writeInt(this.hDist);
        });
        return true;
    }

    private static boolean isBlockWall(@NotNull World world, @NotNull BlockPos.MutableBlockPos pos, @NotNull EnumFacing direction) {
        return WALL_BLOCKS.contains(world.func_180495_p((BlockPos)pos.func_189536_c(direction)).func_177230_c());
    }

    private static boolean isBlockFloor(@NotNull World world, @NotNull BlockPos.MutableBlockPos pos) {
        return world.func_180495_p((BlockPos)pos.func_189536_c(EnumFacing.DOWN)).func_177230_c() == Blocks.field_150336_V;
    }

    private void setActive(boolean active) {
        this.isActive = active;
        this.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, buf -> buf.writeBoolean(this.isActive));
    }

    private void updateMaxProgressTime() {
        this.maxProgress = Math.max(1, (int)Math.sqrt(this.logPositions.size() * 240000));
    }

    @Override
    public void update() {
        super.update();
        if (this.getWorld() != null) {
            if (!this.getWorld().field_72995_K && !this.isStructureFormed() && this.getOffsetTimer() % 20L == 0L) {
                this.reinitializeStructurePattern();
            } else if (this.isActive) {
                BlockPos pos = this.getPos();
                EnumFacing facing = EnumFacing.UP;
                float xPos = (float)facing.func_82601_c() * 0.76f + (float)pos.func_177958_n() + 0.5f;
                float yPos = (float)facing.func_96559_d() * 0.76f + (float)pos.func_177956_o() + 0.25f;
                float zPos = (float)facing.func_82599_e() * 0.76f + (float)pos.func_177952_p() + 0.5f;
                float ySpd = (float)facing.func_96559_d() * 0.1f + 0.2f + 0.1f * GTValues.RNG.nextFloat();
                this.getWorld().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, (double)xPos, (double)yPos, (double)zPos, 0.0, (double)ySpd, 0.0, new int[0]);
            }
        }
    }

    @Override
    protected void updateFormedValid() {
        if (this.isActive && this.maxProgress > 0 && ++this.progressTime == this.maxProgress) {
            this.progressTime = 0;
            this.maxProgress = 0;
            this.convertLogBlocks();
            this.setActive(false);
        }
    }

    private void convertLogBlocks() {
        World world = this.getWorld();
        for (BlockPos pos : this.logPositions) {
            world.func_175656_a(pos, MetaBlocks.BRITTLE_CHARCOAL.func_176223_P());
        }
        this.logPositions.clear();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.BRONZE_PLATED_BRICKS;
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        return null;
    }

    @Override
    protected boolean openGUIOnRightClick() {
        return false;
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.charcoal_pile.tooltip.1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.charcoal_pile.tooltip.2", (Object[])new Object[0]));
        if (TooltipHelper.isCtrlDown()) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.charcoal_pile.tooltip.3", (Object[])new Object[0]));
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.charcoal_pile.tooltip.4", (Object[])new Object[0]));
        } else {
            tooltip.add(I18n.func_135052_a((String)"gregtech.tooltip.hold_ctrl", (Object[])new Object[0]));
        }
    }

    @Override
    public List<MultiblockShapeInfo> getMatchingShapes() {
        ObjectArrayList shapeInfos = new ObjectArrayList();
        for (Block block : WALL_BLOCKS) {
            shapeInfos.add(MultiblockShapeInfo.builder().aisle("     ", " XXX ", " XXX ", " XXX ", "     ").aisle(" BBB ", "XCCCX", "XCCCX", "XCCCX", " DDD ").aisle(" BBB ", "XCCCX", "XCCCX", "XCCCX", " DSD ").aisle(" BBB ", "XCCCX", "XCCCX", "XCCCX", " DDD ").aisle("     ", " XXX ", " XXX ", " XXX ", "     ").where('S', MetaTileEntities.CHARCOAL_PILE_IGNITER, EnumFacing.NORTH).where('B', Blocks.field_150336_V.func_176223_P()).where('X', block.func_176223_P()).where('D', block.func_176223_P()).where('C', Blocks.field_150364_r.func_176223_P()).build());
        }
        return shapeInfos;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74768_a("lDist", this.lDist);
        data.func_74768_a("rDist", this.rDist);
        data.func_74768_a("hDist", this.hDist);
        data.func_74768_a("progressTime", this.progressTime);
        data.func_74768_a("maxProgress", this.maxProgress);
        data.func_74757_a("isActive", this.isActive);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.lDist = data.func_74764_b("lDist") ? data.func_74762_e("lDist") : this.lDist;
        this.rDist = data.func_74764_b("rDist") ? data.func_74762_e("rDist") : this.rDist;
        this.hDist = data.func_74764_b("hDist") ? data.func_74762_e("hDist") : this.hDist;
        this.progressTime = data.func_74762_e("progressTime");
        this.maxProgress = data.func_74762_e("maxProgress");
        this.isActive = data.func_74767_n("isActive");
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeInt(this.lDist);
        buf.writeInt(this.rDist);
        buf.writeInt(this.hDist);
        buf.writeInt(this.progressTime);
        buf.writeInt(this.maxProgress);
        buf.writeBoolean(this.isActive);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.lDist = buf.readInt();
        this.rDist = buf.readInt();
        this.hDist = buf.readInt();
        this.progressTime = buf.readInt();
        this.maxProgress = buf.readInt();
        this.isActive = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.UPDATE_STRUCTURE_SIZE) {
            this.lDist = buf.readInt();
            this.rDist = buf.readInt();
            this.hDist = buf.readInt();
        } else if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    public static void addWallBlock(@NotNull Block block) {
        WALL_BLOCKS.add(block);
    }

    @ZenMethod(value="addWallBlock")
    @Optional.Method(modid="crafttweaker")
    public static void addWallBlockCT(@NotNull IBlock block) {
        WALL_BLOCKS.add(CraftTweakerMC.getBlock((IBlock)block));
    }

    @Override
    public boolean isWorkingEnabled() {
        return true;
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
    }

    @Override
    public int getProgress() {
        return this.progressTime;
    }

    @Override
    public int getMaxProgress() {
        return this.maxProgress;
    }

    @Override
    public boolean isActive() {
        return this.isActive;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_WORKABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_WORKABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @SubscribeEvent
    public static void onItemUse(@NotNull PlayerInteractEvent.RightClickBlock event) {
        TileEntity tileEntity = event.getWorld().func_175625_s(event.getPos());
        MetaTileEntity mte = null;
        if (tileEntity instanceof IGregTechTileEntity) {
            mte = ((IGregTechTileEntity)tileEntity).getMetaTileEntity();
        }
        if (mte instanceof MetaTileEntityCharcoalPileIgniter && ((IMultiblockController)((Object)mte)).isStructureFormed()) {
            if (event.getSide().isClient()) {
                event.setCanceled(true);
                event.getEntityPlayer().func_184609_a(EnumHand.MAIN_HAND);
            } else if (!mte.isActive()) {
                Object valueItem;
                boolean shouldActivate = false;
                ItemStack stack = event.getItemStack();
                if (stack.func_77973_b() instanceof ItemFlintAndSteel) {
                    stack.func_77972_a(1, (EntityLivingBase)event.getEntityPlayer());
                    event.getWorld().func_184133_a(null, event.getPos(), SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    shouldActivate = true;
                } else if (stack.func_77973_b() instanceof ItemFireball) {
                    stack.func_190918_g(1);
                    event.getWorld().func_184133_a(null, event.getPos(), SoundEvents.field_187616_bj, SoundCategory.PLAYERS, 1.0f, 1.0f);
                    shouldActivate = true;
                } else if (stack.func_77973_b() instanceof MetaItem && (valueItem = ((MetaItem)stack.func_77973_b()).getItem(stack)) != null) {
                    for (IItemBehaviour behaviour : ((MetaItem.MetaValueItem)valueItem).getBehaviours()) {
                        if (!(behaviour instanceof LighterBehaviour) || !((LighterBehaviour)behaviour).consumeFuel(event.getEntityPlayer(), stack)) continue;
                        event.getWorld().func_184133_a(null, event.getPos(), SoundEvents.field_187649_bu, SoundCategory.PLAYERS, 1.0f, 1.0f);
                        shouldActivate = true;
                        break;
                    }
                }
                if (shouldActivate) {
                    ((MetaTileEntityCharcoalPileIgniter)mte).setActive(true);
                    event.setCancellationResult(EnumActionResult.FAIL);
                    event.setCanceled(true);
                }
            }
        }
    }

    @Override
    public boolean hasFrontFacing() {
        return false;
    }

    @Override
    public boolean allowsExtendedFacing() {
        return false;
    }

    @Override
    public boolean allowsFlip() {
        return false;
    }

    static {
        WALL_BLOCKS.add(Blocks.field_150346_d);
        WALL_BLOCKS.add((Block)Blocks.field_150349_c);
        WALL_BLOCKS.add(Blocks.field_185774_da);
        WALL_BLOCKS.add((Block)Blocks.field_150354_m);
    }
}

