/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng.slot;

import appeng.api.storage.data.IAEFluidStack;
import gregtech.api.capability.INotifiableHandler;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAESlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.stack.WrappedFluidStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import org.jetbrains.annotations.Nullable;

public class ExportOnlyAEFluidSlot
extends ExportOnlyAESlot<IAEFluidStack>
implements IFluidTank,
INotifiableHandler,
IFluidHandler {
    private final List<MetaTileEntity> notifiableEntities = new ArrayList<MetaTileEntity>();
    private MetaTileEntity holder;

    public ExportOnlyAEFluidSlot(MetaTileEntity holder, IAEFluidStack config, IAEFluidStack stock, MetaTileEntity mte) {
        super(config, stock);
        this.holder = holder;
        this.notifiableEntities.add(mte);
    }

    public ExportOnlyAEFluidSlot(MetaTileEntity holder, MetaTileEntity entityToNotify) {
        this(holder, null, null, entityToNotify);
    }

    public ExportOnlyAEFluidSlot() {
    }

    @Override
    public IAEFluidStack requestStack() {
        IAEFluidStack result = (IAEFluidStack)super.requestStack();
        if (result instanceof WrappedFluidStack) {
            return ((WrappedFluidStack)result).getAEStack();
        }
        return result;
    }

    @Override
    public IAEFluidStack exceedStack() {
        IAEFluidStack result = (IAEFluidStack)super.exceedStack();
        if (result instanceof WrappedFluidStack) {
            return ((WrappedFluidStack)result).getAEStack();
        }
        return result;
    }

    @Override
    public void addStack(IAEFluidStack stack) {
        if (this.stock == null) {
            this.stock = WrappedFluidStack.fromFluidStack(stack.getFluidStack());
        } else {
            ((IAEFluidStack)this.stock).add(stack);
        }
        this.trigger();
    }

    @Override
    public void setStack(IAEFluidStack stack) {
        if (this.stock == null && stack == null) {
            return;
        }
        if (stack == null) {
            this.stock = null;
        } else if (this.stock == null || ((IAEFluidStack)this.stock).getFluid() != stack.getFluid()) {
            this.stock = WrappedFluidStack.fromFluidStack(stack.getFluidStack());
        } else if (((IAEFluidStack)this.stock).getStackSize() != stack.getStackSize()) {
            ((IAEFluidStack)this.stock).setStackSize(stack.getStackSize());
        } else {
            return;
        }
        this.trigger();
    }

    public void deserializeNBT(NBTTagCompound nbt) {
        if (nbt.func_74764_b("config")) {
            this.config = WrappedFluidStack.fromNBT(nbt.func_74775_l("config"));
        }
        if (nbt.func_74764_b("stock")) {
            this.stock = WrappedFluidStack.fromNBT(nbt.func_74775_l("stock"));
        }
    }

    @Nullable
    public FluidStack getFluid() {
        if (this.stock != null && this.stock instanceof WrappedFluidStack) {
            return ((WrappedFluidStack)this.stock).getDelegate();
        }
        return null;
    }

    public int getFluidAmount() {
        return this.stock != null ? (int)((IAEFluidStack)this.stock).getStackSize() : 0;
    }

    public int getCapacity() {
        return 0;
    }

    public FluidTankInfo getInfo() {
        return new FluidTankInfo((IFluidTank)this);
    }

    public IFluidTankProperties[] getTankProperties() {
        return new IFluidTankProperties[]{new FluidTankProperties(this.getFluid(), 0)};
    }

    public int fill(FluidStack resource, boolean doFill) {
        return 0;
    }

    @Nullable
    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (this.getFluid() != null && this.getFluid().isFluidEqual(resource)) {
            return this.drain(resource.amount, doDrain);
        }
        return null;
    }

    @Nullable
    public FluidStack drain(int maxDrain, boolean doDrain) {
        if (this.stock == null) {
            return null;
        }
        int drained = (int)Math.min(((IAEFluidStack)this.stock).getStackSize(), (long)maxDrain);
        FluidStack result = new FluidStack(((IAEFluidStack)this.stock).getFluid(), drained);
        if (doDrain) {
            ((IAEFluidStack)this.stock).decStackSize((long)drained);
            if (((IAEFluidStack)this.stock).getStackSize() == 0L) {
                this.stock = null;
            }
            this.trigger();
        }
        return result;
    }

    @Override
    public void addNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
        this.notifiableEntities.add(metaTileEntity);
    }

    @Override
    public void removeNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
        this.notifiableEntities.remove(metaTileEntity);
    }

    protected void trigger() {
        for (MetaTileEntity metaTileEntity : this.notifiableEntities) {
            if (metaTileEntity == null || !metaTileEntity.isValid()) continue;
            this.addToNotifiedList(metaTileEntity, this, false);
        }
        if (this.holder != null) {
            this.holder.markDirty();
        }
    }

    public ExportOnlyAEFluidSlot copy() {
        return new ExportOnlyAEFluidSlot(this.holder, this.config == null ? null : ((IAEFluidStack)this.config).copy(), this.stock == null ? null : ((IAEFluidStack)this.stock).copy(), null);
    }

    protected MetaTileEntity getHolder() {
        return this.holder;
    }
}

