/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng.slot;

import appeng.api.storage.data.IAEFluidStack;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.ExportOnlyAEFluidSlot;
import net.minecraftforge.fluids.FluidStack;

public class ExportOnlyAEFluidList {
    protected final int size;
    protected ExportOnlyAEFluidSlot[] inventory;

    public ExportOnlyAEFluidList(MetaTileEntity holder, int slots, MetaTileEntity entityToNotify) {
        this.size = slots;
        this.createInventory(holder, entityToNotify);
    }

    protected void createInventory(MetaTileEntity holder, MetaTileEntity entityToNotify) {
        this.inventory = new ExportOnlyAEFluidSlot[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.inventory[i] = new ExportOnlyAEFluidSlot(holder, entityToNotify);
        }
    }

    public ExportOnlyAEFluidSlot[] getInventory() {
        return this.inventory;
    }

    public void clearConfig() {
        for (ExportOnlyAEFluidSlot slot : this.inventory) {
            slot.setConfig(null);
            slot.setStock(null);
        }
    }

    public boolean hasStackInConfig(FluidStack stack, boolean checkExternal) {
        if (stack == null) {
            return false;
        }
        for (ExportOnlyAEFluidSlot slot : this.inventory) {
            IAEFluidStack config = (IAEFluidStack)slot.getConfig();
            if (config == null || !config.getFluid().equals(stack.getFluid())) continue;
            return true;
        }
        return false;
    }

    public boolean isAutoPull() {
        return false;
    }

    public boolean isStocking() {
        return false;
    }

    public boolean ownsSlot(ExportOnlyAEFluidSlot testSlot) {
        for (ExportOnlyAEFluidSlot slot : this.inventory) {
            if (slot != testSlot) continue;
            return true;
        }
        return false;
    }
}

