/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart.appeng;

import appeng.api.config.Actionable;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.util.item.AEItemStack;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.INotifiableHandler;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockAbilityPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.gui.widget.appeng.AEItemGridWidget;
import gregtech.common.inventory.appeng.SerializableItemList;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.MetaTileEntityAEHostablePart;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMEOutputBus
extends MetaTileEntityAEHostablePart<IAEItemStack>
implements IMultiblockAbilityPart<IItemHandlerModifiable> {
    public static final String ITEM_BUFFER_TAG = "ItemBuffer";
    public static final String WORKING_TAG = "WorkingEnabled";
    private boolean workingEnabled = true;
    private SerializableItemList internalBuffer;

    public MetaTileEntityMEOutputBus(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId, 4, true, IItemStorageChannel.class);
    }

    @Override
    protected void initializeInventory() {
        this.internalBuffer = new SerializableItemList();
        super.initializeInventory();
    }

    @Override
    public void update() {
        super.update();
        if (!this.getWorld().field_72995_K && this.workingEnabled && this.shouldSyncME() && this.updateMEStatus()) {
            if (this.internalBuffer.isEmpty()) {
                return;
            }
            IMEMonitor monitor = this.getMonitor();
            if (monitor == null) {
                return;
            }
            Iterator<IAEItemStack> iterator = this.internalBuffer.iterator();
            while (iterator.hasNext()) {
                IAEItemStack item = iterator.next();
                IAEItemStack notInserted = (IAEItemStack)monitor.injectItems((IAEStack)item.copy(), Actionable.MODULATE, this.getActionSource());
                if (notInserted != null && notInserted.getStackSize() > 0L) {
                    item.setStackSize(notInserted.getStackSize());
                    continue;
                }
                item.reset();
            }
        }
    }

    @Override
    public void onRemoval() {
        IMEMonitor monitor = this.getMonitor();
        if (monitor != null) {
            Iterator<IAEItemStack> iterator = this.internalBuffer.iterator();
            while (iterator.hasNext()) {
                IAEItemStack item = iterator.next();
                monitor.injectItems((IAEStack)item.copy(), Actionable.MODULATE, this.getActionSource());
            }
        }
        super.onRemoval();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity iGregTechTileEntity) {
        return new MetaTileEntityMEOutputBus(this.metaTileEntityId);
    }

    @Override
    protected ModularUI createUI(EntityPlayer entityPlayer) {
        ModularUI.Builder builder = ModularUI.builder(GuiTextures.BACKGROUND, 176, 184).label(10, 5, this.getMetaFullName());
        builder.dynamicLabel(10, 15, () -> this.isOnline ? I18n.func_135052_a((String)"gregtech.gui.me_network.online", (Object[])new Object[0]) : I18n.func_135052_a((String)"gregtech.gui.me_network.offline", (Object[])new Object[0]), 0x404040);
        builder.label(10, 25, "gregtech.gui.waiting_list", -1);
        builder.widget(new AEItemGridWidget(10, 35, 3, this.internalBuffer));
        builder.bindPlayerInventory(entityPlayer.field_71071_by, GuiTextures.SLOT, 7, 102);
        return builder.build(this.getHolder(), entityPlayer);
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.workingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean workingEnabled) {
        this.workingEnabled = workingEnabled;
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(workingEnabled));
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.workingEnabled);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.workingEnabled = buf.readBoolean();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a(WORKING_TAG, this.workingEnabled);
        data.func_74782_a(ITEM_BUFFER_TAG, (NBTBase)this.internalBuffer.serializeNBT());
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(WORKING_TAG)) {
            this.workingEnabled = data.func_74767_n(WORKING_TAG);
        }
        if (data.func_150297_b(ITEM_BUFFER_TAG, 9)) {
            this.internalBuffer.deserializeNBT((NBTTagList)data.func_74781_a(ITEM_BUFFER_TAG));
        }
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        if (this.shouldRenderOverlay()) {
            if (this.isOnline) {
                Textures.ME_OUTPUT_BUS_ACTIVE.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            } else {
                Textures.ME_OUTPUT_BUS.renderSided(this.getFrontFacing(), renderState, translation, pipeline);
            }
        }
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        super.addInformation(stack, player, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.item_bus.export.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.item_export.tooltip", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.me.item_export.tooltip.2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.enabled", (Object[])new Object[0]));
    }

    @Override
    public MultiblockAbility<IItemHandlerModifiable> getAbility() {
        return MultiblockAbility.EXPORT_ITEMS;
    }

    @Override
    public void registerAbilities(List<IItemHandlerModifiable> abilityList) {
        abilityList.add(new InaccessibleInfiniteSlot(this, this.internalBuffer, this.getController()));
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        super.addToMultiBlock(controllerBase);
        if (controllerBase instanceof MultiblockWithDisplayBase) {
            ((MultiblockWithDisplayBase)controllerBase).enableItemInfSink();
        }
    }

    private static class InaccessibleInfiniteSlot
    implements IItemHandlerModifiable,
    INotifiableHandler {
        private final IItemList<IAEItemStack> internalBuffer;
        private final List<MetaTileEntity> notifiableEntities = new ArrayList<MetaTileEntity>();
        private final MetaTileEntity holder;

        public InaccessibleInfiniteSlot(MetaTileEntity holder, IItemList<IAEItemStack> internalBuffer, MetaTileEntity mte) {
            this.holder = holder;
            this.internalBuffer = internalBuffer;
            this.notifiableEntities.add(mte);
        }

        public void setStackInSlot(int slot, @NotNull ItemStack stack) {
            this.internalBuffer.add((IAEStack)AEItemStack.fromItemStack((ItemStack)stack));
            this.holder.markDirty();
            this.trigger();
        }

        public int getSlots() {
            return 1;
        }

        @NotNull
        public ItemStack getStackInSlot(int slot) {
            return ItemStack.field_190927_a;
        }

        @NotNull
        public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
            if (stack.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            if (!simulate) {
                this.internalBuffer.add((IAEStack)AEItemStack.fromItemStack((ItemStack)stack));
                this.holder.markDirty();
            }
            this.trigger();
            return ItemStack.field_190927_a;
        }

        @NotNull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.field_190927_a;
        }

        public int getSlotLimit(int slot) {
            return 0x7FFFFFFE;
        }

        @Override
        public void addNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
            this.notifiableEntities.add(metaTileEntity);
        }

        @Override
        public void removeNotifiableMetaTileEntity(MetaTileEntity metaTileEntity) {
            this.notifiableEntities.remove(metaTileEntity);
        }

        private void trigger() {
            for (MetaTileEntity metaTileEntity : this.notifiableEntities) {
                if (metaTileEntity == null || !metaTileEntity.isValid()) continue;
                this.addToNotifiedList(metaTileEntity, this, true);
            }
        }
    }
}

