/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.multiblockpart;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.INotifiableHandler;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.common.metatileentities.multi.multiblockpart.MetaTileEntityMultiblockPart;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.IFluidTank;

public abstract class MetaTileEntityMultiblockNotifiablePart
extends MetaTileEntityMultiblockPart {
    protected final boolean isExportHatch;

    public MetaTileEntityMultiblockNotifiablePart(ResourceLocation metaTileEntityId, int tier, boolean isExportHatch) {
        super(metaTileEntityId, tier);
        this.isExportHatch = isExportHatch;
    }

    private NotifiableItemStackHandler getItemHandler() {
        NotifiableItemStackHandler handler = null;
        if (this.isExportHatch && this.getExportItems() instanceof NotifiableItemStackHandler) {
            handler = (NotifiableItemStackHandler)this.getExportItems();
        } else if (!this.isExportHatch && this.getImportItems() instanceof NotifiableItemStackHandler) {
            handler = (NotifiableItemStackHandler)this.getImportItems();
        } else if (this.getItemInventory() instanceof NotifiableItemStackHandler) {
            handler = (NotifiableItemStackHandler)this.getItemInventory();
        }
        return handler;
    }

    private FluidTankList getFluidHandlers() {
        FluidTankList handler = null;
        if (this.isExportHatch && this.getExportFluids().getFluidTanks().size() > 0) {
            handler = this.getExportFluids();
        } else if (!this.isExportHatch && this.getImportFluids().getFluidTanks().size() > 0) {
            handler = this.getImportFluids();
        }
        return handler;
    }

    private List<INotifiableHandler> getPartHandlers() {
        FluidTankList fluidTankList;
        ArrayList<INotifiableHandler> handlerList = new ArrayList<INotifiableHandler>();
        NotifiableItemStackHandler itemHandler = this.getItemHandler();
        if (itemHandler != null && itemHandler.getSlots() > 0) {
            handlerList.add(itemHandler);
        }
        if (this.fluidInventory.getTankProperties().length > 0 && (fluidTankList = this.getFluidHandlers()) != null) {
            for (IFluidTank fluidTank : fluidTankList) {
                if (fluidTank instanceof IMultipleTankHandler.MultiFluidTankEntry) {
                    IMultipleTankHandler.MultiFluidTankEntry entry = (IMultipleTankHandler.MultiFluidTankEntry)fluidTank;
                    fluidTank = entry.getDelegate();
                }
                if (!(fluidTank instanceof INotifiableHandler)) continue;
                handlerList.add((INotifiableHandler)fluidTank);
            }
        }
        return handlerList;
    }

    @Override
    public void addToMultiBlock(MultiblockControllerBase controllerBase) {
        super.addToMultiBlock(controllerBase);
        List<INotifiableHandler> handlerList = this.getPartHandlers();
        for (INotifiableHandler handler : handlerList) {
            handler.addNotifiableMetaTileEntity(controllerBase);
            handler.addToNotifiedList(this, handler, this.isExportHatch);
        }
    }

    @Override
    public void removeFromMultiBlock(MultiblockControllerBase controllerBase) {
        super.removeFromMultiBlock(controllerBase);
        List<INotifiableHandler> handlerList = this.getPartHandlers();
        for (INotifiableHandler handler : handlerList) {
            handler.removeNotifiableMetaTileEntity(controllerBase);
        }
    }
}

