/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GregTechAPI;
import gregtech.api.capability.GregtechDataCodes;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IBatteryData;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.IProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.util.BlockInfo;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.TooltipHelper;
import gregtech.common.ConfigHolder;
import gregtech.common.blocks.BlockGlassCasing;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.metatileentities.MetaTileEntities;
import java.math.BigInteger;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class MetaTileEntityPowerSubstation
extends MultiblockWithDisplayBase
implements IControllable,
IProgressBarMultiblock {
    public static final int MAX_BATTERY_LAYERS = 18;
    private static final int MIN_CASINGS = 14;
    public static final long PASSIVE_DRAIN_DIVISOR = 172800000L;
    public static final long PASSIVE_DRAIN_MAX_PER_STORAGE = 100000L;
    private static final String NBT_ENERGY_BANK = "EnergyBank";
    private static final String PMC_BATTERY_HEADER = "PSSBattery_";
    private static final BigInteger BIG_INTEGER_MAX_LONG = BigInteger.valueOf(Long.MAX_VALUE);
    private PowerStationEnergyBank energyBank;
    private EnergyContainerList inputHatches;
    private EnergyContainerList outputHatches;
    private long passiveDrain;
    private boolean isActive;
    private boolean isWorkingEnabled = true;
    private long netInLastSec;
    private long averageInLastSec;
    private long netOutLastSec;
    private long averageOutLastSec;
    protected static final Supplier<TraceabilityPredicate> BATTERY_PREDICATE = () -> new TraceabilityPredicate(blockWorldState -> {
        IBlockState state = blockWorldState.getBlockState();
        if (GregTechAPI.PSS_BATTERIES.containsKey((Object)state)) {
            IBatteryData battery = (IBatteryData)GregTechAPI.PSS_BATTERIES.get((Object)state);
            if (battery.getTier() != -1 && battery.getCapacity() > 0L) {
                String key = PMC_BATTERY_HEADER + battery.getBatteryName();
                BatteryMatchWrapper wrapper = (BatteryMatchWrapper)blockWorldState.getMatchContext().get(key);
                if (wrapper == null) {
                    wrapper = new BatteryMatchWrapper(battery);
                }
                blockWorldState.getMatchContext().set(key, wrapper.increment());
            }
            return true;
        }
        return false;
    }, () -> (BlockInfo[])GregTechAPI.PSS_BATTERIES.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((IBatteryData)entry.getValue()).getTier())).map(entry -> new BlockInfo((IBlockState)entry.getKey(), null)).toArray(BlockInfo[]::new)).addTooltips("gregtech.multiblock.pattern.error.batteries");

    public MetaTileEntityPowerSubstation(ResourceLocation metaTileEntityId) {
        super(metaTileEntityId);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityPowerSubstation(this.metaTileEntityId);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        ArrayList<IEnergyContainer> inputs = new ArrayList<IEnergyContainer>();
        inputs.addAll(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
        inputs.addAll(this.getAbilities(MultiblockAbility.SUBSTATION_INPUT_ENERGY));
        inputs.addAll(this.getAbilities(MultiblockAbility.INPUT_LASER));
        this.inputHatches = new EnergyContainerList(inputs);
        ArrayList<IEnergyContainer> outputs = new ArrayList<IEnergyContainer>();
        outputs.addAll(this.getAbilities(MultiblockAbility.OUTPUT_ENERGY));
        outputs.addAll(this.getAbilities(MultiblockAbility.SUBSTATION_OUTPUT_ENERGY));
        outputs.addAll(this.getAbilities(MultiblockAbility.OUTPUT_LASER));
        this.outputHatches = new EnergyContainerList(outputs);
        ArrayList<IBatteryData> parts = new ArrayList<IBatteryData>();
        for (Map.Entry<String, Object> battery : context.entrySet()) {
            Object object;
            if (!battery.getKey().startsWith(PMC_BATTERY_HEADER) || !((object = battery.getValue()) instanceof BatteryMatchWrapper)) continue;
            BatteryMatchWrapper wrapper = (BatteryMatchWrapper)object;
            for (int i = 0; i < wrapper.amount; ++i) {
                parts.add(wrapper.partType);
            }
        }
        if (parts.isEmpty()) {
            this.invalidateStructure();
            return;
        }
        this.energyBank = this.energyBank == null ? new PowerStationEnergyBank(parts) : this.energyBank.rebuild(parts);
        this.passiveDrain = this.energyBank.getPassiveDrainPerTick();
    }

    @Override
    public void invalidateStructure() {
        this.inputHatches = null;
        this.outputHatches = null;
        this.passiveDrain = 0L;
        this.netInLastSec = 0L;
        this.averageInLastSec = 0L;
        this.netOutLastSec = 0L;
        this.averageOutLastSec = 0L;
        super.invalidateStructure();
    }

    @Override
    protected void updateFormedValid() {
        if (!this.getWorld().field_72995_K) {
            if (this.getOffsetTimer() % 20L == 0L) {
                this.setActive(this.energyBank.hasEnergy());
                this.averageInLastSec = this.netInLastSec / 20L;
                this.averageOutLastSec = this.netOutLastSec / 20L;
                this.netInLastSec = 0L;
                this.netOutLastSec = 0L;
            }
            if (this.isWorkingEnabled()) {
                long energyBanked = this.energyBank.fill(this.inputHatches.getEnergyStored());
                this.inputHatches.changeEnergy(-energyBanked);
                this.netInLastSec += energyBanked;
                long energyPassiveDrained = this.energyBank.drain(this.getPassiveDrain());
                this.netOutLastSec += energyPassiveDrained;
                long energyDebanked = this.energyBank.drain(this.outputHatches.getEnergyCapacity() - this.outputHatches.getEnergyStored());
                this.outputHatches.changeEnergy(energyDebanked);
                this.netOutLastSec += energyDebanked;
            }
        }
    }

    public long getPassiveDrain() {
        if (ConfigHolder.machines.enableMaintenance) {
            int multiplier = 1 + this.getNumMaintenanceProblems();
            double modifier = this.getMaintenanceDurationMultiplier();
            return (long)((double)(this.passiveDrain * (long)multiplier) * modifier);
        }
        return this.passiveDrain;
    }

    @Override
    public boolean isActive() {
        return super.isActive() && this.isActive;
    }

    public void setActive(boolean active) {
        if (this.isActive != active) {
            this.isActive = active;
            this.markDirty();
            World world = this.getWorld();
            if (world != null && !world.field_72995_K) {
                this.writeCustomData(GregtechDataCodes.WORKABLE_ACTIVE, buf -> buf.writeBoolean(active));
            }
        }
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.isWorkingEnabled;
    }

    @Override
    public void setWorkingEnabled(boolean isWorkingAllowed) {
        this.isWorkingEnabled = isWorkingAllowed;
        this.markDirty();
        World world = this.getWorld();
        if (world != null && !world.field_72995_K) {
            this.writeCustomData(GregtechDataCodes.WORKING_ENABLED, buf -> buf.writeBoolean(this.isWorkingEnabled));
        }
    }

    @Override
    protected boolean shouldShowVoidingModeButton() {
        return false;
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start(RelativeDirection.RIGHT, RelativeDirection.FRONT, RelativeDirection.UP).aisle("XXSXX", "XXXXX", "XXXXX", "XXXXX", "XXXXX").aisle("XXXXX", "XCCCX", "XCCCX", "XCCCX", "XXXXX").aisle("GGGGG", "GBBBG", "GBBBG", "GBBBG", "GGGGG").setRepeatable(1, 18).aisle("GGGGG", "GGGGG", "GGGGG", "GGGGG", "GGGGG").where('S', this.selfPredicate()).where('C', MetaTileEntityPowerSubstation.states(this.getCasingState())).where('X', MetaTileEntityPowerSubstation.states(this.getCasingState()).setMinGlobalLimited(14).or(this.maintenancePredicate()).or(MetaTileEntityPowerSubstation.abilities(MultiblockAbility.INPUT_ENERGY, MultiblockAbility.SUBSTATION_INPUT_ENERGY, MultiblockAbility.INPUT_LASER).setMinGlobalLimited(1)).or(MetaTileEntityPowerSubstation.abilities(MultiblockAbility.OUTPUT_ENERGY, MultiblockAbility.SUBSTATION_OUTPUT_ENERGY, MultiblockAbility.OUTPUT_LASER).setMinGlobalLimited(1))).where('G', MetaTileEntityPowerSubstation.states(this.getGlassState())).where('B', BATTERY_PREDICATE.get()).build();
    }

    @Override
    public List<MultiblockShapeInfo> getMatchingShapes() {
        ArrayList<MultiblockShapeInfo> shapeInfo = new ArrayList<MultiblockShapeInfo>();
        MultiblockShapeInfo.Builder builder = MultiblockShapeInfo.builder().aisle("CCCCC", "CCCCC", "GGGGG", "GGGGG", "GGGGG").aisle("CCCCC", "CCCCC", "GBBBG", "GBBBG", "GGGGG").aisle("CCCCC", "CCCCC", "GBBBG", "GBBBG", "GGGGG").aisle("CCCCC", "CCCCC", "GBBBG", "GBBBG", "GGGGG").aisle("ICSCO", "NCMCT", "GGGGG", "GGGGG", "GGGGG").where('S', MetaTileEntities.POWER_SUBSTATION, EnumFacing.SOUTH).where('C', this.getCasingState()).where('G', this.getGlassState()).where('I', MetaTileEntities.ENERGY_INPUT_HATCH[3], EnumFacing.SOUTH).where('N', MetaTileEntities.SUBSTATION_ENERGY_INPUT_HATCH[0], EnumFacing.SOUTH).where('O', MetaTileEntities.ENERGY_OUTPUT_HATCH[3], EnumFacing.SOUTH).where('T', MetaTileEntities.SUBSTATION_ENERGY_OUTPUT_HATCH[0], EnumFacing.SOUTH).where('M', () -> ConfigHolder.machines.enableMaintenance ? MetaTileEntities.MAINTENANCE_HATCH : MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.PALLADIUM_SUBSTATION), EnumFacing.SOUTH);
        GregTechAPI.PSS_BATTERIES.entrySet().stream().filter(entry -> ((IBatteryData)entry.getValue()).getCapacity() > 0L).sorted(Comparator.comparingInt(entry -> ((IBatteryData)entry.getValue()).getTier())).forEach(entry -> shapeInfo.add(builder.where('B', (IBlockState)entry.getKey()).build()));
        return shapeInfo;
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.PALLADIUM_SUBSTATION);
    }

    protected IBlockState getGlassState() {
        return MetaBlocks.TRANSPARENT_CASING.getState(BlockGlassCasing.CasingType.LAMINATED_GLASS);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.PALLADIUM_SUBSTATION_CASING;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.POWER_SUBSTATION_OVERLAY;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.isActive(), this.isWorkingEnabled());
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, this.isStructureFormed()).setWorkingStatus(true, this.isActive() && this.isWorkingEnabled()).setWorkingStatusKeys("gregtech.multiblock.idling", "gregtech.multiblock.idling", "gregtech.machine.active_transformer.routing").addCustom(tl -> {
            if (this.isStructureFormed() && this.energyBank != null) {
                BigInteger energyStored = this.energyBank.getStored();
                BigInteger energyCapacity = this.energyBank.getCapacity();
                TextComponentString storedFormatted = TextComponentUtil.stringWithColor(TextFormatting.GOLD, TextFormattingUtil.formatNumbers(energyStored) + " EU");
                tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.power_substation.stored", storedFormatted));
                TextComponentString capacityFormatted = TextComponentUtil.stringWithColor(TextFormatting.GOLD, TextFormattingUtil.formatNumbers(energyCapacity) + " EU");
                tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.power_substation.capacity", capacityFormatted));
                TextComponentString passiveDrain = TextComponentUtil.stringWithColor(TextFormatting.DARK_RED, TextFormattingUtil.formatNumbers(this.getPassiveDrain()) + " EU/t");
                tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.power_substation.passive_drain", passiveDrain));
                TextComponentString avgValue = TextComponentUtil.stringWithColor(TextFormatting.GREEN, TextFormattingUtil.formatNumbers(this.averageInLastSec) + " EU/t");
                TextComponentTranslation base = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.power_substation.average_in", avgValue);
                TextComponentTranslation hover = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.power_substation.average_in_hover", new Object[0]);
                tl.add(TextComponentUtil.setHover((ITextComponent)base, new ITextComponent[]{hover}));
                avgValue = TextComponentUtil.stringWithColor(TextFormatting.RED, TextFormattingUtil.formatNumbers(this.averageOutLastSec) + " EU/t");
                base = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.power_substation.average_out", avgValue);
                hover = TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.power_substation.average_out_hover", new Object[0]);
                tl.add(TextComponentUtil.setHover((ITextComponent)base, new ITextComponent[]{hover}));
                if (this.averageInLastSec > this.averageOutLastSec) {
                    ITextComponent timeToFill = MetaTileEntityPowerSubstation.getTimeToFillDrainText(energyCapacity.subtract(energyStored).divide(BigInteger.valueOf((this.averageInLastSec - this.averageOutLastSec) * 20L)));
                    TextComponentUtil.setColor(timeToFill, TextFormatting.GREEN);
                    tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.power_substation.time_to_fill", timeToFill));
                } else if (this.averageInLastSec < this.averageOutLastSec) {
                    ITextComponent timeToDrain = MetaTileEntityPowerSubstation.getTimeToFillDrainText(energyStored.divide(BigInteger.valueOf((this.averageOutLastSec - this.averageInLastSec) * 20L)));
                    TextComponentUtil.setColor(timeToDrain, TextFormatting.RED);
                    tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.power_substation.time_to_drain", timeToDrain));
                }
            }
        }).addWorkingStatusLine();
    }

    @Override
    protected void addWarningText(List<ITextComponent> textList) {
        BigInteger timeToDrainSeconds;
        super.addWarningText(textList);
        if (this.isStructureFormed() && this.averageInLastSec < this.averageOutLastSec && (timeToDrainSeconds = this.energyBank.getStored().divide(BigInteger.valueOf((this.averageOutLastSec - this.averageInLastSec) * 20L))).compareTo(BigInteger.valueOf(3600L)) < 0) {
            textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.multiblock.power_substation.under_one_hour_left", new Object[0]));
        }
    }

    private static ITextComponent getTimeToFillDrainText(BigInteger timeToFillSeconds) {
        String key;
        long fillTime;
        Duration duration;
        if (timeToFillSeconds.compareTo(BIG_INTEGER_MAX_LONG) > 0) {
            timeToFillSeconds = BIG_INTEGER_MAX_LONG;
        }
        if ((duration = Duration.ofSeconds(timeToFillSeconds.longValue())).getSeconds() <= 180L) {
            fillTime = duration.getSeconds();
            key = "gregtech.multiblock.power_substation.time_seconds";
        } else if (duration.toMinutes() <= 180L) {
            fillTime = duration.toMinutes();
            key = "gregtech.multiblock.power_substation.time_minutes";
        } else if (duration.toHours() <= 72L) {
            fillTime = duration.toHours();
            key = "gregtech.multiblock.power_substation.time_hours";
        } else if (duration.toDays() <= 730L) {
            fillTime = duration.toDays();
            key = "gregtech.multiblock.power_substation.time_days";
        } else if (duration.toDays() / 365L < 1000000L) {
            fillTime = duration.toDays() / 365L;
            key = "gregtech.multiblock.power_substation.time_years";
        } else {
            return new TextComponentTranslation("gregtech.multiblock.power_substation.time_forever", new Object[0]);
        }
        return new TextComponentTranslation(key, new Object[]{TextFormattingUtil.formatNumbers(fillTime)});
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("isActive", this.isActive);
        data.func_74757_a("isWorkingEnabled", this.isWorkingEnabled);
        if (this.energyBank != null) {
            data.func_74782_a(NBT_ENERGY_BANK, (NBTBase)this.energyBank.writeToNBT(new NBTTagCompound()));
        }
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.isActive = data.func_74767_n("isActive");
        this.isWorkingEnabled = data.func_74767_n("isWorkingEnabled");
        if (data.func_74764_b(NBT_ENERGY_BANK)) {
            this.energyBank = new PowerStationEnergyBank(data.func_74775_l(NBT_ENERGY_BANK));
        }
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        buf.writeBoolean(this.isActive);
        buf.writeBoolean(this.isWorkingEnabled);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.isActive = buf.readBoolean();
        this.isWorkingEnabled = buf.readBoolean();
    }

    @Override
    public void receiveCustomData(int dataId, @NotNull PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        if (dataId == GregtechDataCodes.WORKABLE_ACTIVE) {
            this.isActive = buf.readBoolean();
            this.scheduleRenderUpdate();
        } else if (dataId == GregtechDataCodes.WORKING_ENABLED) {
            this.isWorkingEnabled = buf.readBoolean();
            this.scheduleRenderUpdate();
        }
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.power_substation.tooltip1", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.power_substation.tooltip2", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.power_substation.tooltip3", (Object[])new Object[]{18}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.power_substation.tooltip4", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.power_substation.tooltip5", (Object[])new Object[]{100000L}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.power_substation.tooltip6", (Object[])new Object[0]) + TooltipHelper.RAINBOW_SLOW + I18n.func_135052_a((String)"gregtech.machine.power_substation.tooltip6.5", (Object[])new Object[0]));
    }

    public String getStored() {
        if (this.energyBank == null) {
            return "0";
        }
        return TextFormattingUtil.formatNumbers(this.energyBank.getStored());
    }

    public long getStoredLong() {
        if (this.energyBank == null) {
            return 0L;
        }
        return this.energyBank.getStored().longValue() & Long.MAX_VALUE;
    }

    public long getCapacityLong() {
        if (this.energyBank == null) {
            return 0L;
        }
        return this.energyBank.getCapacity().longValue() & Long.MAX_VALUE;
    }

    public String getCapacity() {
        if (this.energyBank == null) {
            return "0";
        }
        return TextFormattingUtil.formatNumbers(this.energyBank.getCapacity());
    }

    public long getAverageInLastSec() {
        return this.averageInLastSec;
    }

    public long getAverageOutLastSec() {
        return this.averageOutLastSec;
    }

    @Override
    public double getFillPercentage(int index) {
        if (this.energyBank == null) {
            return 0.0;
        }
        return this.energyBank.getStored().doubleValue() / this.energyBank.getCapacity().doubleValue();
    }

    @Override
    public void addBarHoverText(List<ITextComponent> hoverList, int index) {
        String stored = this.energyBank != null ? TextFormattingUtil.formatNumbers(this.energyBank.getStored()) : "0";
        String capacity = this.energyBank != null ? TextFormattingUtil.formatNumbers(this.energyBank.getCapacity()) : "0";
        TextComponentString energyInfo = TextComponentUtil.stringWithColor(TextFormatting.YELLOW, stored + " / " + capacity + " EU");
        hoverList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.energy_stored", energyInfo));
    }

    private static class BatteryMatchWrapper {
        private final IBatteryData partType;
        private int amount;

        public BatteryMatchWrapper(IBatteryData partType) {
            this.partType = partType;
        }

        public BatteryMatchWrapper increment() {
            ++this.amount;
            return this;
        }
    }

    public static class PowerStationEnergyBank {
        private static final String NBT_SIZE = "Size";
        private static final String NBT_STORED = "Stored";
        private static final String NBT_MAX = "Max";
        private final long[] storage;
        private final long[] maximums;
        private final BigInteger capacity;
        private int index;

        public PowerStationEnergyBank(List<IBatteryData> batteries) {
            this.storage = new long[batteries.size()];
            this.maximums = new long[batteries.size()];
            for (int i = 0; i < batteries.size(); ++i) {
                this.maximums[i] = batteries.get(i).getCapacity();
            }
            this.capacity = PowerStationEnergyBank.summarize(this.maximums);
        }

        public PowerStationEnergyBank(NBTTagCompound storageTag) {
            int size = storageTag.func_74762_e(NBT_SIZE);
            this.storage = new long[size];
            this.maximums = new long[size];
            for (int i = 0; i < size; ++i) {
                NBTTagCompound subtag = storageTag.func_74775_l(String.valueOf(i));
                if (subtag.func_74764_b(NBT_STORED)) {
                    this.storage[i] = subtag.func_74763_f(NBT_STORED);
                }
                this.maximums[i] = subtag.func_74763_f(NBT_MAX);
            }
            this.capacity = PowerStationEnergyBank.summarize(this.maximums);
        }

        private NBTTagCompound writeToNBT(NBTTagCompound compound) {
            compound.func_74768_a(NBT_SIZE, this.storage.length);
            for (int i = 0; i < this.storage.length; ++i) {
                NBTTagCompound subtag = new NBTTagCompound();
                if (this.storage[i] > 0L) {
                    subtag.func_74772_a(NBT_STORED, this.storage[i]);
                }
                subtag.func_74772_a(NBT_MAX, this.maximums[i]);
                compound.func_74782_a(String.valueOf(i), (NBTBase)subtag);
            }
            return compound;
        }

        public PowerStationEnergyBank rebuild(@NotNull List<IBatteryData> batteries) {
            if (batteries.isEmpty()) {
                throw new IllegalArgumentException("Cannot rebuild Power Substation power bank with no batteries!");
            }
            PowerStationEnergyBank newStorage = new PowerStationEnergyBank(batteries);
            for (long stored : this.storage) {
                newStorage.fill(stored);
            }
            return newStorage;
        }

        public long fill(long amount) {
            long maxFill;
            if (amount < 0L) {
                throw new IllegalArgumentException("Amount cannot be negative!");
            }
            if (this.index != this.storage.length - 1 && this.storage[this.index] == this.maximums[this.index]) {
                ++this.index;
            }
            if ((maxFill = Math.min(this.maximums[this.index] - this.storage[this.index], amount)) == 0L && this.index == this.storage.length - 1) {
                return 0L;
            }
            int n = this.index;
            this.storage[n] = this.storage[n] + maxFill;
            if ((amount -= maxFill) > 0L && this.index != this.storage.length - 1) {
                return maxFill + this.fill(amount);
            }
            return maxFill;
        }

        public long drain(long amount) {
            long maxDrain;
            if (amount < 0L) {
                throw new IllegalArgumentException("Amount cannot be negative!");
            }
            if (this.index != 0 && this.storage[this.index] == 0L) {
                --this.index;
            }
            if ((maxDrain = Math.min(this.storage[this.index], amount)) == 0L && this.index == 0) {
                return 0L;
            }
            int n = this.index;
            this.storage[n] = this.storage[n] - maxDrain;
            if ((amount -= maxDrain) > 0L && this.index != 0) {
                --this.index;
                return maxDrain + this.drain(amount);
            }
            return maxDrain;
        }

        public BigInteger getCapacity() {
            return this.capacity;
        }

        public BigInteger getStored() {
            return PowerStationEnergyBank.summarize(this.storage);
        }

        public boolean hasEnergy() {
            for (long l : this.storage) {
                if (l <= 0L) continue;
                return true;
            }
            return false;
        }

        private static BigInteger summarize(long[] values) {
            BigInteger retVal = BigInteger.ZERO;
            long currentSum = 0L;
            for (long value : values) {
                if (currentSum != 0L && value > Long.MAX_VALUE - currentSum) {
                    retVal = retVal.add(BigInteger.valueOf(currentSum));
                    currentSum = 0L;
                }
                currentSum += value;
            }
            if (currentSum != 0L) {
                retVal = retVal.add(BigInteger.valueOf(currentSum));
            }
            return retVal;
        }

        @VisibleForTesting
        public long getPassiveDrainPerTick() {
            long[] maximumsExcl = new long[this.maximums.length];
            int index = 0;
            int numExcl = 0;
            for (long maximum : this.maximums) {
                if (maximum / 172800000L >= 100000L) {
                    ++numExcl;
                    continue;
                }
                maximumsExcl[index++] = maximum;
            }
            maximumsExcl = Arrays.copyOf(maximumsExcl, index);
            BigInteger capacityExcl = PowerStationEnergyBank.summarize(maximumsExcl);
            return capacityExcl.divide(BigInteger.valueOf(172800000L)).add(BigInteger.valueOf(100000L * (long)numExcl)).longValue();
        }
    }
}

