/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import com.google.common.collect.Lists;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.IWorkable;
import gregtech.api.capability.impl.EnergyContainerList;
import gregtech.api.capability.impl.FluidDrillLogic;
import gregtech.api.capability.impl.FluidTankList;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.metatileentity.ITieredMetaTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.IProgressBarMultiblock;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.MultiblockDisplayText;
import gregtech.api.metatileentity.multiblock.MultiblockWithDisplayBase;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.pattern.TraceabilityPredicate;
import gregtech.api.unification.material.Materials;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.TextComponentUtil;
import gregtech.api.util.TextFormattingUtil;
import gregtech.api.worldgen.bedrockFluids.BedrockFluidVeinHandler;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityFluidDrill
extends MultiblockWithDisplayBase
implements ITieredMetaTileEntity,
IWorkable,
IProgressBarMultiblock {
    private final FluidDrillLogic minerLogic = new FluidDrillLogic(this);
    private final int tier;
    protected IMultipleTankHandler inputFluidInventory;
    protected IMultipleTankHandler outputFluidInventory;
    protected IEnergyContainer energyContainer;

    public MetaTileEntityFluidDrill(ResourceLocation metaTileEntityId, int tier) {
        super(metaTileEntityId);
        this.tier = tier;
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityFluidDrill(this.metaTileEntityId, this.tier);
    }

    protected void initializeAbilities() {
        this.inputFluidInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.IMPORT_FLUIDS));
        this.outputFluidInventory = new FluidTankList(true, this.getAbilities(MultiblockAbility.EXPORT_FLUIDS));
        this.energyContainer = new EnergyContainerList(this.getAbilities(MultiblockAbility.INPUT_ENERGY));
    }

    private void resetTileAbilities() {
        this.inputFluidInventory = new FluidTankList(true, new IFluidTank[0]);
        this.outputFluidInventory = new FluidTankList(true, new IFluidTank[0]);
        this.energyContainer = new EnergyContainerList(Lists.newArrayList());
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        this.initializeAbilities();
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        this.resetTileAbilities();
    }

    @Override
    protected void updateFormedValid() {
        this.minerLogic.performDrilling();
        if (!this.getWorld().field_72995_K && this.minerLogic.wasActiveAndNeedsUpdate()) {
            this.minerLogic.setWasActiveAndNeedsUpdate(false);
            this.minerLogic.setActive(false);
        }
    }

    @Override
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start().aisle("XXX", "#F#", "#F#", "#F#", "###", "###", "###").aisle("XXX", "FCF", "FCF", "FCF", "#F#", "#F#", "#F#").aisle("XSX", "#F#", "#F#", "#F#", "###", "###", "###").where('S', this.selfPredicate()).where('X', MetaTileEntityFluidDrill.states(this.getCasingState()).setMinGlobalLimited(3).or(MetaTileEntityFluidDrill.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3)).or(MetaTileEntityFluidDrill.abilities(MultiblockAbility.EXPORT_FLUIDS).setMaxGlobalLimited(1))).where('C', MetaTileEntityFluidDrill.states(this.getCasingState())).where('F', this.getFramePredicate()).where('#', MetaTileEntityFluidDrill.any()).build();
    }

    private IBlockState getCasingState() {
        if (this.tier == 2) {
            return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STEEL_SOLID);
        }
        if (this.tier == 3) {
            return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TITANIUM_STABLE);
        }
        if (this.tier == 4) {
            return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.TUNGSTENSTEEL_ROBUST);
        }
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STEEL_SOLID);
    }

    @NotNull
    private TraceabilityPredicate getFramePredicate() {
        if (this.tier == 2) {
            return MetaTileEntityFluidDrill.frames(Materials.Steel);
        }
        if (this.tier == 3) {
            return MetaTileEntityFluidDrill.frames(Materials.Titanium);
        }
        if (this.tier == 4) {
            return MetaTileEntityFluidDrill.frames(Materials.TungstenSteel);
        }
        return MetaTileEntityFluidDrill.frames(Materials.Steel);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        if (this.tier == 2) {
            return Textures.SOLID_STEEL_CASING;
        }
        if (this.tier == 3) {
            return Textures.STABLE_TITANIUM_CASING;
        }
        if (this.tier == 4) {
            return Textures.ROBUST_TUNGSTENSTEEL_CASING;
        }
        return Textures.SOLID_STEEL_CASING;
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, this.isStructureFormed()).setWorkingStatus(this.minerLogic.isWorkingEnabled(), this.minerLogic.isActive()).setWorkingStatusKeys("gregtech.multiblock.idling", "gregtech.multiblock.work_paused", "gregtech.multiblock.miner.drilling").addEnergyUsageLine(this.energyContainer).addCustom(tl -> {
            if (this.isStructureFormed()) {
                if (this.minerLogic.getDrilledFluid() != null) {
                    Fluid drilledFluid = this.minerLogic.getDrilledFluid();
                    ITextComponent fluidInfo = TextComponentUtil.setColor((ITextComponent)GTUtility.getFluidTranslation(drilledFluid), TextFormatting.GREEN);
                    tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.fluid_rig.drilled_fluid", fluidInfo));
                    TextComponentString amountInfo = TextComponentUtil.stringWithColor(TextFormatting.BLUE, TextFormattingUtil.formatNumbers((long)this.minerLogic.getFluidToProduce() * 20L / 20L) + " L/s");
                    tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.fluid_rig.fluid_amount", amountInfo));
                } else {
                    TextComponentTranslation noFluid = TextComponentUtil.translationWithColor(TextFormatting.RED, "gregtech.multiblock.fluid_rig.no_fluid_in_area", new Object[0]);
                    tl.add(TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.fluid_rig.drilled_fluid", noFluid));
                }
            }
        }).addWorkingStatusLine().addProgressLine(this.minerLogic.getProgressPercent());
    }

    @Override
    protected void addWarningText(List<ITextComponent> textList) {
        MultiblockDisplayText.builder(textList, this.isStructureFormed(), false).addLowPowerLine(this.isStructureFormed() && !this.drainEnergy(true)).addCustom(tl -> {
            if (this.isStructureFormed() && this.minerLogic.isInventoryFull()) {
                tl.add(TextComponentUtil.translationWithColor(TextFormatting.YELLOW, "gregtech.machine.miner.invfull", new Object[0]));
            }
        });
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_drilling_rig.description", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_drilling_rig.depletion", (Object[])new Object[]{TextFormattingUtil.formatNumbers(100.0 / (double)this.getDepletionChance())}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_tier_range", (Object[])new Object[]{GTValues.VNF[this.tier], GTValues.VNF[this.tier + 1]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_drilling_rig.production", (Object[])new Object[]{this.getRigMultiplier(), TextFormattingUtil.formatNumbers((double)this.getRigMultiplier() * 1.5)}));
        if (this.tier > 2) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.machine.fluid_drilling_rig.shows_depletion", (Object[])new Object[0]));
        }
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.access_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public int getTier() {
        return this.tier;
    }

    public int getRigMultiplier() {
        if (this.tier == 2) {
            return 1;
        }
        if (this.tier == 3) {
            return 16;
        }
        if (this.tier == 4) {
            return 64;
        }
        return 1;
    }

    public int getDepletionChance() {
        if (this.tier == 2) {
            return 1;
        }
        if (this.tier == 3) {
            return 2;
        }
        if (this.tier == 4) {
            return 8;
        }
        return 1;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.FLUID_RIG_OVERLAY;
    }

    @Override
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        this.getFrontOverlay().renderOrientedState(renderState, translation, pipeline, this.getFrontFacing(), this.minerLogic.isActive(), this.minerLogic.isWorkingEnabled());
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.minerLogic.isWorkingEnabled();
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.minerLogic.setWorkingEnabled(isActivationAllowed);
    }

    public boolean fillTanks(FluidStack stack, boolean simulate) {
        return GTTransferUtils.addFluidsToFluidHandler(this.outputFluidInventory, simulate, Collections.singletonList(stack));
    }

    public int getEnergyTier() {
        if (this.energyContainer == null) {
            return this.tier;
        }
        return Math.min(this.tier + 1, Math.max(this.tier, GTUtility.getFloorTierByVoltage(this.energyContainer.getInputVoltage())));
    }

    public long getEnergyInputPerSecond() {
        return this.energyContainer.getInputPerSec();
    }

    public boolean drainEnergy(boolean simulate) {
        long energyToDrain = GTValues.VA[this.getEnergyTier()];
        long resultEnergy = this.energyContainer.getEnergyStored() - energyToDrain;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.changeEnergy(-energyToDrain);
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean hasMaintenanceMechanics() {
        return false;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        return this.minerLogic.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.minerLogic.readFromNBT(data);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        this.minerLogic.writeInitialSyncData(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.minerLogic.receiveInitialSyncData(buf);
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        this.minerLogic.receiveCustomData(dataId, buf);
    }

    @Override
    public int getProgress() {
        return this.minerLogic.getProgressTime();
    }

    @Override
    public int getMaxProgress() {
        return 20;
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_WORKABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_WORKABLE.cast((Object)this);
        }
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    protected boolean shouldShowVoidingModeButton() {
        return false;
    }

    @Override
    public boolean showProgressBar() {
        return this.tier > 2;
    }

    @Override
    public double getFillPercentage(int index) {
        int numOperationsLeft = BedrockFluidVeinHandler.getOperationsRemaining(this.getWorld(), this.minerLogic.getChunkX(), this.minerLogic.getChunkZ());
        int maxOperations = 100000;
        return 1.0 * (double)numOperationsLeft / (double)maxOperations;
    }

    @Override
    public TextureArea getProgressBarTexture(int index) {
        return GuiTextures.PROGRESS_BAR_FLUID_RIG_DEPLETION;
    }

    @Override
    public void addBarHoverText(List<ITextComponent> hoverList, int index) {
        TextFormatting color;
        int maxOperations;
        int numOperationsLeft = BedrockFluidVeinHandler.getOperationsRemaining(this.getWorld(), this.minerLogic.getChunkX(), this.minerLogic.getChunkZ());
        int percentage = (int)Math.round(1.0 * (double)numOperationsLeft / (double)(maxOperations = 100000) * 100.0);
        TextFormatting textFormatting = percentage > 40 ? TextFormatting.GREEN : (color = percentage > 10 ? TextFormatting.YELLOW : TextFormatting.RED);
        if (numOperationsLeft == 0) {
            hoverList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.RED, "gregtech.multiblock.fluid_rig.vein_depleted", new Object[0]));
        } else {
            TextComponentString veinInfo = TextComponentUtil.stringWithColor(color, percentage + "%");
            hoverList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.fluid_rig.vein_depletion", veinInfo));
        }
    }

    @Override
    public boolean allowsExtendedFacing() {
        return false;
    }
}

