/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.multi.electric;

import gregtech.api.capability.IDistillationTower;
import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.capability.impl.DistillationTowerLogicHandler;
import gregtech.api.capability.impl.MultiblockRecipeLogic;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.IMultiblockPart;
import gregtech.api.metatileentity.multiblock.MultiblockAbility;
import gregtech.api.metatileentity.multiblock.RecipeMapMultiblockController;
import gregtech.api.pattern.BlockPattern;
import gregtech.api.pattern.FactoryBlockPattern;
import gregtech.api.pattern.PatternMatchContext;
import gregtech.api.recipes.Recipe;
import gregtech.api.recipes.RecipeMaps;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.api.util.RelativeDirection;
import gregtech.api.util.TextComponentUtil;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.blocks.BlockMetalCasing;
import gregtech.common.blocks.MetaBlocks;
import gregtech.core.sound.GTSoundEvents;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class MetaTileEntityDistillationTower
extends RecipeMapMultiblockController
implements IDistillationTower {
    protected DistillationTowerLogicHandler handler;

    public MetaTileEntityDistillationTower(ResourceLocation metaTileEntityId) {
        this(metaTileEntityId, false);
    }

    public MetaTileEntityDistillationTower(ResourceLocation metaTileEntityId, boolean useAdvHatchLogic) {
        super(metaTileEntityId, RecipeMaps.DISTILLATION_RECIPES);
        if (useAdvHatchLogic) {
            this.recipeMapWorkable = new DistillationTowerRecipeLogic(this);
            this.handler = new DistillationTowerLogicHandler(this);
        } else {
            this.handler = null;
        }
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityDistillationTower(this.metaTileEntityId, this.handler != null);
    }

    @Override
    protected Function<BlockPos, Integer> multiblockPartSorter() {
        return RelativeDirection.UP.getSorter(this.getFrontFacing(), this.getUpwardsFacing(), this.isFlipped());
    }

    @Override
    public boolean allowsExtendedFacing() {
        return false;
    }

    @Override
    protected void addDisplayText(List<ITextComponent> textList) {
        FluidStack stackInTank;
        if (this.isStructureFormed() && (stackInTank = this.importFluids.drain(Integer.MAX_VALUE, false)) != null && stackInTank.amount > 0) {
            ITextComponent fluidName = TextComponentUtil.setColor((ITextComponent)GTUtility.getFluidTranslation(stackInTank), TextFormatting.AQUA);
            textList.add((ITextComponent)TextComponentUtil.translationWithColor(TextFormatting.GRAY, "gregtech.multiblock.distillation_tower.distilling_fluid", fluidName));
        }
        super.addDisplayText(textList);
    }

    @Override
    protected void formStructure(PatternMatchContext context) {
        super.formStructure(context);
        if (this.handler == null || this.structurePattern == null) {
            return;
        }
        this.handler.determineLayerCount(this.structurePattern);
        this.handler.determineOrderedFluidOutputs();
    }

    @Override
    public void invalidateStructure() {
        super.invalidateStructure();
        if (this.handler != null) {
            this.handler.invalidate();
        }
    }

    @Override
    @NotNull
    protected BlockPattern createStructurePattern() {
        return FactoryBlockPattern.start(RelativeDirection.RIGHT, RelativeDirection.FRONT, RelativeDirection.UP).aisle("YSY", "YYY", "YYY").aisle("XXX", "X#X", "XXX").setRepeatable(1, 11).aisle("XXX", "XXX", "XXX").where('S', this.selfPredicate()).where('Y', MetaTileEntityDistillationTower.states(this.getCasingState()).or(MetaTileEntityDistillationTower.abilities(MultiblockAbility.EXPORT_ITEMS).setMaxGlobalLimited(1)).or(MetaTileEntityDistillationTower.abilities(MultiblockAbility.INPUT_ENERGY).setMinGlobalLimited(1).setMaxGlobalLimited(3)).or(MetaTileEntityDistillationTower.abilities(MultiblockAbility.IMPORT_FLUIDS).setExactLimit(1))).where('X', MetaTileEntityDistillationTower.states(this.getCasingState()).or(MetaTileEntityDistillationTower.abilities(MultiblockAbility.EXPORT_FLUIDS).setMaxLayerLimited(1, 1)).or(this.autoAbilities(true, false))).where('#', MetaTileEntityDistillationTower.air()).build();
    }

    @Override
    public boolean allowSameFluidFillForOutputs() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ICubeRenderer getBaseTexture(IMultiblockPart sourcePart) {
        return Textures.CLEAN_STAINLESS_STEEL_CASING;
    }

    protected IBlockState getCasingState() {
        return MetaBlocks.METAL_CASING.getState(BlockMetalCasing.MetalCasingType.STAINLESS_CLEAN);
    }

    @Override
    public SoundEvent getBreakdownSound() {
        return GTSoundEvents.BREAKDOWN_ELECTRICAL;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    @NotNull
    protected ICubeRenderer getFrontOverlay() {
        return Textures.DISTILLATION_TOWER_OVERLAY;
    }

    @Override
    public int getFluidOutputLimit() {
        if (this.handler != null) {
            return this.handler.getLayerCount();
        }
        return super.getFluidOutputLimit();
    }

    protected class DistillationTowerRecipeLogic
    extends MultiblockRecipeLogic {
        public DistillationTowerRecipeLogic(MetaTileEntityDistillationTower tileEntity) {
            super(tileEntity);
        }

        @Override
        protected void outputRecipeOutputs() {
            GTTransferUtils.addItemsToItemHandler((IItemHandler)this.getOutputInventory(), false, (List<ItemStack>)this.itemOutputs);
            MetaTileEntityDistillationTower.this.handler.applyFluidToOutputs(this.fluidOutputs, true);
        }

        @Override
        protected boolean setupAndConsumeRecipeInputs(@NotNull Recipe recipe, @NotNull IItemHandlerModifiable importInventory, @NotNull IMultipleTankHandler importFluids) {
            this.overclockResults = this.calculateOverclock(recipe);
            this.modifyOverclockPost(this.overclockResults, recipe.getRecipePropertyStorage());
            if (!this.hasEnoughPower(this.overclockResults)) {
                return false;
            }
            IItemHandlerModifiable exportInventory = this.getOutputInventory();
            if (!this.metaTileEntity.canVoidRecipeItemOutputs() && !GTTransferUtils.addItemsToItemHandler((IItemHandler)exportInventory, true, recipe.getAllItemOutputs())) {
                this.isOutputsFull = true;
                return false;
            }
            if (!this.metaTileEntity.canVoidRecipeFluidOutputs() && !MetaTileEntityDistillationTower.this.handler.applyFluidToOutputs(recipe.getAllFluidOutputs(), false)) {
                this.isOutputsFull = true;
                return false;
            }
            this.isOutputsFull = false;
            if (recipe.matches(true, importInventory, importFluids)) {
                this.metaTileEntity.addNotifiedInput(importInventory);
                return true;
            }
            return false;
        }

        @Override
        protected IMultipleTankHandler getOutputTank() {
            return MetaTileEntityDistillationTower.this.handler.getFluidTanks();
        }
    }
}

