/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import gregtech.api.capability.IEnergyContainer;
import gregtech.api.capability.impl.RecipeLogicEnergy;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.SimpleMachineMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.recipes.RecipeMap;
import gregtech.api.recipes.RecipeMaps;
import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.Textures;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;

public class MetaTileEntityRockBreaker
extends SimpleMachineMetaTileEntity {
    private boolean hasValidFluids;

    public MetaTileEntityRockBreaker(ResourceLocation metaTileEntityId, RecipeMap<?> recipeMap, ICubeRenderer renderer, int tier) {
        super(metaTileEntityId, recipeMap, renderer, tier, true);
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityRockBreaker(this.metaTileEntityId, RecipeMaps.ROCK_BREAKER_RECIPES, Textures.ROCK_BREAKER_OVERLAY, this.getTier());
    }

    @Override
    protected RecipeLogicEnergy createWorkable(RecipeMap<?> recipeMap) {
        return new RockBreakerRecipeLogic(this, RecipeMaps.ROCK_BREAKER_RECIPES, () -> this.energyContainer);
    }

    @Override
    public void onNeighborChanged() {
        super.onNeighborChanged();
        this.checkAdjacentFluids();
    }

    private void checkAdjacentFluids() {
        if (this.getWorld() == null) {
            this.hasValidFluids = true;
            return;
        }
        if (this.getWorld().field_72995_K) {
            this.hasValidFluids = false;
            return;
        }
        boolean hasLava = false;
        boolean hasWater = false;
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (hasLava && hasWater) break;
            if (side == this.frontFacing || side.func_176740_k().func_176720_b()) continue;
            Block block = this.getWorld().func_180495_p(this.getPos().func_177972_a(side)).func_177230_c();
            if (block == Blocks.field_150356_k || block == Blocks.field_150353_l) {
                hasLava = true;
                continue;
            }
            if (block != Blocks.field_150358_i && block != Blocks.field_150355_j) continue;
            hasWater = true;
        }
        this.hasValidFluids = hasLava && hasWater;
    }

    @Override
    public <T> void addNotifiedInput(T input) {
        super.addNotifiedInput(input);
        this.onNeighborChanged();
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74757_a("hasValidFluids", this.hasValidFluids);
        return data;
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b("hasValidFluids")) {
            this.hasValidFluids = data.func_74767_n("hasValidFluids");
        }
    }

    @Override
    public boolean getIsWeatherOrTerrainResistant() {
        return true;
    }

    protected class RockBreakerRecipeLogic
    extends RecipeLogicEnergy {
        public RockBreakerRecipeLogic(MetaTileEntity metaTileEntity, RecipeMap<?> recipeMap, Supplier<IEnergyContainer> energyContainer) {
            super(metaTileEntity, recipeMap, energyContainer);
        }

        @Override
        protected boolean shouldSearchForRecipes() {
            return MetaTileEntityRockBreaker.this.hasValidFluids && super.shouldSearchForRecipes();
        }
    }
}

