/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.metatileentities.electric;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GTValues;
import gregtech.api.capability.GregtechTileCapabilities;
import gregtech.api.capability.IControllable;
import gregtech.api.capability.IMiner;
import gregtech.api.capability.impl.EnergyContainerHandler;
import gregtech.api.capability.impl.NotifiableItemStackHandler;
import gregtech.api.capability.impl.miner.MinerLogic;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.ModularUI;
import gregtech.api.gui.widgets.AdvancedTextWidget;
import gregtech.api.gui.widgets.SlotWidget;
import gregtech.api.items.itemhandlers.GTItemStackHandler;
import gregtech.api.metatileentity.IDataInfoProvider;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.TieredMetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.client.renderer.texture.Textures;
import gregtech.core.sound.GTSoundEvents;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MetaTileEntityMiner
extends TieredMetaTileEntity
implements IMiner,
IControllable,
IDataInfoProvider {
    private final ItemStackHandler chargerInventory;
    private final int inventorySize;
    private final long energyPerTick;
    private boolean isInventoryFull = false;
    private final MinerLogic minerLogic;

    public MetaTileEntityMiner(ResourceLocation metaTileEntityId, int tier, int speed, int maximumRadius, int fortune) {
        super(metaTileEntityId, tier);
        this.inventorySize = (tier + 1) * (tier + 1);
        this.energyPerTick = GTValues.V[tier - 1];
        this.minerLogic = new MinerLogic(this, fortune, speed, maximumRadius, Textures.SOLID_STEEL_CASING);
        this.chargerInventory = new GTItemStackHandler((MetaTileEntity)this, 1);
        this.initializeInventory();
    }

    @Override
    public MetaTileEntity createMetaTileEntity(IGregTechTileEntity tileEntity) {
        return new MetaTileEntityMiner(this.metaTileEntityId, this.getTier(), this.minerLogic.getSpeed(), this.minerLogic.getMaximumRadius(), this.minerLogic.getFortune());
    }

    @Override
    protected IItemHandlerModifiable createImportItemHandler() {
        return new NotifiableItemStackHandler(this, 0, this, false);
    }

    @Override
    protected IItemHandlerModifiable createExportItemHandler() {
        return new NotifiableItemStackHandler(this, this.inventorySize, this, true);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderMetaTileEntity(CCRenderState renderState, Matrix4 translation, IVertexOperation[] pipeline) {
        super.renderMetaTileEntity(renderState, translation, pipeline);
        Textures.SCREEN.renderSided(EnumFacing.UP, renderState, translation, pipeline);
        for (EnumFacing renderSide : EnumFacing.field_176754_o) {
            if (renderSide == this.getFrontFacing()) {
                Textures.PIPE_OUT_OVERLAY.renderSided(renderSide, renderState, translation, pipeline);
                continue;
            }
            Textures.CHUNK_MINER_OVERLAY.renderSided(renderSide, renderState, translation, pipeline);
        }
        this.minerLogic.renderPipe(renderState, translation, pipeline);
    }

    @Override
    protected ModularUI createUI(@NotNull EntityPlayer entityPlayer) {
        int rowSize = (int)Math.sqrt(this.inventorySize);
        ModularUI.Builder builder = new ModularUI.Builder(GuiTextures.BACKGROUND, 195, 176);
        builder.bindPlayerInventory(entityPlayer.field_71071_by, 94);
        if (this.getTier() == 3) {
            for (int y = 0; y < rowSize; ++y) {
                for (int x = 0; x < rowSize; ++x) {
                    int index = y * rowSize + x;
                    builder.widget(new SlotWidget((IItemHandler)this.exportItems, index, 151 - rowSize * 9 + x * 18, 18 + y * 18, true, false).setBackgroundTexture(GuiTextures.SLOT));
                }
            }
        } else {
            for (int y = 0; y < rowSize; ++y) {
                for (int x = 0; x < rowSize; ++x) {
                    int index = y * rowSize + x;
                    builder.widget(new SlotWidget((IItemHandler)this.exportItems, index, 142 - rowSize * 9 + x * 18, 18 + y * 18, true, false).setBackgroundTexture(GuiTextures.SLOT));
                }
            }
        }
        builder.image(7, 16, 105, 75, GuiTextures.DISPLAY).label(6, 6, this.getMetaFullName());
        builder.widget(new AdvancedTextWidget(10, 19, this::addDisplayText, 0xFFFFFF).setMaxWidthLimit(84));
        builder.widget(new AdvancedTextWidget(70, 19, this::addDisplayText2, 0xFFFFFF).setMaxWidthLimit(84));
        builder.widget(new SlotWidget((IItemHandlerModifiable)this.chargerInventory, 0, 171, 152).setBackgroundTexture(GuiTextures.SLOT, GuiTextures.CHARGER_OVERLAY));
        return builder.build(this.getHolder(), entityPlayer);
    }

    private void addDisplayText(@NotNull List<ITextComponent> textList) {
        int workingArea = this.getWorkingArea(this.minerLogic.getCurrentRadius());
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.startx", new Object[]{this.minerLogic.getX().get()}));
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.starty", new Object[]{this.minerLogic.getY().get()}));
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.startz", new Object[]{this.minerLogic.getZ().get()}));
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.working_area", new Object[]{workingArea, workingArea}));
        if (this.minerLogic.isDone()) {
            textList.add(new TextComponentTranslation("gregtech.machine.miner.done", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GREEN)));
        } else if (this.minerLogic.isWorking()) {
            textList.add(new TextComponentTranslation("gregtech.machine.miner.working", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.GOLD)));
        } else if (!this.isWorkingEnabled()) {
            textList.add((ITextComponent)new TextComponentTranslation("gregtech.multiblock.work_paused", new Object[0]));
        }
        if (this.isInventoryFull) {
            textList.add(new TextComponentTranslation("gregtech.machine.miner.invfull", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
        if (!this.drainEnergy(true)) {
            textList.add(new TextComponentTranslation("gregtech.machine.miner.needspower", new Object[0]).func_150255_a(new Style().func_150238_a(TextFormatting.RED)));
        }
    }

    private void addDisplayText2(@NotNull List<ITextComponent> textList) {
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.minex", new Object[]{this.minerLogic.getMineX().get()}));
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.miney", new Object[]{this.minerLogic.getMineY().get()}));
        textList.add((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.minez", new Object[]{this.minerLogic.getMineZ().get()}));
    }

    @Override
    public void addInformation(ItemStack stack, @Nullable World player, @NotNull List<String> tooltip, boolean advanced) {
        int currentArea = this.getWorkingArea(this.minerLogic.getCurrentRadius());
        tooltip.add(I18n.func_135052_a((String)"gregtech.machine.miner.tooltip", (Object[])new Object[]{currentArea, currentArea}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.uses_per_tick", (Object[])new Object[]{this.energyPerTick}) + TextFormatting.GRAY + ", " + I18n.func_135052_a((String)"gregtech.machine.miner.per_block", (Object[])new Object[]{this.minerLogic.getSpeed() / 20}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.voltage_in", (Object[])new Object[]{this.energyContainer.getInputVoltage(), GTValues.VNF[this.getTier()]}));
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{this.energyContainer.getEnergyCapacity()}));
        int maxArea = this.getWorkingArea(this.minerLogic.getMaximumRadius());
        tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.working_area_max", (Object[])new Object[]{maxArea, maxArea}));
    }

    @Override
    public void addToolUsages(ItemStack stack, @Nullable World world, List<String> tooltip, boolean advanced) {
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.screwdriver.toggle_mode_covers", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.wrench.set_facing", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"gregtech.tool_action.soft_mallet.reset", (Object[])new Object[0]));
        super.addToolUsages(stack, world, tooltip, advanced);
    }

    @Override
    public boolean drainEnergy(boolean simulate) {
        long resultEnergy = this.energyContainer.getEnergyStored() - this.energyPerTick;
        if (resultEnergy >= 0L && resultEnergy <= this.energyContainer.getEnergyCapacity()) {
            if (!simulate) {
                this.energyContainer.removeEnergy(this.energyPerTick);
            }
            return true;
        }
        return false;
    }

    @Override
    public void update() {
        super.update();
        this.minerLogic.performMining();
        if (!this.getWorld().field_72995_K) {
            ((EnergyContainerHandler)this.energyContainer).dischargeOrRechargeEnergyContainers((IItemHandlerModifiable)this.chargerInventory, 0);
            if (this.getOffsetTimer() % 5L == 0L) {
                this.pushItemsIntoNearbyHandlers(this.getFrontFacing());
            }
            if (this.minerLogic.wasActiveAndNeedsUpdate()) {
                this.minerLogic.setWasActiveAndNeedsUpdate(false);
                this.minerLogic.setActive(false);
            }
        }
    }

    @Override
    public boolean onScrewdriverClick(EntityPlayer playerIn, EnumHand hand, EnumFacing facing, CuboidRayTraceResult hitResult) {
        if (this.getWorld().field_72995_K) {
            return true;
        }
        if (!this.isActive()) {
            int currentRadius = this.minerLogic.getCurrentRadius();
            if (currentRadius == 1) {
                this.minerLogic.setCurrentRadius(this.minerLogic.getMaximumRadius());
            } else if (playerIn.func_70093_af()) {
                this.minerLogic.setCurrentRadius(Math.max(1, Math.round((float)currentRadius / 2.0f)));
            } else {
                this.minerLogic.setCurrentRadius(Math.max(1, currentRadius - 1));
            }
            this.minerLogic.resetArea();
            int workingArea = this.getWorkingArea(this.minerLogic.getCurrentRadius());
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.working_area", new Object[]{workingArea, workingArea}));
        } else {
            playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("gregtech.machine.miner.errorradius", new Object[0]));
        }
        return true;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74782_a("ChargerInventory", (NBTBase)this.chargerInventory.serializeNBT());
        return this.minerLogic.writeToNBT(data);
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.chargerInventory.deserializeNBT(data.func_74775_l("ChargerInventory"));
        this.minerLogic.readFromNBT(data);
    }

    @Override
    public void writeInitialSyncData(PacketBuffer buf) {
        super.writeInitialSyncData(buf);
        this.minerLogic.writeInitialSyncData(buf);
    }

    @Override
    public void receiveInitialSyncData(PacketBuffer buf) {
        super.receiveInitialSyncData(buf);
        this.minerLogic.receiveInitialSyncData(buf);
    }

    @Override
    public void receiveCustomData(int dataId, PacketBuffer buf) {
        super.receiveCustomData(dataId, buf);
        this.minerLogic.receiveCustomData(dataId, buf);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing side) {
        if (capability == GregtechTileCapabilities.CAPABILITY_CONTROLLABLE) {
            return (T)GregtechTileCapabilities.CAPABILITY_CONTROLLABLE.cast((Object)this);
        }
        return super.getCapability(capability, side);
    }

    @Override
    public void clearMachineInventory(NonNullList<ItemStack> itemBuffer) {
        super.clearMachineInventory(itemBuffer);
        MetaTileEntityMiner.clearInventory(itemBuffer, (IItemHandlerModifiable)this.chargerInventory);
    }

    @Override
    public boolean isInventoryFull() {
        return this.isInventoryFull;
    }

    @Override
    public void setInventoryFull(boolean isFull) {
        this.isInventoryFull = isFull;
    }

    @Override
    public boolean isWorkingEnabled() {
        return this.minerLogic.isWorkingEnabled();
    }

    @Override
    public void setWorkingEnabled(boolean isActivationAllowed) {
        this.minerLogic.setWorkingEnabled(isActivationAllowed);
    }

    @Override
    public SoundEvent getSound() {
        return GTSoundEvents.MINER;
    }

    @Override
    public boolean isActive() {
        return this.minerLogic.isActive() && this.isWorkingEnabled();
    }

    @Override
    @NotNull
    public List<ITextComponent> getDataInfo() {
        int workingArea = this.getWorkingArea(this.minerLogic.getCurrentRadius());
        return Collections.singletonList(new TextComponentTranslation("gregtech.machine.miner.working_area", new Object[]{workingArea, workingArea}));
    }
}

