/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.api.util.GTUtility;
import java.util.List;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class ModeSwitchBehavior<T extends Enum<T>>
implements IItemBehaviour {
    public final Class<T> enumClass;
    private final T[] enumConstants;

    public ModeSwitchBehavior(Class<T> enumClass) {
        this.enumClass = enumClass;
        this.enumConstants = (Enum[])enumClass.getEnumConstants();
    }

    public T getModeFromItemStack(ItemStack itemStack) {
        if (!itemStack.func_77942_o()) {
            return this.enumConstants[0];
        }
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound == null) {
            return this.enumConstants[0];
        }
        return this.enumConstants[tagCompound.func_74762_e("Mode")];
    }

    public void setModeForItemStack(ItemStack itemStack, T newMode) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new NBTTagCompound());
        }
        NBTTagCompound tagCompound = GTUtility.getOrCreateNbtCompound(itemStack);
        tagCompound.func_74768_a("Mode", ArrayUtils.indexOf((Object[])this.enumConstants, newMode));
    }

    @Override
    public ActionResult<ItemStack> onItemRightClick(World world, EntityPlayer player, EnumHand hand) {
        ItemStack itemStack = player.func_184586_b(hand);
        if (player.func_70093_af()) {
            T currentMode = this.getModeFromItemStack(itemStack);
            int currentModeIndex = ArrayUtils.indexOf((Object[])this.enumConstants, currentMode);
            T nextMode = this.enumConstants[(currentModeIndex + 1) % this.enumConstants.length];
            this.setModeForItemStack(itemStack, nextMode);
            TextComponentTranslation newModeComponent = new TextComponentTranslation(((ILocalizationKey)nextMode).getUnlocalizedName(), new Object[0]);
            TextComponentTranslation textComponent = new TextComponentTranslation("metaitem.behavior.mode_switch.mode_switched", new Object[]{newModeComponent});
            player.func_146105_b((ITextComponent)textComponent, true);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)itemStack);
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)itemStack);
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        T currentMode = this.getModeFromItemStack(itemStack);
        lines.add(I18n.func_135052_a((String)"metaitem.behavior.mode_switch.tooltip", (Object[])new Object[0]));
        lines.add(I18n.func_135052_a((String)"metaitem.behavior.mode_switch.current_mode", (Object[])new Object[]{I18n.func_135052_a((String)((ILocalizationKey)currentMode).getUnlocalizedName(), (Object[])new Object[0])}));
    }

    public static interface ILocalizationKey {
        public String getUnlocalizedName();
    }
}

