/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import gregtech.api.items.metaitem.stats.IItemBehaviour;
import gregtech.common.entities.GTBoatEntity;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class GTBoatBehavior
implements IItemBehaviour {
    private final GTBoatEntity.GTBoatType type;

    public GTBoatBehavior(GTBoatEntity.GTBoatType type) {
        this.type = type;
    }

    @Override
    public ActionResult<ItemStack> onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        float pitchSin;
        float pitchCos;
        ItemStack stack = player.func_184586_b(hand);
        float realPitch = player.field_70127_C + (player.field_70125_A - player.field_70127_C);
        float realYaw = player.field_70126_B + (player.field_70177_z - player.field_70126_B);
        double realX = player.field_70169_q + (player.field_70165_t - player.field_70169_q);
        double realY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) + (double)player.func_70047_e();
        double realZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s);
        Vec3d realPos = new Vec3d(realX, realY, realZ);
        float R2D = (float)Math.PI / 180;
        float yawCos = MathHelper.func_76134_b((float)(-realYaw * ((float)Math.PI / 180) - (float)Math.PI));
        float yawSin = MathHelper.func_76126_a((float)(-realYaw * ((float)Math.PI / 180) - (float)Math.PI));
        Vec3d lookPos = realPos.func_72441_c((double)(yawSin * (pitchCos = -MathHelper.func_76134_b((float)(-realPitch * ((float)Math.PI / 180))))) * 5.0, (double)(pitchSin = MathHelper.func_76126_a((float)(-realPitch * ((float)Math.PI / 180)))) * 5.0, (double)(yawCos * pitchCos) * 5.0);
        RayTraceResult ray = world.func_72901_a(realPos, lookPos, true);
        if (ray == null || ray.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        Vec3d relativeLook = player.func_70676_i(1.0f);
        for (Entity entity : world.func_72839_b((Entity)player, player.func_174813_aQ().func_72321_a(relativeLook.field_72450_a * 5.0, relativeLook.field_72448_b * 5.0, relativeLook.field_72449_c * 5.0).func_186662_g(1.0))) {
            if (!entity.func_70067_L() || !entity.func_174813_aQ().func_186662_g((double)entity.func_70111_Y()).func_72318_a(realPos)) continue;
            return new ActionResult(EnumActionResult.PASS, (Object)stack);
        }
        Block block = world.func_180495_p(ray.func_178782_a()).func_177230_c();
        boolean rayHitWater = block == Blocks.field_150355_j || block == Blocks.field_150358_i;
        GTBoatEntity boat = new GTBoatEntity(world, ray.field_72307_f.field_72450_a, rayHitWater ? ray.field_72307_f.field_72448_b - 0.12 : ray.field_72307_f.field_72448_b, ray.field_72307_f.field_72449_c);
        boat.setGTBoatType(this.type);
        boat.field_70177_z = player.field_70177_z;
        if (!world.func_184144_a((Entity)boat, boat.func_174813_aQ().func_186662_g(-0.1)).isEmpty()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (!world.field_72995_K) {
            world.func_72838_d((Entity)boat);
        }
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }
}

