/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.items.behaviors;

import appeng.api.util.AEColor;
import appeng.tile.networking.TileCableBus;
import gregtech.api.items.metaitem.stats.IItemDurabilityManager;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.util.GradientUtil;
import gregtech.api.util.Mods;
import gregtech.common.items.behaviors.AbstractUsableBehaviour;
import gregtech.core.sound.GTSoundEvents;
import java.awt.Color;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.BlockStainedGlass;
import net.minecraft.block.BlockStainedGlassPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class ColorSprayBehaviour
extends AbstractUsableBehaviour
implements IItemDurabilityManager {
    private final ItemStack empty;
    private final EnumDyeColor color;
    private final Pair<Color, Color> durabilityBarColors;

    public ColorSprayBehaviour(ItemStack empty, int totalUses, int color) {
        super(totalUses);
        this.empty = empty;
        EnumDyeColor[] colors = EnumDyeColor.values();
        this.color = color >= colors.length || color < 0 ? null : colors[color];
        int colorValue = this.color == null ? 0x969696 : this.color.field_193351_w;
        this.durabilityBarColors = GradientUtil.getGradient(colorValue, 10);
    }

    @Override
    public ActionResult<ItemStack> onItemUse(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (!player.func_175151_a(pos, facing, stack)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.FAIL, (Object)player.func_184586_b(hand));
        }
        if (!this.tryPaintBlock(player, world, pos, facing)) {
            return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
        }
        this.useItemDurability(player, hand, stack, this.empty.func_77946_l());
        world.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, GTSoundEvents.SPRAY_CAN_TOOL, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    private boolean tryPaintBlock(EntityPlayer player, World world, BlockPos pos, EnumFacing side) {
        IBlockState blockState = world.func_180495_p(pos);
        Block block = blockState.func_177230_c();
        if (this.color == null) {
            return ColorSprayBehaviour.tryStripBlockColor(player, world, pos, block, side);
        }
        return block.recolorBlock(world, pos, side, this.color) || this.tryPaintSpecialBlock(player, world, pos, block);
    }

    private boolean tryPaintSpecialBlock(EntityPlayer player, World world, BlockPos pos, Block block) {
        TileCableBus cable;
        TileEntity te;
        if (block == Blocks.field_150359_w) {
            IBlockState newBlockState = Blocks.field_150399_cn.func_176223_P().func_177226_a((IProperty)BlockStainedGlass.field_176547_a, (Comparable)this.color);
            world.func_175656_a(pos, newBlockState);
            return true;
        }
        if (block == Blocks.field_150410_aZ) {
            IBlockState newBlockState = Blocks.field_150397_co.func_176223_P().func_177226_a((IProperty)BlockStainedGlassPane.field_176245_a, (Comparable)this.color);
            world.func_175656_a(pos, newBlockState);
            return true;
        }
        if (block == Blocks.field_150405_ch) {
            IBlockState newBlockState = Blocks.field_150406_ce.func_176223_P().func_177226_a((IProperty)BlockColored.field_176581_a, (Comparable)this.color);
            world.func_175656_a(pos, newBlockState);
            return true;
        }
        if (Mods.AppliedEnergistics2.isModLoaded() && (te = world.func_175625_s(pos)) instanceof TileCableBus && (cable = (TileCableBus)te).getColor().ordinal() != this.color.ordinal()) {
            cable.recolourBlock(null, AEColor.values()[this.color.ordinal()], player);
            return true;
        }
        return false;
    }

    private static boolean tryStripBlockColor(EntityPlayer player, World world, BlockPos pos, Block block, EnumFacing side) {
        MetaTileEntity mte;
        if (block == Blocks.field_150399_cn) {
            world.func_175656_a(pos, Blocks.field_150359_w.func_176223_P());
            return true;
        }
        if (block == Blocks.field_150397_co) {
            world.func_175656_a(pos, Blocks.field_150410_aZ.func_176223_P());
            return true;
        }
        if (block == Blocks.field_150406_ce) {
            world.func_175656_a(pos, Blocks.field_150405_ch.func_176223_P());
            return true;
        }
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof IGregTechTileEntity && (mte = ((IGregTechTileEntity)te).getMetaTileEntity()) != null) {
            if (mte.isPainted()) {
                mte.setPaintingColor(-1);
                return true;
            }
            return false;
        }
        if (te instanceof IPipeTile) {
            IPipeTile pipe = (IPipeTile)te;
            if (pipe.isPainted()) {
                pipe.setPaintingColor(-1);
                return true;
            }
            return false;
        }
        if (Mods.AppliedEnergistics2.isModLoaded() && te instanceof TileCableBus) {
            TileCableBus cable = (TileCableBus)te;
            if (cable.getColor() != AEColor.TRANSPARENT) {
                cable.recolourBlock(null, AEColor.TRANSPARENT, player);
                return true;
            }
            return false;
        }
        IBlockState state = world.func_180495_p(pos);
        for (IProperty prop : state.func_177228_b().keySet()) {
            if (!prop.func_177701_a().equals("color") || prop.func_177699_b() != EnumDyeColor.class) continue;
            IBlockState defaultState = block.func_176223_P();
            EnumDyeColor defaultColor = EnumDyeColor.WHITE;
            try {
                defaultColor = (EnumDyeColor)defaultState.func_177229_b(prop);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            block.recolorBlock(world, pos, side, defaultColor);
            return true;
        }
        return false;
    }

    @Override
    public void addInformation(ItemStack itemStack, List<String> lines) {
        int remainingUses = this.getUsesLeft(itemStack);
        if (this.color != null) {
            lines.add(I18n.func_135052_a((String)("behaviour.paintspray." + this.color.func_176762_d() + ".tooltip"), (Object[])new Object[0]));
        } else {
            lines.add(I18n.func_135052_a((String)"behaviour.paintspray.solvent.tooltip", (Object[])new Object[0]));
        }
        lines.add(I18n.func_135052_a((String)"behaviour.paintspray.uses", (Object[])new Object[]{remainingUses}));
        lines.add(I18n.func_135052_a((String)"behaviour.paintspray.offhand", (Object[])new Object[0]));
    }

    @Override
    public double getDurabilityForDisplay(ItemStack itemStack) {
        return (double)this.getUsesLeft(itemStack) / (double)this.totalUses;
    }

    @Override
    @Nullable
    public Pair<Color, Color> getDurabilityColorsForDisplay(ItemStack itemStack) {
        return this.durabilityBarColors;
    }

    @Override
    public boolean doDamagedStateColors(ItemStack itemStack) {
        return false;
    }
}

