/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.inventory.itemsource.sources;

import gregtech.api.util.ItemStackHashStrategy;
import gregtech.common.inventory.itemsource.ItemSource;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenCustomHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class InventoryItemSource
extends ItemSource {
    protected final World world;
    protected final int priority;
    protected IItemHandler itemHandler = EmptyHandler.INSTANCE;
    private Object2IntMap<ItemStack> itemStackByAmountMap = new Object2IntLinkedOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());

    public InventoryItemSource(World world, int priority) {
        this.world = world;
        this.priority = priority;
    }

    public InventoryItemSource(World world, IItemHandler itemHandler1, int priority) {
        this(world, priority);
        this.itemHandler = itemHandler1;
    }

    @Override
    public void computeItemHandler() {
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public void update() {
        this.recomputeItemStackCount();
    }

    @Override
    public int insertItem(ItemStack stack, int amount, boolean simulate, Object2IntMap<ItemSource> insertedMap) {
        int itemsInserted = 0;
        if (this.itemHandler == null) {
            return itemsInserted;
        }
        ItemStack itemStack = stack.func_77946_l();
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            itemStack.func_190920_e(amount - itemsInserted);
            ItemStack remainderStack = this.itemHandler.insertItem(i, itemStack, simulate);
            if ((itemsInserted += itemStack.func_190916_E() - remainderStack.func_190916_E()) == amount) break;
        }
        if (itemsInserted > 0 && !simulate) {
            int finalItemsInserted = itemsInserted;
            insertedMap.computeIfPresent((Object)this, (source, count) -> count + finalItemsInserted);
            insertedMap.putIfAbsent((Object)this, (Object)amount);
        }
        return itemsInserted;
    }

    @Override
    public int extractItem(ItemStack stack, int amount, boolean simulate, Object2IntMap<ItemSource> extractedMap) {
        int itemsExtracted = 0;
        if (this.itemHandler == null) {
            return itemsExtracted;
        }
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack stackInSlot = this.itemHandler.getStackInSlot(i);
            if (stackInSlot.func_190926_b() || !ItemStackHashStrategy.comparingAllButCount().equals(stack, stackInSlot)) continue;
            ItemStack extractedStack = this.itemHandler.extractItem(i, amount - itemsExtracted, simulate);
            if (!extractedStack.func_190926_b()) {
                itemsExtracted += extractedStack.func_190916_E();
            }
            if (itemsExtracted == amount) break;
        }
        if (itemsExtracted > 0 && !simulate) {
            int finalItemsExtracted = itemsExtracted;
            extractedMap.computeIfPresent((Object)this, (source, count) -> count + finalItemsExtracted);
            extractedMap.putIfAbsent((Object)this, (Object)amount);
        }
        return itemsExtracted;
    }

    @Override
    public Object2IntMap<ItemStack> getStoredItems() {
        return Object2IntMaps.unmodifiable(this.itemStackByAmountMap);
    }

    private void recomputeItemStackCount() {
        Object2IntLinkedOpenCustomHashMap amountMap = new Object2IntLinkedOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        if (this.itemHandler == null) {
            this.itemStackByAmountMap = amountMap;
            return;
        }
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            ItemStack itemStack = this.itemHandler.extractItem(i, Integer.MAX_VALUE, true);
            if (itemStack.func_190926_b()) continue;
            amountMap.put((Object)itemStack, amountMap.getInt((Object)itemStack) + itemStack.func_190916_E());
        }
        this.itemStackByAmountMap = amountMap;
    }
}

