/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.inventory.itemsource;

import gregtech.common.inventory.IItemInfo;
import gregtech.common.inventory.itemsource.ItemSource;
import it.unimi.dsi.fastutil.objects.Object2IntAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Comparator;
import net.minecraft.item.ItemStack;

public class NetworkItemInfo
implements IItemInfo {
    private final ItemStack itemStack;
    private int totalItemAmount = 0;
    private final Object2IntMap<ItemSource> inventories = new Object2IntAVLTreeMap(Comparator.comparingInt(ItemSource::getPriority));

    public NetworkItemInfo(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public int getTotalItemAmount() {
        return this.totalItemAmount;
    }

    @Override
    public ItemStack getItemStack() {
        return this.itemStack;
    }

    void addToSource(ItemSource itemSource, int amount) {
        this.inventories.computeIfPresent((Object)itemSource, (key, value) -> value + amount);
        this.inventories.putIfAbsent((Object)itemSource, (Object)amount);
        this.totalItemAmount += amount;
    }

    void removeFromSource(ItemSource itemSource, int amount) {
        this.inventories.computeIfPresent((Object)itemSource, (key, value) -> {
            if (amount >= value) {
                return null;
            }
            return value - amount;
        });
        this.totalItemAmount = Math.max(0, this.totalItemAmount - amount);
        if (this.totalItemAmount == 0) {
            this.inventories.remove((Object)itemSource);
        }
    }
}

