/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.orefilter;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.TextFieldWidget2;
import gregtech.api.util.oreglob.OreGlobCompileResult;
import java.util.ArrayList;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import org.jetbrains.annotations.Nullable;

public class OreGlobCompileStatusWidget
extends Widget {
    @Nullable
    private OreGlobCompileResult result;
    private TextFieldWidget2 textField;

    public OreGlobCompileStatusWidget(int x, int y) {
        super(x, y, 7, 7);
    }

    public void setCompileResult(@Nullable OreGlobCompileResult result) {
        this.result = result;
    }

    public void setTextField(TextFieldWidget2 textField) {
        this.textField = textField;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        TextureArea texture = this.result == null || this.textField.isFocused() ? GuiTextures.ORE_FILTER_WAITING : (this.result.getReports().length == 0 ? GuiTextures.ORE_FILTER_SUCCESS : (this.result.hasError() ? GuiTextures.ORE_FILTER_ERROR : GuiTextures.ORE_FILTER_WARN));
        texture.draw(this.getPosition().x, this.getPosition().y, this.getSize().width, this.getSize().height);
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.result != null && !this.textField.isFocused() && this.isMouseOverElement(mouseX, mouseY)) {
            ArrayList<String> list = new ArrayList<String>();
            int error = 0;
            int warn = 0;
            for (OreGlobCompileResult.Report report : this.result.getReports()) {
                if (report.isError()) {
                    ++error;
                } else {
                    ++warn;
                }
                list.add((report.isError() ? TextFormatting.RED : TextFormatting.GOLD) + report.toString());
            }
            if (error > 0) {
                if (warn > 0) {
                    list.add(0, I18n.func_135052_a((String)"cover.ore_dictionary_filter.status.err_warn", (Object[])new Object[]{error, warn}));
                } else {
                    list.add(0, I18n.func_135052_a((String)"cover.ore_dictionary_filter.status.err", (Object[])new Object[]{error}));
                }
            } else {
                if (warn > 0) {
                    list.add(0, I18n.func_135052_a((String)"cover.ore_dictionary_filter.status.warn", (Object[])new Object[]{warn}));
                } else {
                    list.add(I18n.func_135052_a((String)"cover.ore_dictionary_filter.status.no_issues", (Object[])new Object[0]));
                }
                list.add("");
                list.add(I18n.func_135052_a((String)"cover.ore_dictionary_filter.status.explain", (Object[])new Object[0]));
                list.add("");
                list.addAll(this.result.getInstance().toFormattedString());
            }
            this.drawHoveringText(ItemStack.field_190927_a, list, 300, mouseX, mouseY);
        }
    }
}

