/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.orefilter;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.resources.TextureArea;
import gregtech.api.gui.widgets.ImageWidget;
import gregtech.api.gui.widgets.WidgetGroup;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.Position;
import gregtech.api.util.function.BooleanConsumer;
import gregtech.api.util.oreglob.OreGlob;
import it.unimi.dsi.fastutil.objects.Object2BooleanAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMaps;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.Nullable;

public abstract class OreFilterTestSlot
extends WidgetGroup {
    private final ImageWidget match;
    private final ImageWidget noMatch;
    @Nullable
    private OreGlob glob;
    private boolean expectedResult = true;
    @Nullable
    private TextureArea slotIcon = GuiTextures.SLOT;
    @Nullable
    private BooleanConsumer onMatchChange;
    private Object2BooleanMap<String> testResult;
    private MatchType matchType = MatchType.INVALID;
    private boolean matchSuccess;
    private boolean initialized = false;
    private boolean matchAll;

    public OreFilterTestSlot(int xPosition, int yPosition) {
        super(xPosition, yPosition, 18, 18);
        this.match = new ImageWidget(13, -3, 9, 6, GuiTextures.ORE_FILTER_MATCH);
        this.noMatch = new ImageWidget(13, -3, 7, 7, GuiTextures.ORE_FILTER_NO_MATCH);
        this.addWidget(this.match);
        this.addWidget(this.noMatch);
    }

    @Override
    public void initWidget() {
        this.initialized = true;
        this.updatePreview();
        super.initWidget();
    }

    public boolean isMatchSuccess() {
        return this.matchSuccess;
    }

    public OreFilterTestSlot setSlotIcon(@Nullable TextureArea slotIcon) {
        this.slotIcon = slotIcon;
        return this;
    }

    public OreFilterTestSlot setExpectedResult(boolean expectedResult) {
        this.expectedResult = expectedResult;
        return this;
    }

    public OreFilterTestSlot onMatchChange(@Nullable BooleanConsumer onMatchChange) {
        this.onMatchChange = onMatchChange;
        return this;
    }

    public void setGlob(@Nullable OreGlob glob) {
        if (this.glob == glob) {
            return;
        }
        this.glob = glob;
        this.updatePreview();
    }

    public void setMatchAll(boolean matchAll) {
        if (this.matchAll == matchAll) {
            return;
        }
        this.matchAll = matchAll;
        this.updatePreview();
    }

    protected void updatePreview() {
        if (!this.initialized) {
            return;
        }
        Set<String> oreDicts = this.getTestCandidates();
        if (oreDicts != null) {
            OreGlob glob = this.glob;
            if (oreDicts.isEmpty()) {
                this.testResult = Object2BooleanMaps.singleton((Object)"", (glob != null && glob.matches("") ? 1 : 0) != 0);
                this.matchType = MatchType.NO_ORE_DICT_MATCH;
            } else {
                this.testResult = new Object2BooleanAVLTreeMap();
                for (String oreDict : oreDicts) {
                    boolean matches = glob != null && glob.matches(oreDict);
                    this.testResult.put((Object)oreDict, matches);
                }
                this.matchType = MatchType.ORE_DICT_MATCH;
            }
            boolean success = this.matchAll;
            for (Object2BooleanMap.Entry e : this.testResult.object2BooleanEntrySet()) {
                boolean result = e.getBooleanValue();
                if (result != !this.matchAll) continue;
                success = !this.matchAll;
                break;
            }
            this.updateAndNotifyMatchSuccess(this.expectedResult == success);
            this.match.setVisible(this.expectedResult == success);
            this.noMatch.setVisible(this.expectedResult != success);
            return;
        }
        this.testResult = Object2BooleanMaps.emptyMap();
        this.matchType = MatchType.INVALID;
        this.updateAndNotifyMatchSuccess(false);
        this.match.setVisible(false);
        this.noMatch.setVisible(false);
    }

    private void updateAndNotifyMatchSuccess(boolean newValue) {
        if (this.matchSuccess == newValue) {
            return;
        }
        this.matchSuccess = newValue;
        if (this.onMatchChange != null) {
            this.onMatchChange.apply(newValue);
        }
    }

    @Nullable
    protected abstract Set<String> getTestCandidates();

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        Position pos = this.getPosition();
        if (this.slotIcon != null) {
            this.slotIcon.draw(pos.x, pos.y, 18, 18);
        }
        this.renderSlotContents(partialTicks, context);
        if (this.isActive() && this.isMouseOverElement(mouseX, mouseY)) {
            GlStateManager.func_179097_i();
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            OreFilterTestSlot.drawSolidRect(this.getPosition().x + 1, this.getPosition().y + 1, 16, 16, -2130706433);
            GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
            GlStateManager.func_179147_l();
        }
        GlStateManager.func_179097_i();
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        GlStateManager.func_179126_j();
    }

    protected abstract void renderSlotContents(float var1, IRenderContext var2);

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        if (this.isActive() && this.isMouseOverElement(mouseX, mouseY)) {
            List<String> list;
            switch (this.matchType) {
                case NO_ORE_DICT_MATCH: {
                    list = Collections.singletonList(I18n.func_135052_a((String)(this.matchSuccess ? "cover.ore_dictionary_filter.test_slot.no_oredict.matches" : "cover.ore_dictionary_filter.test_slot.no_oredict.matches_not"), (Object[])new Object[0]));
                    break;
                }
                case ORE_DICT_MATCH: {
                    list = this.testResult.object2BooleanEntrySet().stream().map(e -> I18n.func_135052_a((String)(e.getBooleanValue() ? "cover.ore_dictionary_filter.test_slot.matches" : "cover.ore_dictionary_filter.test_slot.matches_not"), (Object[])new Object[]{e.getKey()})).collect(Collectors.toList());
                    break;
                }
                default: {
                    list = Arrays.asList(LocalizationUtils.formatLines("cover.ore_dictionary_filter.test_slot.info", new Object[0]));
                }
            }
            this.drawHoveringText(ItemStack.field_190927_a, list, 300, mouseX, mouseY);
        }
    }

    private static enum MatchType {
        NO_ORE_DICT_MATCH,
        ORE_DICT_MATCH,
        INVALID;

    }
}

