/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.orefilter;

import com.google.common.collect.Lists;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.ingredient.IGhostIngredientTarget;
import gregtech.api.unification.OreDictUnifier;
import gregtech.api.util.Position;
import gregtech.common.gui.widget.orefilter.OreFilterTestSlot;
import java.awt.Rectangle;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemOreFilterTestSlot
extends OreFilterTestSlot
implements IGhostIngredientTarget {
    @NotNull
    private ItemStack testStack = ItemStack.field_190927_a;

    public ItemOreFilterTestSlot(int xPosition, int yPosition) {
        super(xPosition, yPosition);
    }

    @NotNull
    public ItemStack getTestStack() {
        return this.testStack;
    }

    public void setTestStack(@NotNull ItemStack testStack) {
        this.testStack = testStack;
        this.updatePreview();
    }

    @Override
    @Nullable
    protected Set<String> getTestCandidates() {
        return this.testStack.func_190926_b() ? null : OreDictUnifier.getOreDictionaryNames(this.testStack);
    }

    @Override
    protected void renderSlotContents(float partialTicks, IRenderContext context) {
        Position pos = this.getPosition();
        if (!this.testStack.func_190926_b()) {
            GlStateManager.func_179126_j();
            RenderHelper.func_74520_c();
            GlStateManager.func_179094_E();
            RenderItem itemRender = Minecraft.func_71410_x().func_175599_af();
            itemRender.func_180450_b(this.testStack, pos.x + 1, pos.y + 1);
            itemRender.func_180453_a(Minecraft.func_71410_x().field_71466_p, this.testStack, pos.x + 1, pos.y + 1, null);
            GlStateManager.func_179121_F();
            RenderHelper.func_74518_a();
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        if (this.isMouseOverElement(mouseX, mouseY)) {
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            this.putItem(player.field_71071_by.func_70445_o());
            return true;
        }
        return false;
    }

    private void putItem(ItemStack stack) {
        ItemStack testStack = this.getTestStack();
        if (stack.func_190926_b() ^ testStack.func_190926_b() || !testStack.func_77969_a(stack) || !ItemStack.func_77970_a((ItemStack)testStack, (ItemStack)stack)) {
            ItemStack copy = stack.func_77946_l();
            copy.func_190920_e(1);
            this.setTestStack(copy);
        }
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (!(ingredient instanceof ItemStack)) {
            return Collections.emptyList();
        }
        final Rectangle rectangle = this.toRectangleBox();
        return Lists.newArrayList((Object[])new IGhostIngredientHandler.Target[]{new IGhostIngredientHandler.Target<Object>(){

            @NotNull
            public Rectangle getArea() {
                return rectangle;
            }

            public void accept(@NotNull Object ingredient) {
                if (ingredient instanceof ItemStack) {
                    ItemOreFilterTestSlot.this.putItem((ItemStack)ingredient);
                }
            }
        }});
    }
}

