/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.appeng.slot;

import appeng.api.storage.data.IAEItemStack;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.gui.Widget;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.common.gui.widget.appeng.AEListGridWidget;
import net.minecraft.item.ItemStack;

public class AEItemDisplayWidget
extends Widget {
    private final AEListGridWidget<IAEItemStack> gridWidget;
    private final int index;

    public AEItemDisplayWidget(int x, int y, AEListGridWidget<IAEItemStack> gridWidget, int index) {
        super(new Position(x, y), new Size(18, 18));
        this.gridWidget = gridWidget;
        this.index = index;
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        Position position = this.getPosition();
        IAEItemStack item = this.gridWidget.getAt(this.index);
        GuiTextures.SLOT.draw(position.x, position.y, 18, 18);
        GuiTextures.NUMBER_BACKGROUND.draw(position.x + 18, position.y, 140, 18);
        int stackX = position.x + 1;
        int stackY = position.y + 1;
        if (item != null) {
            ItemStack realStack = item.createItemStack();
            realStack.func_190920_e(1);
            AEItemDisplayWidget.drawItemStack(realStack, stackX, stackY, null);
            String amountStr = String.format("x%,d", item.getStackSize());
            AEItemDisplayWidget.drawText(amountStr, stackX + 20, stackY + 5, 1.0f, -1);
        }
        if (this.isMouseOverElement(mouseX, mouseY)) {
            AEItemDisplayWidget.drawSelectionOverlay(stackX, stackY, 16, 16);
        }
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        IAEItemStack item;
        if (this.isMouseOverElement(mouseX, mouseY) && (item = this.gridWidget.getAt(this.index)) != null) {
            this.drawHoveringText(item.createItemStack(), AEItemDisplayWidget.getItemToolTip(item.createItemStack()), -1, mouseX, mouseY);
        }
    }
}

