/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.gui.widget.appeng.slot;

import appeng.api.storage.data.IAEItemStack;
import com.google.common.collect.Lists;
import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.IRenderContext;
import gregtech.api.util.Position;
import gregtech.api.util.Size;
import gregtech.api.util.TextFormattingUtil;
import gregtech.common.gui.widget.appeng.AEItemConfigWidget;
import gregtech.common.gui.widget.appeng.slot.AEConfigSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.slot.IConfigurableSlot;
import gregtech.common.metatileentities.multi.multiblockpart.appeng.stack.WrappedItemStack;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.IGhostIngredientHandler;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

public class AEItemConfigSlot
extends AEConfigSlot<IAEItemStack> {
    public AEItemConfigSlot(int x, int y, AEItemConfigWidget widget, int index) {
        super(new Position(x, y), new Size(108, 18), widget, index);
    }

    public AEItemConfigWidget getParentWidget() {
        return (AEItemConfigWidget)super.getParentWidget();
    }

    @Override
    public void drawInBackground(int mouseX, int mouseY, float partialTicks, IRenderContext context) {
        String amountStr;
        ItemStack stack;
        super.drawInBackground(mouseX, mouseY, partialTicks, context);
        AEItemConfigWidget pw = this.getParentWidget();
        Position position = this.getPosition();
        IConfigurableSlot slot = pw.getDisplay(this.index);
        IAEItemStack config = (IAEItemStack)slot.getConfig();
        IAEItemStack stock = (IAEItemStack)slot.getStock();
        this.drawSlots(pw.isAutoPull(), position.x, position.y);
        if (this.select) {
            GuiTextures.SELECT_BOX.draw(position.x, position.y, 18, 18);
        }
        int stackX = position.x + 1;
        int stackY = position.y + 1;
        if (config != null) {
            stack = config.createItemStack();
            stack.func_190920_e(1);
            AEItemConfigSlot.drawItemStack(stack, stackX, stackY, null);
            if (!pw.isStocking()) {
                amountStr = TextFormattingUtil.formatLongToCompactString(config.getStackSize(), 4);
                AEItemConfigSlot.drawStringFixedCorner(amountStr, stackX + 17, stackY + 17, 0xFFFFFF, true, 0.5f);
            }
        }
        if (stock != null) {
            stack = stock.createItemStack();
            stack.func_190920_e(1);
            AEItemConfigSlot.drawItemStack(stack, stackX + 90, stackY, null);
            amountStr = TextFormattingUtil.formatLongToCompactString(stock.getStackSize(), 4);
            AEItemConfigSlot.drawStringFixedCorner(amountStr, stackX + 90 + 17, stackY + 17, 0xFFFFFF, true, 0.5f);
        }
        if (this.mouseOverConfig(mouseX, mouseY)) {
            AEItemConfigSlot.drawSelectionOverlay(stackX, stackY, 16, 16);
        } else if (this.mouseOverStock(mouseX, mouseY)) {
            AEItemConfigSlot.drawSelectionOverlay(stackX + 90, stackY, 16, 16);
        }
    }

    private void drawSlots(boolean autoPull, int x, int y) {
        if (autoPull) {
            GuiTextures.SLOT_DARK.draw(x, y, 18, 18);
            GuiTextures.CONFIG_ARROW.draw(x, y, 18, 18);
        } else {
            GuiTextures.SLOT.draw(x, y, 18, 18);
            GuiTextures.CONFIG_ARROW_DARK.draw(x, y, 18, 18);
        }
        GuiTextures.SLOT_DARK.draw(x + 90, y, 18, 18);
    }

    @Override
    public void drawInForeground(int mouseX, int mouseY) {
        super.drawInForeground(mouseX, mouseY);
        IAEItemStack item = null;
        IConfigurableSlot slot = this.getParentWidget().getDisplay(this.index);
        if (this.mouseOverConfig(mouseX, mouseY)) {
            item = (IAEItemStack)slot.getConfig();
        } else if (this.mouseOverStock(mouseX, mouseY)) {
            item = (IAEItemStack)slot.getStock();
        }
        if (item != null) {
            this.drawHoveringText(item.createItemStack(), AEItemConfigSlot.getItemToolTip(item.createItemStack()), -1, mouseX, mouseY);
        }
    }

    @Override
    protected void addHoverText(List<String> hoverText) {
        if (this.getParentWidget().isAutoPull()) {
            hoverText.add(I18n.func_135052_a((String)"gregtech.gui.config_slot", (Object[])new Object[0]));
            hoverText.add(I18n.func_135052_a((String)"gregtech.gui.config_slot.auto_pull_managed", (Object[])new Object[0]));
        } else {
            super.addHoverText(hoverText);
        }
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int button) {
        AEItemConfigWidget pw = this.getParentWidget();
        if (pw.isAutoPull()) {
            return false;
        }
        if (this.mouseOverConfig(mouseX, mouseY)) {
            if (button == 1) {
                this.writeClientAction(1000, buf -> {});
                if (!pw.isStocking()) {
                    pw.disableAmount();
                }
            } else if (button == 0) {
                ItemStack item = this.gui.entityPlayer.field_71071_by.func_70445_o();
                if (!item.func_190926_b()) {
                    this.writeClientAction(1001, buf -> buf.func_150788_a(item));
                    return true;
                }
                if (!pw.isStocking()) {
                    pw.enableAmount(this.index);
                    this.select = true;
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public void handleClientAction(int id, PacketBuffer buffer) {
        super.handleClientAction(id, buffer);
        IConfigurableSlot<WrappedItemStack> slot = this.parentWidget.getConfig(this.index);
        if (id == 1000) {
            slot.setConfig(null);
            this.parentWidget.disableAmount();
            this.writeUpdateInfo(1000, buf -> {});
        }
        if (id == 1001) {
            try {
                ItemStack item = buffer.func_150791_c();
                if (!this.isItemValidForSlot(item)) {
                    return;
                }
                slot.setConfig(WrappedItemStack.fromItemStack(item));
                this.parentWidget.enableAmount(this.index);
                if (!item.func_190926_b()) {
                    this.writeUpdateInfo(1001, buf -> buf.func_150788_a(item));
                }
            }
            catch (IOException item) {
                // empty catch block
            }
        }
        if (id == 1002 && slot.getConfig() != null) {
            int amt = buffer.readInt();
            ((IAEItemStack)slot.getConfig()).setStackSize((long)amt);
            this.writeUpdateInfo(1002, buf -> buf.writeInt(amt));
        }
    }

    @Override
    public void readUpdateInfo(int id, PacketBuffer buffer) {
        super.readUpdateInfo(id, buffer);
        IConfigurableSlot<WrappedItemStack> slot = this.parentWidget.getDisplay(this.index);
        if (id == 1000) {
            slot.setConfig(null);
        }
        if (id == 1001) {
            try {
                ItemStack item = buffer.func_150791_c();
                slot.setConfig(WrappedItemStack.fromItemStack(item));
            }
            catch (IOException item) {
                // empty catch block
            }
        }
        if (id == 1002 && slot.getConfig() != null) {
            int amt = buffer.readInt();
            ((IAEItemStack)slot.getConfig()).setStackSize((long)amt);
        }
    }

    private boolean isItemValidForSlot(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return true;
        }
        AEItemConfigWidget pw = this.getParentWidget();
        if (!pw.isStocking()) {
            return true;
        }
        return !pw.hasStackInConfig(stack);
    }

    @Override
    public List<IGhostIngredientHandler.Target<?>> getPhantomTargets(Object ingredient) {
        if (!(ingredient instanceof ItemStack)) {
            return Collections.emptyList();
        }
        final Rectangle rectangle = this.toRectangleBox();
        rectangle.width /= 6;
        return Lists.newArrayList((Object[])new IGhostIngredientHandler.Target[]{new IGhostIngredientHandler.Target<Object>(){

            @NotNull
            public Rectangle getArea() {
                return rectangle;
            }

            public void accept(@NotNull Object ingredient) {
                if (ingredient instanceof ItemStack) {
                    AEItemConfigSlot.this.writeClientAction(1001, buf -> buf.func_150788_a((ItemStack)ingredient));
                }
            }
        }});
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean mouseWheelMove(int mouseX, int mouseY, int wheelDelta) {
        long amt;
        if (this.parentWidget.isStocking()) {
            return false;
        }
        IConfigurableSlot slot = this.parentWidget.getDisplay(this.index);
        Rectangle rectangle = this.toRectangleBox();
        rectangle.width /= 6;
        if (slot.getConfig() == null || wheelDelta == 0 || !rectangle.contains(mouseX, mouseY)) {
            return false;
        }
        ItemStack stack = ((IAEItemStack)slot.getConfig()).createItemStack();
        if (AEItemConfigSlot.isCtrlDown()) {
            amt = wheelDelta > 0 ? (long)stack.func_190916_E() * 2L : (long)stack.func_190916_E() / 2L;
        } else {
            long l = amt = wheelDelta > 0 ? (long)stack.func_190916_E() + 1L : (long)stack.func_190916_E() - 1L;
        }
        if (amt > 0L && amt < 0x80000000L) {
            int finalAmt = (int)amt;
            this.writeClientAction(1002, buf -> buf.writeInt(finalAmt));
            return true;
        }
        return false;
    }
}

