/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.entities;

import gregtech.api.util.BlockUtility;
import gregtech.api.util.GregFakePlayer;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.item.EntityTNTPrimed;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;

public abstract class EntityGTExplosive
extends EntityTNTPrimed {
    public EntityGTExplosive(World world, double x, double y, double z, EntityLivingBase exploder) {
        super(world, x, y, z, exploder);
    }

    public EntityGTExplosive(World world) {
        super(world);
    }

    protected abstract float getStrength();

    public abstract boolean dropsAllBlocks();

    protected int getRange() {
        return 2;
    }

    @NotNull
    public abstract IBlockState getExplosiveState();

    public void func_70071_h_() {
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= (double)0.04f;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.field_70159_w *= (double)0.98f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)0.98f;
        if (this.field_70122_E) {
            this.field_70159_w *= (double)0.7f;
            this.field_70179_y *= (double)0.7f;
            this.field_70181_x *= -0.5;
        }
        this.func_184534_a(this.func_184536_l() - 1);
        if (this.func_184536_l() <= 0) {
            this.func_70106_y();
            if (!this.field_70170_p.field_72995_K) {
                this.explodeTNT();
            }
        } else {
            this.func_70072_I();
            this.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, 0.0, 0.0, 0.0, new int[0]);
        }
    }

    protected void explodeTNT() {
        this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + (double)(this.field_70131_O / 16.0f), this.field_70161_v, this.getStrength(), !this.dropsAllBlocks());
        if (!this.dropsAllBlocks()) {
            return;
        }
        if (this.field_70171_ac) {
            return;
        }
        FakePlayer player = GregFakePlayer.get((WorldServer)this.field_70170_p);
        int range = this.getRange();
        for (BlockPos pos : BlockPos.func_177980_a((BlockPos)this.func_180425_c().func_177982_a(-range, -range, -range), (BlockPos)this.func_180425_c().func_177982_a(range, range, range))) {
            IBlockState state = this.field_70170_p.func_180495_p(pos);
            if (state.func_185904_a() == Material.field_151579_a || state.func_185904_a() == Material.field_151586_h || state.func_185904_a() == Material.field_151587_i) continue;
            float hardness = state.func_185887_b(this.field_70170_p, pos);
            float resistance = state.func_177230_c().func_149638_a((Entity)player);
            if (!(hardness >= 0.0f) || !(resistance < 100.0f) || !this.field_70170_p.func_175660_a((EntityPlayer)player, pos)) continue;
            List<ItemStack> drops = this.attemptBreakBlockAndObtainDrops(pos, state, (EntityPlayer)player);
            for (ItemStack stack : drops) {
                EntityItem entity = new EntityItem(this.field_70170_p, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), stack);
                entity.func_174869_p();
                this.field_70170_p.func_72838_d((Entity)entity);
            }
        }
    }

    private List<ItemStack> attemptBreakBlockAndObtainDrops(BlockPos pos, IBlockState state, EntityPlayer player) {
        if (state.func_177230_c().removedByPlayer(state, this.field_70170_p, pos, player, true)) {
            this.field_70170_p.func_180498_a(null, 2001, pos, Block.func_176210_f((IBlockState)state));
            state.func_177230_c().func_176206_d(this.field_70170_p, pos, state);
            BlockUtility.startCaptureDrops();
            state.func_177230_c().func_180657_a(this.field_70170_p, player, pos, state, this.field_70170_p.func_175625_s(pos), ItemStack.field_190927_a);
            return BlockUtility.stopCaptureDrops();
        }
        return Collections.emptyList();
    }
}

