/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter.oreglob.impl;

import gregtech.api.util.GTLog;
import gregtech.api.util.LocalizationUtils;
import gregtech.api.util.oreglob.OreGlobTextBuilder;
import gregtech.common.covers.filter.oreglob.impl.NodeVisualXMLHandler;
import gregtech.common.covers.filter.oreglob.node.BranchType;
import gregtech.common.covers.filter.oreglob.node.NodeVisitor;
import gregtech.common.covers.filter.oreglob.node.OreGlobNode;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

class NodeVisualizer
implements NodeVisitor {
    private static boolean xmlParserErrorReported;
    private final OreGlobTextBuilder visualizer;
    private final int indents;

    NodeVisualizer(OreGlobTextBuilder visualizer) {
        this(visualizer, 0);
    }

    NodeVisualizer(OreGlobTextBuilder visualizer, int indents) {
        this.visualizer = visualizer;
        this.indents = indents;
    }

    void visit(OreGlobNode node) {
        boolean first = true;
        while (node != null) {
            if (first) {
                first = false;
            } else {
                this.visualizer.newLine(this.indents);
                NodeVisualizer.appendNodeXML(this.visualizer, "cover.ore_dictionary_filter.preview.next", new Object[0]);
            }
            node.visit(this);
            node = node.getNext();
        }
    }

    @Override
    public void match(String match, boolean ignoreCase, boolean not) {
        NodeVisualizer.appendNodeXML(this.visualizer, not ? "cover.ore_dictionary_filter.preview.match.not" : "cover.ore_dictionary_filter.preview.match", match);
    }

    @Override
    public void chars(int amount, boolean not) {
        if (amount == 1) {
            NodeVisualizer.appendNodeXML(this.visualizer, not ? "cover.ore_dictionary_filter.preview.char.not" : "cover.ore_dictionary_filter.preview.char", new Object[0]);
        } else {
            NodeVisualizer.appendNodeXML(this.visualizer, not ? "cover.ore_dictionary_filter.preview.chars.not" : "cover.ore_dictionary_filter.preview.chars", amount);
        }
    }

    @Override
    public void charsOrMore(int amount, boolean not) {
        NodeVisualizer.appendNodeXML(this.visualizer, not ? "cover.ore_dictionary_filter.preview.chars_or_more.not" : "cover.ore_dictionary_filter.preview.chars_or_more", amount);
    }

    @Override
    public void group(OreGlobNode node, boolean not) {
        if (not) {
            NodeVisualizer.appendNodeXML(this.visualizer, "cover.ore_dictionary_filter.preview.group", new Object[0]);
            this.visualizer.newLine(this.indents + 1);
            new NodeVisualizer(this.visualizer, this.indents + 1).visit(node);
        } else {
            this.visit(node);
        }
    }

    @Override
    public void branch(BranchType type, List<OreGlobNode> nodes, boolean not) {
        switch (type) {
            case OR: {
                NodeVisualizer.appendNodeXML(this.visualizer, not ? "cover.ore_dictionary_filter.preview.nor" : "cover.ore_dictionary_filter.preview.or", new Object[0]);
                for (int i = 0; i < nodes.size(); ++i) {
                    OreGlobNode node = nodes.get(i);
                    this.visualizer.newLine(this.indents);
                    NodeVisualizer.appendNodeXML(this.visualizer, i == 0 ? "cover.ore_dictionary_filter.preview.or.entry.start" : "cover.ore_dictionary_filter.preview.or.entry", new Object[0]);
                    new NodeVisualizer(this.visualizer, this.indents + 1).visit(node);
                }
                break;
            }
            case AND: {
                NodeVisualizer.appendNodeXML(this.visualizer, not ? "cover.ore_dictionary_filter.preview.nand" : "cover.ore_dictionary_filter.preview.and", new Object[0]);
                for (int i = 0; i < nodes.size(); ++i) {
                    OreGlobNode node = nodes.get(i);
                    this.visualizer.newLine(this.indents);
                    NodeVisualizer.appendNodeXML(this.visualizer, i == 0 ? "cover.ore_dictionary_filter.preview.and.entry.start" : "cover.ore_dictionary_filter.preview.and.entry", new Object[0]);
                    new NodeVisualizer(this.visualizer, this.indents + 1).visit(node);
                }
                break;
            }
            case XOR: {
                NodeVisualizer.appendNodeXML(this.visualizer, not ? "cover.ore_dictionary_filter.preview.xnor" : "cover.ore_dictionary_filter.preview.xor", new Object[0]);
                for (int i = 0; i < nodes.size() - 1; ++i) {
                    this.visualizer.newLine(this.indents + i);
                    NodeVisualizer.appendNodeXML(this.visualizer, "cover.ore_dictionary_filter.preview.xor.entry", new Object[0]);
                    new NodeVisualizer(this.visualizer, this.indents + i + 1).visit(nodes.get(i));
                    this.visualizer.newLine(this.indents + i);
                    NodeVisualizer.appendNodeXML(this.visualizer, "cover.ore_dictionary_filter.preview.xor.entry", new Object[0]);
                    if (i == nodes.size() - 2) {
                        new NodeVisualizer(this.visualizer, this.indents + i + 1).visit(nodes.get(nodes.size() - 1));
                        continue;
                    }
                    NodeVisualizer.appendNodeXML(this.visualizer, "cover.ore_dictionary_filter.preview.xor", new Object[0]);
                }
                break;
            }
            default: {
                throw new IllegalStateException("Unknown BranchType '" + (Object)((Object)type) + "'");
            }
        }
    }

    @Override
    public void everything() {
        NodeVisualizer.everything(this.visualizer);
    }

    @Override
    public void nothing() {
        NodeVisualizer.impossible(this.visualizer);
    }

    @Override
    public void nonempty() {
        NodeVisualizer.nonempty(this.visualizer);
    }

    @Override
    public void empty() {
        NodeVisualizer.empty(this.visualizer);
    }

    @Override
    public void error() {
        NodeVisualizer.error(this.visualizer);
    }

    public static void everything(OreGlobTextBuilder visualizer) {
        NodeVisualizer.appendNodeXML(visualizer, "cover.ore_dictionary_filter.preview.everything", new Object[0]);
    }

    public static void impossible(OreGlobTextBuilder visualizer) {
        NodeVisualizer.appendNodeXML(visualizer, "cover.ore_dictionary_filter.preview.impossible", new Object[0]);
    }

    public static void nonempty(OreGlobTextBuilder visualizer) {
        NodeVisualizer.appendNodeXML(visualizer, "cover.ore_dictionary_filter.preview.nonempty", new Object[0]);
    }

    public static void empty(OreGlobTextBuilder visualizer) {
        NodeVisualizer.appendNodeXML(visualizer, "cover.ore_dictionary_filter.preview.empty", new Object[0]);
    }

    public static void error(OreGlobTextBuilder visualizer) {
        NodeVisualizer.appendNodeXML(visualizer, "cover.ore_dictionary_filter.preview.error", new Object[0]);
    }

    private static void appendNodeXML(OreGlobTextBuilder visualizer, String key, Object ... args) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        factory.setNamespaceAware(false);
        factory.setXIncludeAware(false);
        factory.setValidating(false);
        try {
            SAXParser saxParser = factory.newSAXParser();
            Object[] args2 = new Object[args.length];
            for (int i = 0; i < args.length; ++i) {
                args2[i] = NodeVisualizer.toSanitizedString(args[i]);
            }
            String xml = "<root>" + LocalizationUtils.format(key, args2) + "</root>";
            saxParser.parse((InputStream)new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8)), (DefaultHandler)new NodeVisualXMLHandler(visualizer));
            return;
        }
        catch (ParserConfigurationException | SAXException ex) {
            if (!xmlParserErrorReported) {
                xmlParserErrorReported = true;
                GTLog.logger.error("Unable to create XML parser", (Throwable)ex);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        visualizer.getStringBuilder().append(LocalizationUtils.format(key, args));
    }

    @Nullable
    private static String toSanitizedString(@Nullable Object o) {
        if (o == null) {
            return null;
        }
        String s = o.toString();
        StringBuilder stb = null;
        block8: for (int i = 0; i < s.length(); i += Character.isSurrogate(s.charAt(i)) ? 2 : 1) {
            int codePoint = s.codePointAt(i);
            if (!(codePoint == 9 || codePoint == 10 || codePoint == 13 || codePoint >= 32 && codePoint <= 55295 || codePoint >= 57344 && codePoint <= 65533) && (codePoint < 65536 || codePoint > 0x10FFFF)) continue;
            switch (codePoint) {
                case 38: 
                case 60: 
                case 62: {
                    String string;
                    if (stb == null) {
                        stb = new StringBuilder();
                        stb.append(s, 0, i);
                    }
                    switch (codePoint) {
                        case 60: {
                            string = "&lt;";
                            break;
                        }
                        case 62: {
                            string = "&gt;";
                            break;
                        }
                        case 38: {
                            string = "&amp;";
                            break;
                        }
                        default: {
                            throw new IllegalStateException("Unreachable");
                        }
                    }
                    stb.append(string);
                    continue block8;
                }
                default: {
                    if (stb == null) continue block8;
                    stb.appendCodePoint(codePoint);
                }
            }
        }
        return stb == null ? s : stb.toString();
    }
}

