/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers.filter;

import gregtech.api.gui.GuiTextures;
import gregtech.api.gui.Widget;
import gregtech.api.gui.widgets.ServerWidgetGroup;
import gregtech.api.gui.widgets.ToggleButtonWidget;
import gregtech.api.util.IDirtyNotifiable;
import gregtech.common.covers.filter.FluidFilter;
import gregtech.common.covers.filter.WidgetGroupFluidFilter;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraftforge.fluids.FluidStack;

public class FluidFilterWrapper {
    private final IDirtyNotifiable dirtyNotifiable;
    private boolean isBlacklistFilter = false;
    private FluidFilter currentFluidFilter;
    private Supplier<Boolean> showTipSupplier;
    private int maxSize = 1000;

    public FluidFilterWrapper(IDirtyNotifiable dirtyNotifiable, int maxSize) {
        this.dirtyNotifiable = dirtyNotifiable;
        this.maxSize = maxSize;
    }

    public FluidFilterWrapper(IDirtyNotifiable dirtyNotifiable) {
        this.dirtyNotifiable = dirtyNotifiable;
    }

    public void initUI(int y, Consumer<Widget> widgetGroup) {
        widgetGroup.accept(new WidgetGroupFluidFilter(y, this::getFluidFilter, this.shouldShowTip()));
    }

    public void blacklistUI(int y, Consumer<Widget> widgetGroup, BooleanSupplier showBlacklistButton) {
        ServerWidgetGroup blacklistButton = new ServerWidgetGroup(() -> this.getFluidFilter() != null);
        blacklistButton.addWidget(new ToggleButtonWidget(144, y, 18, 18, GuiTextures.BUTTON_BLACKLIST, this::isBlacklistFilter, this::setBlacklistFilter).setPredicate(showBlacklistButton).setTooltipText("cover.filter.blacklist", new Object[0]));
        widgetGroup.accept(blacklistButton);
    }

    public void setFluidFilter(FluidFilter fluidFilter) {
        this.currentFluidFilter = fluidFilter;
        if (this.currentFluidFilter != null) {
            this.currentFluidFilter.setDirtyNotifiable(this.dirtyNotifiable);
            this.currentFluidFilter.setMaxConfigurableFluidSize(this.maxSize);
        }
    }

    private Supplier<Boolean> shouldShowTip() {
        return this.showTipSupplier;
    }

    protected void setTipSupplier(Supplier<Boolean> supplier) {
        this.showTipSupplier = supplier;
    }

    public FluidFilter getFluidFilter() {
        return this.currentFluidFilter;
    }

    public void onFilterInstanceChange() {
        this.dirtyNotifiable.markAsDirty();
    }

    public void setBlacklistFilter(boolean blacklistFilter) {
        this.isBlacklistFilter = blacklistFilter;
        this.dirtyNotifiable.markAsDirty();
    }

    public boolean isBlacklistFilter() {
        return this.isBlacklistFilter;
    }

    public boolean testFluidStack(FluidStack fluidStack, boolean whitelist) {
        boolean result = true;
        if (this.currentFluidFilter != null) {
            result = this.currentFluidFilter.testFluid(fluidStack);
        }
        if (!whitelist) {
            result = !result;
        }
        return result;
    }

    public boolean testFluidStack(FluidStack fluidStack) {
        boolean result = true;
        if (this.currentFluidFilter != null) {
            result = this.currentFluidFilter.testFluid(fluidStack);
        }
        if (this.isBlacklistFilter) {
            result = !result;
        }
        return result;
    }
}

