/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.covers;

import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import gregtech.api.GregTechAPI;
import gregtech.api.cover.Cover;
import gregtech.api.cover.CoverBase;
import gregtech.api.cover.CoverDefinition;
import gregtech.api.cover.CoverHolder;
import gregtech.api.cover.CoverableView;
import gregtech.api.util.GTTransferUtils;
import gregtech.api.util.GTUtility;
import gregtech.common.covers.CoverStorage;
import gregtech.common.inventory.handlers.ToolItemStackHandler;
import java.util.Collections;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated
@ApiStatus.ScheduledForRemoval(inVersion="2.9")
public class CoverCraftingTable
extends CoverBase
implements ITickable {
    private static final ResourceLocation STORAGE_COVER_LOCATION = GTUtility.gregtechId("storage");
    @Nullable
    private static CoverDefinition storageCoverDefinition = null;
    private static boolean attemptedStorageCoverLookup = false;
    private final ItemStackHandler internalInventory = new ItemStackHandler(18);
    private final ItemStackHandler toolInventory = new ToolItemStackHandler(9);

    public CoverCraftingTable(@NotNull CoverDefinition definition, @NotNull CoverableView coverableView, @NotNull EnumFacing attachedSide) {
        super(definition, coverableView, attachedSide);
    }

    @Override
    public boolean canAttach(@NotNull CoverableView coverable, @NotNull EnumFacing side) {
        return true;
    }

    @Override
    public boolean shouldAutoConnectToPipes() {
        return false;
    }

    @Override
    public void renderCover(@NotNull CCRenderState renderState, @NotNull Matrix4 translation, IVertexOperation[] pipeline, @NotNull Cuboid6 plateBox, @NotNull BlockRenderLayer layer) {
    }

    public void func_73660_a() {
        if (this.getWorld().field_72995_K) {
            return;
        }
        CoverableView coverableView = this.getCoverableView();
        if (coverableView instanceof CoverHolder) {
            IItemHandler itemHandler;
            CoverHolder holder = (CoverHolder)coverableView;
            EnumFacing coverSide = this.getAttachedSide();
            holder.removeCover(coverSide);
            if (!attemptedStorageCoverLookup) {
                storageCoverDefinition = (CoverDefinition)GregTechAPI.COVER_REGISTRY.func_82594_a(STORAGE_COVER_LOCATION);
                attemptedStorageCoverLookup = true;
            }
            if (storageCoverDefinition == null) {
                this.dropContents();
                return;
            }
            Cover cover = storageCoverDefinition.createCover(holder, coverSide);
            if (!holder.canPlaceCoverOnSide(coverSide) || !cover.canAttach(holder, coverSide)) {
                this.dropContents();
                return;
            }
            holder.addCover(coverSide, cover);
            cover.onAttachment(holder, coverSide, null, storageCoverDefinition.getDropItemStack());
            if (cover instanceof CoverStorage) {
                CoverStorage coverStorage = (CoverStorage)cover;
                itemHandler = coverStorage.getStorageHandler();
            } else {
                itemHandler = null;
            }
            if (itemHandler == null) {
                this.dropContents();
                return;
            }
            GTTransferUtils.moveInventoryItems((IItemHandler)this.internalInventory, itemHandler);
            GTTransferUtils.moveInventoryItems((IItemHandler)this.toolInventory, itemHandler);
            this.dropContents();
        }
    }

    private void dropContents() {
        this.dropInventoryContents((IItemHandlerModifiable)this.internalInventory);
        this.dropInventoryContents((IItemHandlerModifiable)this.toolInventory);
    }

    @Override
    @NotNull
    public List<ItemStack> getDrops() {
        return Collections.emptyList();
    }

    @Override
    public void writeToNBT(@NotNull NBTTagCompound tagCompound) {
        super.writeToNBT(tagCompound);
        tagCompound.func_74782_a("ToolInventory", (NBTBase)this.toolInventory.serializeNBT());
        tagCompound.func_74782_a("InternalInventory", (NBTBase)this.internalInventory.serializeNBT());
    }

    @Override
    public void readFromNBT(@NotNull NBTTagCompound tagCompound) {
        super.readFromNBT(tagCompound);
        this.toolInventory.deserializeNBT(tagCompound.func_74775_l("ToolInventory"));
        this.internalInventory.deserializeNBT(tagCompound.func_74775_l("InternalInventory"));
    }
}

