/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks.wood;

import gregtech.api.GregTechAPI;
import gregtech.common.blocks.MetaBlocks;
import gregtech.common.blocks.wood.BlockGregPlanks;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import org.jetbrains.annotations.NotNull;

public abstract class BlockGregWoodSlab
extends BlockSlab {
    private static final PropertyEnum<BlockGregPlanks.BlockType> VARIANT = PropertyEnum.func_177709_a((String)"variant", BlockGregPlanks.BlockType.class);

    public BlockGregWoodSlab() {
        super(Material.field_151575_d);
        this.func_149663_c("wood_slab");
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149672_a(SoundType.field_185848_a);
        this.setHarvestLevel("axe", 0);
        this.func_149647_a(GregTechAPI.TAB_GREGTECH_DECORATIONS);
        this.field_149783_u = true;
    }

    @NotNull
    public IProperty<BlockGregPlanks.BlockType> func_176551_l() {
        return VARIANT;
    }

    public int func_180651_a(IBlockState state) {
        return ((BlockGregPlanks.BlockType)((Object)state.func_177229_b(VARIANT))).ordinal();
    }

    @NotNull
    public Item func_180660_a(@NotNull IBlockState state, @NotNull Random rand, int fortune) {
        return Item.func_150898_a((Block)MetaBlocks.WOOD_SLAB);
    }

    @NotNull
    public String func_150002_b(int meta) {
        return super.func_149739_a() + "." + BlockGregWoodSlab.blockTypeFromMeta(meta).func_176610_l();
    }

    @NotNull
    public BlockGregPlanks.BlockType getTypeForItem(ItemStack stack) {
        return BlockGregWoodSlab.blockTypeFromMeta(stack.func_77960_j());
    }

    public void func_149666_a(@NotNull CreativeTabs tab, @NotNull NonNullList<ItemStack> items) {
        for (BlockGregPlanks.BlockType type : BlockGregPlanks.BlockType.values()) {
            items.add((Object)new ItemStack((Block)this, 1, type.ordinal()));
        }
    }

    private static BlockGregPlanks.BlockType blockTypeFromMeta(int meta) {
        return (meta & 1) != 0 ? BlockGregPlanks.BlockType.TREATED_PLANK : BlockGregPlanks.BlockType.RUBBER_PLANK;
    }

    public static class Double
    extends BlockGregWoodSlab {
        public Double() {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BlockGregPlanks.BlockType.RUBBER_PLANK)));
        }

        public boolean func_176552_j() {
            return true;
        }

        @NotNull
        public IBlockState func_176203_a(int meta) {
            return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BlockGregWoodSlab.blockTypeFromMeta(meta)));
        }

        public int func_176201_c(IBlockState state) {
            return ((BlockGregPlanks.BlockType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
        }

        @NotNull
        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{VARIANT});
        }
    }

    public static class Half
    extends BlockGregWoodSlab {
        public Half() {
            this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_176554_a, (Comparable)BlockSlab.EnumBlockHalf.BOTTOM).func_177226_a((IProperty)VARIANT, (Comparable)((Object)BlockGregPlanks.BlockType.RUBBER_PLANK)));
        }

        public boolean func_176552_j() {
            return false;
        }

        @NotNull
        public IBlockState func_176203_a(int meta) {
            return this.func_176223_P().func_177226_a((IProperty)VARIANT, (Comparable)((Object)BlockGregWoodSlab.blockTypeFromMeta(meta))).func_177226_a((IProperty)field_176554_a, (Comparable)((meta & 8) == 0 ? BlockSlab.EnumBlockHalf.BOTTOM : BlockSlab.EnumBlockHalf.TOP));
        }

        public int func_176201_c(IBlockState state) {
            int i = ((BlockGregPlanks.BlockType)((Object)state.func_177229_b((IProperty)VARIANT))).ordinal();
            if (state.func_177229_b((IProperty)field_176554_a) == BlockSlab.EnumBlockHalf.TOP) {
                i |= 8;
            }
            return i;
        }

        @NotNull
        protected BlockStateContainer func_180661_e() {
            return new BlockStateContainer((Block)this, new IProperty[]{field_176554_a, VARIANT});
        }

        public boolean doesSideBlockChestOpening(@NotNull IBlockState blockState, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EnumFacing side) {
            return false;
        }
    }
}

