/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common.blocks;

import gregtech.api.block.VariantBlock;
import gregtech.api.metatileentity.multiblock.IBatteryData;
import java.util.List;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLiving;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BlockBatteryPart
extends VariantBlock<BatteryPartType> {
    public BlockBatteryPart() {
        super(Material.field_151573_f);
        this.func_149663_c("battery_block");
        this.func_149711_c(5.0f);
        this.func_149752_b(10.0f);
        this.func_149672_a(SoundType.field_185852_e);
        this.setHarvestLevel("wrench", 3);
        this.func_180632_j(this.getState(BatteryPartType.EMPTY_TIER_I));
    }

    public boolean canCreatureSpawn(@NotNull IBlockState state, @NotNull IBlockAccess world, @NotNull BlockPos pos, @NotNull EntityLiving.SpawnPlacementType placementType) {
        return false;
    }

    @Override
    public void func_190948_a(@NotNull ItemStack stack, @Nullable World world, @NotNull List<String> tooltip, @NotNull ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        BatteryPartType batteryType = (BatteryPartType)this.getState(stack);
        if (batteryType.getCapacity() != 0L) {
            tooltip.add(I18n.func_135052_a((String)"gregtech.universal.tooltip.energy_storage_capacity", (Object[])new Object[]{batteryType.getCapacity()}));
        } else {
            tooltip.add(I18n.func_135052_a((String)"tile.battery_block.tooltip_empty", (Object[])new Object[0]));
        }
    }

    public static enum BatteryPartType implements IStringSerializable,
    IBatteryData
    {
        EMPTY_TIER_I,
        LAPOTRONIC_EV(4, 150000000L),
        LAPOTRONIC_IV(5, 1500000000L),
        EMPTY_TIER_II,
        LAPOTRONIC_LuV(6, 6000000000L),
        LAPOTRONIC_ZPM(7, 24000000000L),
        EMPTY_TIER_III,
        LAPOTRONIC_UV(8, 96000000000L),
        ULTIMATE_UHV(9, Long.MAX_VALUE);

        private final int tier;
        private final long capacity;

        private BatteryPartType() {
            this.tier = -1;
            this.capacity = 0L;
        }

        private BatteryPartType(int tier, long capacity) {
            this.tier = tier;
            this.capacity = capacity;
        }

        @Override
        public int getTier() {
            return this.tier;
        }

        @Override
        public long getCapacity() {
            return this.capacity;
        }

        @Override
        @NotNull
        public String getBatteryName() {
            return this.name().toLowerCase();
        }

        @NotNull
        public String func_176610_l() {
            return this.getBatteryName();
        }
    }
}

