/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.utils;

import gregtech.api.util.BlockInfo;
import gregtech.api.util.world.DummyWorld;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import javax.vecmath.Vector3f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
public class TrackedDummyWorld
extends DummyWorld {
    public final Set<BlockPos> renderedBlocks = new HashSet<BlockPos>();
    private Predicate<BlockPos> renderFilter;
    private final World proxyWorld;
    private final Vector3f minPos = new Vector3f(2.1474836E9f, 2.1474836E9f, 2.1474836E9f);
    private final Vector3f maxPos = new Vector3f(-2.1474836E9f, -2.1474836E9f, -2.1474836E9f);

    public void setRenderFilter(Predicate<BlockPos> renderFilter) {
        this.renderFilter = renderFilter;
    }

    public TrackedDummyWorld() {
        this.proxyWorld = null;
    }

    public TrackedDummyWorld(World world) {
        this.proxyWorld = world;
    }

    public void addBlocks(Map<BlockPos, BlockInfo> renderedBlocks) {
        renderedBlocks.forEach(this::addBlock);
    }

    public void addBlock(BlockPos pos, BlockInfo blockInfo) {
        if (blockInfo.getBlockState().func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        this.renderedBlocks.add(pos);
        blockInfo.apply(this, pos);
    }

    public TileEntity func_175625_s(@NotNull BlockPos pos) {
        if (this.renderFilter != null && !this.renderFilter.test(pos)) {
            return null;
        }
        return this.proxyWorld != null ? this.proxyWorld.func_175625_s(pos) : super.func_175625_s(pos);
    }

    @NotNull
    public IBlockState func_180495_p(@NotNull BlockPos pos) {
        if (this.renderFilter != null && !this.renderFilter.test(pos)) {
            return Blocks.field_150350_a.func_176223_P();
        }
        return this.proxyWorld != null ? this.proxyWorld.func_180495_p(pos) : super.func_180495_p(pos);
    }

    public boolean func_180501_a(@NotNull BlockPos pos, @NotNull IBlockState newState, int flags) {
        this.minPos.setX(Math.min(this.minPos.getX(), (float)pos.func_177958_n()));
        this.minPos.setY(Math.min(this.minPos.getY(), (float)pos.func_177956_o()));
        this.minPos.setZ(Math.min(this.minPos.getZ(), (float)pos.func_177952_p()));
        this.maxPos.setX(Math.max(this.maxPos.getX(), (float)pos.func_177958_n()));
        this.maxPos.setY(Math.max(this.maxPos.getY(), (float)pos.func_177956_o()));
        this.maxPos.setZ(Math.max(this.maxPos.getZ(), (float)pos.func_177952_p()));
        return super.func_180501_a(pos, newState, flags);
    }

    public Vector3f getSize() {
        Vector3f result = new Vector3f();
        result.setX(this.maxPos.getX() - this.minPos.getX() + 1.0f);
        result.setY(this.maxPos.getY() - this.minPos.getY() + 1.0f);
        result.setZ(this.maxPos.getZ() - this.minPos.getZ() + 1.0f);
        return result;
    }

    public Vector3f getMinPos() {
        return this.minPos;
    }

    public Vector3f getMaxPos() {
        return this.maxPos;
    }
}

