/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.texture.cube;

import gregtech.client.renderer.ICubeRenderer;
import gregtech.client.renderer.texture.cube.AlignedOrientedOverlayRenderer;
import gregtech.client.renderer.texture.cube.OrientedOverlayRenderer;
import java.util.EnumMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Experimental
public class LDPipeOverlayRenderer
extends AlignedOrientedOverlayRenderer {
    public LDPipeOverlayRenderer(@NotNull String basePath) {
        super(basePath);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(TextureMap textureMap) {
        this.sprites = new EnumMap(OrientedOverlayRenderer.OverlayFace.class);
        String modID = "gregtech";
        String basePath = this.basePath;
        String[] split = this.basePath.split(":");
        if (split.length == 2) {
            modID = split[0];
            basePath = split[1];
        }
        boolean foundTexture = false;
        for (OrientedOverlayRenderer.OverlayFace overlayFace : OrientedOverlayRenderer.OverlayFace.VALUES) {
            String faceName = overlayFace.name().toLowerCase();
            String overlayPath = String.format("blocks/%s/overlay_%s", basePath, faceName);
            TextureAtlasSprite normalSprite = ICubeRenderer.getResource(textureMap, modID, overlayPath);
            if (normalSprite == null) continue;
            foundTexture = true;
            TextureAtlasSprite normalSpriteEmissive = ICubeRenderer.getResource(textureMap, modID, overlayPath + "_emissive");
            this.sprites.put(overlayFace, new OrientedOverlayRenderer.ActivePredicate(normalSprite, normalSprite, null, normalSpriteEmissive, null, null));
        }
        if (!foundTexture) {
            FMLClientHandler.instance().trackMissingTexture(new ResourceLocation(modID, "blocks/" + basePath + "/overlay_OVERLAY_FACE"));
        }
    }
}

