/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.pipe;

import codechicken.lib.lighting.LightMatrix;
import codechicken.lib.render.BlockRenderer;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.block.BlockRenderingRegistry;
import codechicken.lib.render.block.ICCBlockRenderer;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.render.pipeline.ColourMultiplier;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.render.pipeline.IVertexSource;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.block.ItemBlockPipe;
import gregtech.api.pipenet.block.material.BlockMaterialPipe;
import gregtech.api.pipenet.block.material.TileEntityMaterialPipeBase;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.pipenet.tile.PipeCoverableImplementation;
import gregtech.api.pipenet.tile.TileEntityPipeBase;
import gregtech.api.unification.material.Material;
import gregtech.api.unification.material.info.MaterialIconType;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.CubeRendererState;
import gregtech.client.renderer.texture.Textures;
import gregtech.client.utils.ItemRenderCompat;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

@SideOnly(value=Side.CLIENT)
public abstract class PipeRenderer
implements ICCBlockRenderer,
IItemRenderer {
    public final ModelResourceLocation modelLocation;
    private final String name;
    private EnumBlockRenderType blockRenderType;
    protected static final ThreadLocal<BlockRenderer.BlockFace> blockFaces = ThreadLocal.withInitial(BlockRenderer.BlockFace::new);
    private static final Cuboid6 FRAME_RENDER_CUBOID = new Cuboid6(0.001, 0.001, 0.001, 0.999, 0.999, 0.999);
    private static final EnumMap<EnumFacing, EnumMap<Border, EnumFacing>> FACE_BORDER_MAP = new EnumMap(EnumFacing.class);
    private static final Int2ObjectMap<IVertexOperation[]> RESTRICTOR_MAP = new Int2ObjectOpenHashMap();

    public static void initializeRestrictor(TextureMap map) {
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY_UP, Border.TOP);
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY_DOWN, Border.BOTTOM);
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY_UD, Border.TOP, Border.BOTTOM);
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY_LEFT, Border.LEFT);
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY_UL, Border.TOP, Border.LEFT);
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY_DL, Border.BOTTOM, Border.LEFT);
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY_NR, Border.TOP, Border.BOTTOM, Border.LEFT);
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY_RIGHT, Border.RIGHT);
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY_UR, Border.TOP, Border.RIGHT);
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY_DR, Border.BOTTOM, Border.RIGHT);
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY_NL, Border.TOP, Border.BOTTOM, Border.RIGHT);
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY_LR, Border.LEFT, Border.RIGHT);
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY_ND, Border.TOP, Border.LEFT, Border.RIGHT);
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY_NU, Border.BOTTOM, Border.LEFT, Border.RIGHT);
        PipeRenderer.addRestrictor(Textures.PIPE_BLOCKED_OVERLAY, Border.TOP, Border.BOTTOM, Border.LEFT, Border.RIGHT);
    }

    public PipeRenderer(String name, ModelResourceLocation modelLocation) {
        this.name = name;
        this.modelLocation = modelLocation;
    }

    public PipeRenderer(String name, ResourceLocation modelLocation) {
        this(name, new ModelResourceLocation(modelLocation, "normal"));
    }

    public void preInit() {
        this.blockRenderType = BlockRenderingRegistry.createRenderType((String)this.name);
        BlockRenderingRegistry.registerRenderer((EnumBlockRenderType)this.blockRenderType, (ICCBlockRenderer)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        TextureUtils.addIconRegister(this::registerIcons);
    }

    public ModelResourceLocation getModelLocation() {
        return this.modelLocation;
    }

    public EnumBlockRenderType getBlockRenderType() {
        return this.blockRenderType;
    }

    public abstract void registerIcons(TextureMap var1);

    @SubscribeEvent
    public void onModelsBake(ModelBakeEvent event) {
        event.getModelRegistry().func_82595_a((Object)this.modelLocation, (Object)this);
    }

    public abstract void buildRenderer(PipeRenderContext var1, BlockPipe<?, ?, ?> var2, @Nullable IPipeTile<?, ?> var3, IPipeType<?> var4, @Nullable Material var5);

    public void renderItem(ItemStack rawItemStack, ItemCameraTransforms.TransformType transformType) {
        Material material;
        Material material2;
        ItemStack stack = ItemRenderCompat.getRepresentedStack(rawItemStack);
        if (!(stack.func_77973_b() instanceof ItemBlockPipe)) {
            return;
        }
        CCRenderState renderState = CCRenderState.instance();
        GlStateManager.func_179147_l();
        renderState.reset();
        renderState.startDrawing(7, DefaultVertexFormats.field_176599_b);
        BlockPipe blockFluidPipe = (BlockPipe)((ItemBlockPipe)stack.func_77973_b()).func_179223_d();
        IPipeType pipeType = (IPipeType)blockFluidPipe.getItemPipeType(stack);
        if (blockFluidPipe instanceof BlockMaterialPipe) {
            BlockMaterialPipe blockMaterialPipe = (BlockMaterialPipe)blockFluidPipe;
            material2 = blockMaterialPipe.getItemMaterial(stack);
        } else {
            material2 = material = null;
        }
        if (pipeType != null) {
            PipeRenderContext renderContext = new PipeRenderContext(12, 0, pipeType.getThickness());
            renderContext.color = GTUtility.convertRGBtoOpaqueRGBA_CL(PipeRenderer.getPipeColor(material, -1));
            this.buildRenderer(renderContext, blockFluidPipe, null, pipeType, material);
            this.renderPipeBlock(renderState, renderContext);
        }
        renderState.draw();
        GlStateManager.func_179084_k();
    }

    public boolean renderBlock(IBlockAccess world, BlockPos pos, IBlockState state, BufferBuilder buffer) {
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.setBrightness(world, pos);
        BlockPipe blockPipe = (BlockPipe)state.func_177230_c();
        IPipeTile pipeTile = blockPipe.getPipeTileEntity(world, pos);
        if (pipeTile == null) {
            return false;
        }
        IPipeType pipeType = (IPipeType)pipeTile.getPipeType();
        Material pipeMaterial = pipeTile instanceof TileEntityMaterialPipeBase ? ((TileEntityMaterialPipeBase)pipeTile).getPipeMaterial() : null;
        int paintingColor = pipeTile.getPaintingColor();
        int connectedSidesMap = pipeTile.getVisualConnections();
        int blockedConnections = pipeTile.getBlockedConnections();
        if (pipeType != null) {
            BlockRenderLayer renderLayer = MinecraftForgeClient.getRenderLayer();
            boolean[] sideMask = new boolean[EnumFacing.field_82609_l.length];
            for (EnumFacing side : EnumFacing.field_82609_l) {
                sideMask[side.func_176745_a()] = state.func_185894_c(world, pos, side);
            }
            Textures.RENDER_STATE.set(new CubeRendererState(renderLayer, sideMask, world));
            if (this.canRenderInLayer(renderLayer)) {
                renderState.lightMatrix.locate(world, pos);
                PipeRenderContext renderContext = new PipeRenderContext(pos, renderState.lightMatrix, connectedSidesMap, blockedConnections, pipeType.getThickness());
                renderContext.color = GTUtility.convertRGBtoOpaqueRGBA_CL(PipeRenderer.getPipeColor(pipeMaterial, paintingColor));
                this.buildRenderer(renderContext, blockPipe, pipeTile, pipeType, pipeMaterial);
                if (renderLayer == BlockRenderLayer.CUTOUT) {
                    this.renderPipeBlock(renderState, renderContext);
                    PipeRenderer.renderFrame(pipeTile, pos, renderState, connectedSidesMap);
                } else {
                    this.renderOtherLayers(renderLayer, renderState, renderContext);
                }
            }
            PipeCoverableImplementation coverHolder = pipeTile.getCoverableImplementation();
            coverHolder.renderCovers(renderState, new Matrix4().translate((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p()), renderLayer);
            Textures.RENDER_STATE.remove();
        }
        return true;
    }

    private static void renderFrame(IPipeTile<?, ?> pipeTile, BlockPos pos, CCRenderState renderState, int connections) {
        Material frameMaterial = pipeTile.getFrameMaterial();
        if (frameMaterial != null) {
            ResourceLocation rl = MaterialIconType.frameGt.getBlockTexturePath(frameMaterial.getMaterialIconSet());
            TextureAtlasSprite sprite = Minecraft.func_71410_x().func_147117_R().func_110572_b(rl.toString());
            IVertexOperation[] pipeline = new IVertexOperation[]{new Translation((Vec3i)pos), renderState.lightMatrix, new IconTransformation(sprite), new ColourMultiplier(GTUtility.convertRGBtoOpaqueRGBA_CL(frameMaterial.getMaterialRGB()))};
            for (EnumFacing side : EnumFacing.field_82609_l) {
                if ((connections & 1 << 12 + side.func_176745_a()) != 0) continue;
                BlockRenderer.BlockFace blockFace = blockFaces.get();
                blockFace.loadCuboidFace(FRAME_RENDER_CUBOID, side.func_176745_a());
                renderState.setPipeline((IVertexSource)blockFace, 0, blockFace.verts.length, pipeline);
                renderState.render();
            }
        }
    }

    private static int getPipeColor(Material material, int paintingColor) {
        if (paintingColor == -1) {
            return material == null ? 0xFFFFFF : material.getMaterialRGB();
        }
        return paintingColor;
    }

    public void renderPipeBlock(CCRenderState renderState, PipeRenderContext renderContext) {
        Cuboid6 cuboid6 = BlockPipe.getSideBox(null, renderContext.pipeThickness);
        if ((renderContext.connections & 0x3F) == 0) {
            for (EnumFacing renderedSide : EnumFacing.field_82609_l) {
                this.renderOpenFace(renderState, renderContext, renderedSide, cuboid6);
            }
        } else {
            for (EnumFacing renderedSide : EnumFacing.field_82609_l) {
                if ((renderContext.connections & 1 << renderedSide.func_176745_a()) == 0) {
                    int oppositeIndex = renderedSide.func_176734_d().func_176745_a();
                    if ((renderContext.connections & 1 << oppositeIndex) > 0 && (renderContext.connections & 0x3F & ~(1 << oppositeIndex)) == 0) {
                        this.renderOpenFace(renderState, renderContext, renderedSide, cuboid6);
                        continue;
                    }
                    this.renderPipeSide(renderState, renderContext, renderedSide, cuboid6);
                    continue;
                }
                this.renderPipeCube(renderState, renderContext, renderedSide);
            }
        }
    }

    protected void renderPipeCube(CCRenderState renderState, PipeRenderContext renderContext, EnumFacing side) {
        Cuboid6 cuboid = BlockPipe.getSideBox(side, renderContext.pipeThickness);
        boolean doRenderBlockedOverlay = (renderContext.blockedConnections & 1 << side.func_176745_a()) > 0;
        for (EnumFacing renderedSide : EnumFacing.field_82609_l) {
            if (renderedSide.func_176740_k() == side.func_176740_k()) continue;
            this.renderPipeSide(renderState, renderContext, renderedSide, cuboid);
            if (!doRenderBlockedOverlay) continue;
            this.renderFace(renderState, renderContext.blockedOverlay, renderedSide, cuboid);
        }
        if ((renderContext.connections & 1 << 6 + side.func_176745_a()) > 0) {
            this.renderPipeSide(renderState, renderContext, side, cuboid);
        } else {
            if ((renderContext.connections & 1 << 12 + side.func_176745_a()) > 0) {
                cuboid = BlockPipe.getCoverSideBox(side, renderContext.pipeThickness);
            }
            this.renderOpenFace(renderState, renderContext, side, cuboid);
        }
    }

    protected void renderOpenFace(CCRenderState renderState, PipeRenderContext renderContext, EnumFacing side, Cuboid6 cuboid6) {
        for (IVertexOperation[] vertexOperations : renderContext.openFaceRenderer) {
            this.renderFace(renderState, vertexOperations, side, cuboid6);
        }
    }

    protected void renderPipeSide(CCRenderState renderState, PipeRenderContext renderContext, EnumFacing side, Cuboid6 cuboid6) {
        for (IVertexOperation[] vertexOperations : renderContext.pipeSideRenderer) {
            this.renderFace(renderState, vertexOperations, side, cuboid6);
        }
        int blockedConnections = renderContext.getBlockedConnections();
        int connections = renderContext.getConnections();
        if (blockedConnections != 0) {
            int borderMask = 0;
            for (Border border : Border.VALUES) {
                EnumFacing borderSide = PipeRenderer.getSideAtBorder(side, border);
                if (!TileEntityPipeBase.isFaceBlocked(blockedConnections, borderSide) || !TileEntityPipeBase.isConnected(connections, borderSide)) continue;
                borderMask |= border.mask;
            }
            if (borderMask != 0) {
                IVertexOperation[] pipeline = (IVertexOperation[])ArrayUtils.addAll((Object[])renderContext.getBaseVertexOperation(), (Object[])((IVertexOperation[])RESTRICTOR_MAP.get(borderMask)));
                this.renderFace(renderState, pipeline, side, cuboid6);
            }
        }
    }

    protected void renderFace(CCRenderState renderState, IVertexOperation[] pipeline, EnumFacing side, Cuboid6 cuboid6) {
        BlockRenderer.BlockFace blockFace = blockFaces.get();
        blockFace.loadCuboidFace(cuboid6, side.func_176745_a());
        renderState.setPipeline((IVertexSource)blockFace, 0, blockFace.verts.length, pipeline);
        renderState.render();
    }

    public void renderBrightness(IBlockState state, float brightness) {
    }

    protected void renderOtherLayers(BlockRenderLayer layer, CCRenderState renderState, PipeRenderContext renderContext) {
    }

    protected boolean canRenderInLayer(BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    public void handleRenderBlockDamage(IBlockAccess world, BlockPos pos, IBlockState state, TextureAtlasSprite sprite, BufferBuilder buffer) {
        CCRenderState renderState = CCRenderState.instance();
        renderState.reset();
        renderState.bind(buffer);
        renderState.setPipeline(new IVertexOperation[]{new Vector3(new Vec3d((Vec3i)pos)).translation(), new IconTransformation(sprite)});
        BlockPipe blockPipe = (BlockPipe)state.func_177230_c();
        IPipeTile pipeTile = blockPipe.getPipeTileEntity(world, pos);
        if (pipeTile == null) {
            return;
        }
        IPipeType pipeType = (IPipeType)pipeTile.getPipeType();
        if (pipeType == null) {
            return;
        }
        float thickness = pipeType.getThickness();
        int connectedSidesMask = pipeTile.getConnections();
        Cuboid6 baseBox = BlockPipe.getSideBox(null, thickness);
        BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)baseBox, (int)0);
        for (EnumFacing renderSide : EnumFacing.field_82609_l) {
            if ((connectedSidesMask & 1 << renderSide.func_176745_a()) <= 0) continue;
            Cuboid6 sideBox = BlockPipe.getSideBox(renderSide, thickness);
            BlockRenderer.renderCuboid((CCRenderState)renderState, (Cuboid6)sideBox, (int)0);
        }
    }

    public void registerTextures(TextureMap map) {
    }

    public IModelState getTransforms() {
        return TransformUtils.DEFAULT_BLOCK;
    }

    public TextureAtlasSprite func_177554_e() {
        return TextureUtils.getMissingSprite();
    }

    public boolean func_188618_c() {
        return true;
    }

    public boolean func_177555_b() {
        return true;
    }

    public boolean func_177556_c() {
        return true;
    }

    public Pair<TextureAtlasSprite, Integer> getParticleTexture(IPipeTile<?, ?> pipeTile) {
        Material material;
        if (pipeTile == null) {
            return Pair.of((Object)TextureUtils.getMissingSprite(), (Object)0xFFFFFF);
        }
        IPipeType pipeType = (IPipeType)pipeTile.getPipeType();
        Material material2 = material = pipeTile instanceof TileEntityMaterialPipeBase ? ((TileEntityMaterialPipeBase)pipeTile).getPipeMaterial() : null;
        if (pipeType == null) {
            return Pair.of((Object)TextureUtils.getMissingSprite(), (Object)0xFFFFFF);
        }
        TextureAtlasSprite atlasSprite = this.getParticleTexture(pipeType, material);
        int pipeColor = PipeRenderer.getPipeColor(material, pipeTile.getPaintingColor());
        return Pair.of((Object)atlasSprite, (Object)pipeColor);
    }

    public abstract TextureAtlasSprite getParticleTexture(IPipeType<?> var1, @Nullable Material var2);

    private static EnumMap<Border, EnumFacing> borderMap(EnumFacing topSide, EnumFacing bottomSide, EnumFacing leftSide, EnumFacing rightSide) {
        EnumMap<Border, EnumFacing> sideMap = new EnumMap<Border, EnumFacing>(Border.class);
        sideMap.put(Border.TOP, topSide);
        sideMap.put(Border.BOTTOM, bottomSide);
        sideMap.put(Border.LEFT, leftSide);
        sideMap.put(Border.RIGHT, rightSide);
        return sideMap;
    }

    private static void addRestrictor(TextureAtlasSprite sprite, Border ... borders) {
        int mask = 0;
        for (Border border : borders) {
            mask |= border.mask;
        }
        RESTRICTOR_MAP.put(mask, (Object)new IVertexOperation[]{new IconTransformation(sprite)});
    }

    protected static EnumFacing getSideAtBorder(EnumFacing side, Border border) {
        return FACE_BORDER_MAP.get(side).get((Object)border);
    }

    static {
        FACE_BORDER_MAP.put(EnumFacing.DOWN, PipeRenderer.borderMap(EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST));
        FACE_BORDER_MAP.put(EnumFacing.UP, PipeRenderer.borderMap(EnumFacing.NORTH, EnumFacing.SOUTH, EnumFacing.WEST, EnumFacing.EAST));
        FACE_BORDER_MAP.put(EnumFacing.NORTH, PipeRenderer.borderMap(EnumFacing.UP, EnumFacing.DOWN, EnumFacing.EAST, EnumFacing.WEST));
        FACE_BORDER_MAP.put(EnumFacing.SOUTH, PipeRenderer.borderMap(EnumFacing.UP, EnumFacing.DOWN, EnumFacing.WEST, EnumFacing.EAST));
        FACE_BORDER_MAP.put(EnumFacing.WEST, PipeRenderer.borderMap(EnumFacing.UP, EnumFacing.DOWN, EnumFacing.NORTH, EnumFacing.SOUTH));
        FACE_BORDER_MAP.put(EnumFacing.EAST, PipeRenderer.borderMap(EnumFacing.UP, EnumFacing.DOWN, EnumFacing.SOUTH, EnumFacing.NORTH));
    }

    public static enum Border {
        TOP,
        BOTTOM,
        LEFT,
        RIGHT;

        public static final Border[] VALUES;
        public final int mask = 1 << this.ordinal();

        static {
            VALUES = Border.values();
        }
    }

    public static class PipeRenderContext {
        private final BlockPos pos;
        private final LightMatrix lightMatrix;
        protected final List<IVertexOperation[]> openFaceRenderer = new ArrayList<IVertexOperation[]>();
        protected final List<IVertexOperation[]> pipeSideRenderer = new ArrayList<IVertexOperation[]>();
        private final IVertexOperation[] blockedOverlay;
        private final float pipeThickness;
        private int color;
        private final int connections;
        private final int blockedConnections;

        public PipeRenderContext(BlockPos pos, LightMatrix lightMatrix, int connections, int blockedConnections, float thickness) {
            this.pos = pos;
            this.lightMatrix = lightMatrix;
            this.connections = connections;
            this.blockedConnections = blockedConnections;
            this.pipeThickness = thickness;
            this.blockedOverlay = pos != null && lightMatrix != null ? new IVertexOperation[]{new Translation((Vec3i)pos), lightMatrix, new IconTransformation(Textures.PIPE_BLOCKED_OVERLAY)} : new IVertexOperation[]{new IconTransformation(Textures.PIPE_BLOCKED_OVERLAY)};
        }

        public PipeRenderContext(int connections, int blockedConnections, float thickness) {
            this(null, null, connections, blockedConnections, thickness);
        }

        public PipeRenderContext addOpenFaceRender(IVertexOperation ... vertexOperations) {
            return this.addOpenFaceRender(true, vertexOperations);
        }

        public PipeRenderContext addOpenFaceRender(boolean applyDefaultColor, IVertexOperation ... vertexOperations) {
            Object[] baseVertexOperation = this.getBaseVertexOperation();
            baseVertexOperation = (IVertexOperation[])ArrayUtils.addAll((Object[])baseVertexOperation, (Object[])vertexOperations);
            if (applyDefaultColor) {
                baseVertexOperation = (IVertexOperation[])ArrayUtils.addAll((Object[])baseVertexOperation, (Object[])new IVertexOperation[]{this.getColorOperation()});
            }
            this.openFaceRenderer.add((IVertexOperation[])baseVertexOperation);
            return this;
        }

        public PipeRenderContext addSideRender(IVertexOperation ... vertexOperations) {
            return this.addSideRender(true, vertexOperations);
        }

        public PipeRenderContext addSideRender(boolean applyDefaultColor, IVertexOperation ... vertexOperations) {
            Object[] baseVertexOperation = this.getBaseVertexOperation();
            baseVertexOperation = (IVertexOperation[])ArrayUtils.addAll((Object[])baseVertexOperation, (Object[])vertexOperations);
            if (applyDefaultColor) {
                baseVertexOperation = (IVertexOperation[])ArrayUtils.addAll((Object[])baseVertexOperation, (Object[])new IVertexOperation[]{this.getColorOperation()});
            }
            this.pipeSideRenderer.add((IVertexOperation[])baseVertexOperation);
            return this;
        }

        public ColourMultiplier getColorOperation() {
            return new ColourMultiplier(this.color);
        }

        protected IVertexOperation[] getBaseVertexOperation() {
            IVertexOperation[] iVertexOperationArray;
            if (this.pos == null) {
                IVertexOperation[] iVertexOperationArray2;
                if (this.lightMatrix == null) {
                    iVertexOperationArray2 = new IVertexOperation[]{};
                } else {
                    IVertexOperation[] iVertexOperationArray3 = new IVertexOperation[1];
                    iVertexOperationArray2 = iVertexOperationArray3;
                    iVertexOperationArray3[0] = this.lightMatrix;
                }
                return iVertexOperationArray2;
            }
            if (this.lightMatrix == null) {
                IVertexOperation[] iVertexOperationArray4 = new IVertexOperation[1];
                iVertexOperationArray = iVertexOperationArray4;
                iVertexOperationArray4[0] = new Translation((Vec3i)this.pos);
            } else {
                IVertexOperation[] iVertexOperationArray5 = new IVertexOperation[2];
                iVertexOperationArray5[0] = new Translation((Vec3i)this.pos);
                iVertexOperationArray = iVertexOperationArray5;
                iVertexOperationArray5[1] = this.lightMatrix;
            }
            return iVertexOperationArray;
        }

        public int getConnections() {
            return this.connections;
        }

        public int getBlockedConnections() {
            return this.blockedConnections;
        }

        public List<IVertexOperation[]> getPipeSideRenderer() {
            return this.pipeSideRenderer;
        }

        public List<IVertexOperation[]> getOpenFaceRenderer() {
            return this.openFaceRenderer;
        }

        public float getPipeThickness() {
            return this.pipeThickness;
        }
    }
}

