/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.pipe;

import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.uv.IconTransformation;
import gregtech.api.pipenet.block.BlockPipe;
import gregtech.api.pipenet.block.IPipeType;
import gregtech.api.pipenet.tile.IPipeTile;
import gregtech.api.unification.material.Material;
import gregtech.api.util.GTUtility;
import gregtech.client.renderer.pipe.PipeRenderer;
import gregtech.client.renderer.texture.Textures;
import gregtech.common.pipelike.itempipe.ItemPipeType;
import java.util.EnumMap;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import org.jetbrains.annotations.Nullable;

public class ItemPipeRenderer
extends PipeRenderer {
    public static final ItemPipeRenderer INSTANCE = new ItemPipeRenderer();
    private final EnumMap<ItemPipeType, TextureAtlasSprite> pipeTextures = new EnumMap(ItemPipeType.class);

    private ItemPipeRenderer() {
        super("gt_item_pipe", GTUtility.gregtechId("item_pipe"));
    }

    @Override
    public void registerIcons(TextureMap map) {
        this.pipeTextures.put(ItemPipeType.SMALL, Textures.PIPE_SMALL);
        this.pipeTextures.put(ItemPipeType.NORMAL, Textures.PIPE_NORMAL);
        this.pipeTextures.put(ItemPipeType.LARGE, Textures.PIPE_LARGE);
        this.pipeTextures.put(ItemPipeType.HUGE, Textures.PIPE_HUGE);
        this.pipeTextures.put(ItemPipeType.RESTRICTIVE_SMALL, Textures.PIPE_SMALL);
        this.pipeTextures.put(ItemPipeType.RESTRICTIVE_NORMAL, Textures.PIPE_NORMAL);
        this.pipeTextures.put(ItemPipeType.RESTRICTIVE_LARGE, Textures.PIPE_LARGE);
        this.pipeTextures.put(ItemPipeType.RESTRICTIVE_HUGE, Textures.PIPE_HUGE);
    }

    @Override
    public void buildRenderer(PipeRenderer.PipeRenderContext renderContext, BlockPipe<?, ?, ?> blockPipe, IPipeTile<?, ?> pipeTile, IPipeType<?> pipeType, @Nullable Material material) {
        if (material == null || !(pipeType instanceof ItemPipeType)) {
            return;
        }
        renderContext.addOpenFaceRender(new IVertexOperation[]{new IconTransformation(this.pipeTextures.get(pipeType))}).addSideRender(new IVertexOperation[]{new IconTransformation(Textures.PIPE_SIDE)});
        if (((ItemPipeType)pipeType).isRestrictive()) {
            renderContext.addSideRender(false, new IVertexOperation[]{new IconTransformation(Textures.RESTRICTIVE_OVERLAY)});
        }
    }

    @Override
    public TextureAtlasSprite getParticleTexture(IPipeType<?> pipeType, @Nullable Material material) {
        return Textures.PIPE_SIDE;
    }
}

