/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.handler;

import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.interfaces.IGregTechTileEntity;
import gregtech.api.metatileentity.multiblock.MultiblockControllerBase;
import gregtech.api.pattern.MultiblockShapeInfo;
import gregtech.api.util.BlockInfo;
import gregtech.client.utils.TrackedDummyWorld;
import java.util.HashMap;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class MultiblockPreviewRenderer {
    private static BlockPos mbpPos;
    private static long mbpEndTime;
    private static int opList;
    private static int layer;

    public static void renderWorldLastEvent(RenderWorldLastEvent event) {
        if (mbpPos != null) {
            Minecraft mc = Minecraft.func_71410_x();
            long time = System.currentTimeMillis();
            if (opList == -1 || time > mbpEndTime || !(mc.field_71441_e.func_175625_s(mbpPos) instanceof IGregTechTileEntity)) {
                MultiblockPreviewRenderer.resetMultiblockRender();
                layer = 0;
                return;
            }
            Entity entity = mc.func_175606_aa();
            if (entity == null) {
                entity = mc.field_71439_g;
            }
            float partialTicks = event.getPartialTicks();
            double tx = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTicks;
            double ty = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks;
            double tz = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTicks;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureMap.field_110575_b);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179094_E();
            GlStateManager.func_179137_b((double)(-tx), (double)(-ty), (double)(-tz));
            GlStateManager.func_179147_l();
            GlStateManager.func_179148_o((int)opList);
            GlStateManager.func_179145_e();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public static void renderMultiBlockPreview(MultiblockControllerBase controller, long durTimeMillis) {
        if (!controller.getPos().equals((Object)mbpPos)) {
            layer = 0;
        } else {
            if (mbpEndTime - System.currentTimeMillis() < 200L) {
                return;
            }
            ++layer;
        }
        MultiblockPreviewRenderer.resetMultiblockRender();
        mbpPos = controller.getPos();
        mbpEndTime = System.currentTimeMillis() + durTimeMillis;
        opList = GLAllocation.func_74526_a((int)1);
        GlStateManager.func_187423_f((int)opList, (int)4864);
        List<MultiblockShapeInfo> shapes = controller.getMatchingShapes();
        if (!shapes.isEmpty()) {
            MultiblockPreviewRenderer.renderControllerInList(controller, shapes.get(0), layer);
        }
        GlStateManager.func_187415_K();
    }

    public static void resetMultiblockRender() {
        mbpPos = null;
        mbpEndTime = 0L;
        if (opList != -1) {
            GlStateManager.func_187449_e((int)opList, (int)1);
            opList = -1;
        }
    }

    public static void renderControllerInList(MultiblockControllerBase controllerBase, MultiblockShapeInfo shapeInfo, int layer) {
        BlockPos mbpPos = controllerBase.getPos();
        EnumFacing previewFacing = controllerBase.getFrontFacing();
        BlockPos controllerPos = BlockPos.field_177992_a;
        MultiblockControllerBase mte = null;
        BlockInfo[][][] blocks = shapeInfo.getBlocks();
        HashMap<BlockPos, BlockInfo> blockMap = new HashMap<BlockPos, BlockInfo>();
        int maxY = 0;
        for (int x = 0; x < blocks.length; ++x) {
            BlockInfo[][] aisle = blocks[x];
            maxY = Math.max(maxY, aisle.length);
            block1: for (int y = 0; y < aisle.length; ++y) {
                BlockInfo[] column = aisle[y];
                for (int z = 0; z < column.length; ++z) {
                    MetaTileEntity metaTE;
                    blockMap.put(new BlockPos(x, y, z), column[z]);
                    MetaTileEntity metaTileEntity = metaTE = column[z].getTileEntity() instanceof IGregTechTileEntity ? ((IGregTechTileEntity)column[z].getTileEntity()).getMetaTileEntity() : null;
                    if (!(metaTE instanceof MultiblockControllerBase) || !metaTE.metaTileEntityId.equals((Object)controllerBase.metaTileEntityId)) continue;
                    controllerPos = new BlockPos(x, y, z);
                    previewFacing = metaTE.getFrontFacing();
                    mte = (MultiblockControllerBase)metaTE;
                    continue block1;
                }
            }
        }
        TrackedDummyWorld world = new TrackedDummyWorld();
        world.addBlocks(blockMap);
        int finalMaxY = layer % (maxY + 1);
        world.setRenderFilter(pos -> pos.func_177956_o() + 1 == finalMaxY || finalMaxY == 0);
        EnumFacing facing = controllerBase.getFrontFacing();
        EnumFacing upwardsFacing = controllerBase.getUpwardsFacing();
        EnumFacing frontFacing = facing.func_96559_d() == 0 ? facing : (facing.func_96559_d() < 0 ? upwardsFacing : upwardsFacing.func_176734_d());
        Rotation rotatePreviewBy = Rotation.values()[(4 + frontFacing.func_176736_b() - previewFacing.func_176736_b()) % 4];
        Minecraft mc = Minecraft.func_71410_x();
        BlockRendererDispatcher brd = mc.func_175602_ab();
        Tessellator tes = Tessellator.func_178181_a();
        BufferBuilder buff = tes.func_178180_c();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)mbpPos.func_177958_n(), (float)mbpPos.func_177956_o(), (float)mbpPos.func_177952_p());
        GlStateManager.func_179137_b((double)0.5, (double)0.0, (double)0.5);
        GlStateManager.func_179114_b((float)(rotatePreviewBy.ordinal() * 90), (float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_179137_b((double)-0.5, (double)0.0, (double)-0.5);
        if (facing == EnumFacing.UP) {
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179114_b((float)90.0f, (float)(-previewFacing.func_82599_e()), (float)0.0f, (float)previewFacing.func_82601_c());
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        } else if (facing == EnumFacing.DOWN) {
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179114_b((float)90.0f, (float)previewFacing.func_82599_e(), (float)0.0f, (float)(-previewFacing.func_82601_c()));
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        } else {
            int degree = 90 * (upwardsFacing == EnumFacing.EAST ? -1 : (upwardsFacing == EnumFacing.SOUTH ? 2 : (upwardsFacing == EnumFacing.WEST ? 1 : 0)));
            GlStateManager.func_179137_b((double)0.5, (double)0.5, (double)0.5);
            GlStateManager.func_179114_b((float)degree, (float)previewFacing.func_82601_c(), (float)0.0f, (float)previewFacing.func_82599_e());
            GlStateManager.func_179137_b((double)-0.5, (double)-0.5, (double)-0.5);
        }
        if (mte != null) {
            mte.checkStructurePattern();
        }
        BlockRenderLayer oldLayer = MinecraftForgeClient.getRenderLayer();
        TargetBlockAccess targetBA = new TargetBlockAccess((IBlockAccess)world, BlockPos.field_177992_a);
        for (BlockPos pos2 : blockMap.keySet()) {
            targetBA.setPos(pos2);
            GlStateManager.func_179094_E();
            BlockPos.MutableBlockPos tPos = new BlockPos.MutableBlockPos(pos2.func_177973_b((Vec3i)controllerPos));
            GlStateManager.func_179109_b((float)tPos.func_177958_n(), (float)tPos.func_177956_o(), (float)tPos.func_177952_p());
            GlStateManager.func_179137_b((double)0.125, (double)0.125, (double)0.125);
            GlStateManager.func_179139_a((double)0.75, (double)0.75, (double)0.75);
            buff.func_181668_a(7, DefaultVertexFormats.field_176600_a);
            IBlockState state = world.func_180495_p(pos2);
            for (BlockRenderLayer brl : BlockRenderLayer.values()) {
                if (!state.func_177230_c().canRenderInLayer(state, brl)) continue;
                ForgeHooksClient.setRenderLayer((BlockRenderLayer)brl);
                brd.func_175018_a(state, BlockPos.field_177992_a, (IBlockAccess)targetBA, buff);
            }
            tes.func_78381_a();
            GlStateManager.func_179121_F();
        }
        ForgeHooksClient.setRenderLayer((BlockRenderLayer)oldLayer);
        GlStateManager.func_179121_F();
    }

    static {
        opList = -1;
    }

    @SideOnly(value=Side.CLIENT)
    private static class TargetBlockAccess
    implements IBlockAccess {
        private final IBlockAccess delegate;
        private BlockPos targetPos;

        public TargetBlockAccess(IBlockAccess delegate, BlockPos pos) {
            this.delegate = delegate;
            this.targetPos = pos;
        }

        public void setPos(BlockPos pos) {
            this.targetPos = pos;
        }

        public TileEntity func_175625_s(BlockPos pos) {
            return pos.equals((Object)BlockPos.field_177992_a) ? this.delegate.func_175625_s(this.targetPos) : null;
        }

        public int func_175626_b(BlockPos pos, int lightValue) {
            return 15;
        }

        public IBlockState func_180495_p(BlockPos pos) {
            return pos.equals((Object)BlockPos.field_177992_a) ? this.delegate.func_180495_p(this.targetPos) : Blocks.field_150350_a.func_176223_P();
        }

        public boolean func_175623_d(BlockPos pos) {
            return !pos.equals((Object)BlockPos.field_177992_a) || this.delegate.func_175623_d(this.targetPos);
        }

        public Biome func_180494_b(BlockPos pos) {
            return this.delegate.func_180494_b(this.targetPos);
        }

        public int func_175627_a(BlockPos pos, EnumFacing direction) {
            return 0;
        }

        public WorldType func_175624_G() {
            return this.delegate.func_175624_G();
        }

        public boolean isSideSolid(BlockPos pos, EnumFacing side, boolean _default) {
            return pos.equals((Object)BlockPos.field_177992_a) && this.delegate.isSideSolid(this.targetPos, side, _default);
        }
    }
}

