/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.renderer.handler;

import gregtech.api.gui.GuiTextures;
import gregtech.common.blocks.BlockLamp;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;

public class LampItemOverlayRenderer {
    public static OverlayType getOverlayType(ItemStack stack) {
        Block block;
        Item item = stack.func_77973_b();
        if (item instanceof ItemBlock && (block = ((ItemBlock)item).func_179223_d()) instanceof BlockLamp) {
            BlockLamp lamp = (BlockLamp)block;
            return LampItemOverlayRenderer.getOverlayType(lamp.isLightEnabled(stack), lamp.isBloomEnabled(stack));
        }
        return OverlayType.NONE;
    }

    public static OverlayType getOverlayType(boolean light, boolean bloom) {
        if (light) {
            return bloom ? OverlayType.NONE : OverlayType.NO_BLOOM;
        }
        return bloom ? OverlayType.NO_LIGHT : OverlayType.NO_BLOOM_NO_LIGHT;
    }

    public static void renderOverlay(OverlayType overlayType, int xPosition, int yPosition) {
        if (overlayType == OverlayType.NONE) {
            return;
        }
        GlStateManager.func_179140_f();
        GlStateManager.func_179097_i();
        GlStateManager.func_179118_c();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        if (overlayType.noBloom()) {
            GuiTextures.LAMP_NO_BLOOM.draw(xPosition, yPosition, 16, 16);
        }
        if (overlayType.noLight()) {
            GuiTextures.LAMP_NO_LIGHT.draw(xPosition, yPosition, 16, 16);
        }
        GlStateManager.func_179141_d();
        GlStateManager.func_179145_e();
        GlStateManager.func_179126_j();
    }

    public static enum OverlayType {
        NONE,
        NO_BLOOM,
        NO_LIGHT,
        NO_BLOOM_NO_LIGHT;


        public boolean noLight() {
            return this == NO_LIGHT || this == NO_BLOOM_NO_LIGHT;
        }

        public boolean noBloom() {
            return this == NO_BLOOM || this == NO_BLOOM_NO_LIGHT;
        }
    }
}

