/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.model.lamp;

import gregtech.api.util.GTUtility;
import gregtech.client.model.BorderlessLampBakedModel;
import gregtech.client.model.lamp.LampBakedModel;
import java.util.Objects;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.util.ResourceLocation;

public abstract class LampModelType {
    public static final LampModelType LAMP = new LampModelType(GTUtility.gregtechId("lamp")){

        @Override
        public IBakedModel createModel(ModelResourceLocation modelLocation) {
            return new LampBakedModel(modelLocation);
        }

        @Override
        public IBakedModel createModel(IBakedModel model) {
            return new LampBakedModel(model);
        }
    };
    public static final LampModelType BORDERLESS_LAMP = new LampModelType(GTUtility.gregtechId("lamp_borderless")){

        @Override
        public IBakedModel createModel(ModelResourceLocation modelLocation) {
            return new BorderlessLampBakedModel(modelLocation);
        }

        @Override
        public IBakedModel createModel(IBakedModel model) {
            return new BorderlessLampBakedModel(model);
        }
    };
    public final ResourceLocation modelName;

    public LampModelType(ResourceLocation modelName) {
        this.modelName = Objects.requireNonNull(modelName);
    }

    public abstract IBakedModel createModel(ModelResourceLocation var1);

    public abstract IBakedModel createModel(IBakedModel var1);

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LampModelType that = (LampModelType)o;
        return this.modelName.equals((Object)that.modelName);
    }

    public int hashCode() {
        return Objects.hash(this.modelName);
    }

    public String toString() {
        return "LampModelType{modelName='" + this.modelName + '\'' + '}';
    }
}

