/*
 * Decompiled with CFR 0.152.
 */
package gregtech.client.event;

import gregtech.api.fluids.GTFluidBlock;
import gregtech.api.util.GTUtility;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.client.event.RenderBlockOverlayEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.jetbrains.annotations.NotNull;

@SideOnly(value=Side.CLIENT)
@Mod.EventBusSubscriber(value={Side.CLIENT}, modid="gregtech")
public class FluidVisualHandler {
    private static final ResourceLocation SUBMERGED_FLUID_OVERLAY = GTUtility.gregtechId("textures/blocks/fluids/submerged_fluid_overlay.png");

    @SubscribeEvent
    public static void onFOVModifier(@NotNull EntityViewRenderEvent.FOVModifier event) {
        if (event.getState().func_177230_c() instanceof GTFluidBlock && ((GTFluidBlock)event.getState().func_177230_c()).isSticky()) {
            event.setFOV(event.getFOV() * 60.0f / 70.0f);
        }
    }

    @SubscribeEvent
    public static void onBlockOverlayRender(@NotNull RenderBlockOverlayEvent event) {
        if (event.getOverlayType() != RenderBlockOverlayEvent.OverlayType.WATER) {
            return;
        }
        EntityPlayer player = event.getPlayer();
        BlockPos blockpos = new BlockPos(player.field_70165_t, player.field_70163_u + (double)player.func_70047_e(), player.field_70161_v);
        Block block = player.field_70170_p.func_180495_p(blockpos).func_177230_c();
        if (block instanceof GTFluidBlock) {
            GTFluidBlock fluidBlock = (GTFluidBlock)block;
            int color = fluidBlock.getFluid().getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            Minecraft.func_71410_x().func_110434_K().func_110577_a(SUBMERGED_FLUID_OVERLAY);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexBuffer = tessellator.func_178180_c();
            float brightness = player.func_70013_c();
            GlStateManager.func_179131_c((float)(brightness * r), (float)(brightness * g), (float)(brightness * b), (float)0.5f);
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179094_E();
            float yaw = -player.field_70177_z / 64.0f;
            float pitch = player.field_70125_A / 64.0f;
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexBuffer.func_181662_b(-1.0, -1.0, -0.5).func_187315_a((double)(4.0f + yaw), (double)(4.0f + pitch)).func_181675_d();
            vertexBuffer.func_181662_b(1.0, -1.0, -0.5).func_187315_a((double)(0.0f + yaw), (double)(4.0f + pitch)).func_181675_d();
            vertexBuffer.func_181662_b(1.0, 1.0, -0.5).func_187315_a((double)(0.0f + yaw), (double)(0.0f + pitch)).func_181675_d();
            vertexBuffer.func_181662_b(-1.0, 1.0, -0.5).func_187315_a((double)(4.0f + yaw), (double)(0.0f + pitch)).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179084_k();
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFogColor(@NotNull EntityViewRenderEvent.FogColors event) {
        PotionEffect blindness;
        Block block = event.getState().func_177230_c();
        if (!(block instanceof GTFluidBlock)) {
            return;
        }
        GTFluidBlock fluidBlock = (GTFluidBlock)block;
        int color = fluidBlock.getFluid().getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        EntityRenderer renderer = event.getRenderer();
        float partialTicks = (float)event.getRenderPartialTicks();
        Entity entity = event.getEntity();
        float respiration = 0.0f;
        if (entity instanceof EntityLivingBase) {
            respiration = (float)EnchantmentHelper.func_185292_c((EntityLivingBase)((EntityLivingBase)entity)) * 0.2f;
            if (((EntityLivingBase)entity).func_70644_a(MobEffects.field_76427_o)) {
                respiration = respiration * 0.3f + 0.6f;
            }
        }
        r += respiration;
        g += respiration;
        b += respiration;
        float modifier = renderer.field_78535_ad + (renderer.field_78539_ae - renderer.field_78535_ad) * partialTicks;
        r *= modifier;
        g *= modifier;
        b *= modifier;
        double modifier2 = (entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTicks) * entity.func_130014_f_().field_73011_w.func_76565_k();
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76440_q) && (blindness = ((EntityLivingBase)entity).func_70660_b(MobEffects.field_76440_q)) != null) {
            int duration = blindness.func_76459_b();
            modifier2 = duration < 20 ? (modifier2 *= (double)(1.0f - (float)duration / 20.0f)) : 0.0;
        }
        if (modifier2 < 1.0) {
            if (modifier2 < 0.0) {
                modifier2 = 0.0;
            }
            modifier2 *= modifier2;
            r = (float)((double)r * modifier2);
            g = (float)((double)g * modifier2);
            b = (float)((double)b * modifier2);
        }
        if (renderer.field_82831_U > 0.0f) {
            float bossColor = renderer.field_82832_V + (renderer.field_82831_U - renderer.field_82832_V) * partialTicks;
            r = r * (1.0f - bossColor) + r * 0.7f * bossColor;
            g = g * (1.0f - bossColor) + g * 0.6f * bossColor;
            b = b * (1.0f - bossColor) + b * 0.6f * bossColor;
        }
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76439_r)) {
            float nightVisionBrightness = renderer.func_180438_a((EntityLivingBase)entity, partialTicks);
            float nightVisionModifier = 1.0f / r;
            if (nightVisionModifier > 1.0f / g) {
                nightVisionModifier = 1.0f / g;
            }
            if (nightVisionModifier > 1.0f / b) {
                nightVisionModifier = 1.0f / b;
            }
            r = r * (1.0f - nightVisionBrightness) + r * nightVisionModifier * nightVisionBrightness;
            g = g * (1.0f - nightVisionBrightness) + g * nightVisionModifier * nightVisionBrightness;
            b = b * (1.0f - nightVisionBrightness) + b * nightVisionModifier * nightVisionBrightness;
        }
        if (Minecraft.func_71410_x().field_71474_y.field_74337_g) {
            float rNew = (r * 30.0f + g * 59.0f + b * 11.0f) / 100.0f;
            float gNew = (r * 30.0f + g * 70.0f) / 100.0f;
            float bNew = (r * 30.0f + b * 70.0f) / 100.0f;
            r = rNew;
            g = gNew;
            b = bNew;
        }
        event.setRed(r);
        event.setGreen(g);
        event.setBlue(b);
    }

    @SubscribeEvent
    public static void onFogDensity(@NotNull EntityViewRenderEvent.FogDensity event) {
        if (!(event.getState().func_177230_c() instanceof GTFluidBlock)) {
            return;
        }
        EntityRenderer renderer = event.getRenderer();
        Entity entity = event.getEntity();
        if (entity instanceof EntityLivingBase && ((EntityLivingBase)entity).func_70644_a(MobEffects.field_76440_q)) {
            return;
        }
        if (renderer.field_78500_U) {
            return;
        }
        GlStateManager.func_187430_a((GlStateManager.FogMode)GlStateManager.FogMode.EXP);
        if (entity instanceof EntityLivingBase) {
            if (((EntityLivingBase)entity).func_70644_a(MobEffects.field_76427_o)) {
                event.setDensity(0.01f);
            } else {
                event.setDensity(0.1f - (float)EnchantmentHelper.func_185292_c((EntityLivingBase)((EntityLivingBase)entity)) * 0.03f);
            }
        } else {
            event.setDensity(0.1f);
        }
    }
}

