/*
 * Decompiled with CFR 0.152.
 */
package gregtech.asm.util;

import gregtech.asm.util.ObfMapping;
import java.util.function.Function;
import net.minecraftforge.fml.common.FMLLog;
import org.apache.logging.log4j.Level;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

public class TargetClassVisitor
extends ClassVisitor {
    private String className;
    private final ObfMapping methodKey;
    private final Function<MethodVisitor, MethodVisitor> visitorCreator;
    private boolean foundMethod = false;

    public TargetClassVisitor(ClassVisitor cv, ObfMapping methodKey, Function<MethodVisitor, MethodVisitor> visitorCreator) {
        super(327680, cv);
        this.methodKey = methodKey.toRuntime();
        this.visitorCreator = visitorCreator;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        super.visit(version, access, name, signature, superName, interfaces);
        this.className = name;
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor visitor = super.visitMethod(access, name, desc, signature, exceptions);
        String methodKey = name + desc;
        if (this.methodKey.matches(name, desc)) {
            FMLLog.log((String)"GregTechTransformer", (Level)Level.INFO, (String)"Patched method %s in %s successfully", (Object[])new Object[]{methodKey, this.className});
            this.foundMethod = true;
            return this.visitorCreator.apply(visitor);
        }
        return visitor;
    }

    public void visitEnd() {
        super.visitEnd();
        if (!this.foundMethod) {
            FMLLog.log((String)"GregTechTransformer", (Level)Level.FATAL, (String)"Failed to find method %s in %s.", (Object[])new Object[]{this.methodKey, this.className});
            throw new RuntimeException("Failed to patch method " + (Object)((Object)this.methodKey) + ", loading cannot continue. Check your environment is correct.");
        }
    }
}

