/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.worldgen.config;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import gregtech.api.unification.ore.StoneType;
import gregtech.api.unification.ore.StoneTypes;
import gregtech.api.util.GTUtility;
import gregtech.api.util.WorldBlockPredicate;
import gregtech.api.worldgen.config.OreConfigUtils;
import gregtech.api.worldgen.config.PredicateConfigUtils;
import gregtech.api.worldgen.filler.FillerEntry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.commons.lang3.tuple.Pair;

public class FillerConfigUtils {
    public static FillerEntry createBlockStateFiller(JsonElement element) {
        if (element instanceof JsonPrimitive) {
            String stringDeclaration = element.getAsString();
            return FillerConfigUtils.createSimpleFiller(stringDeclaration);
        }
        if (element instanceof JsonObject) {
            String predicateType;
            JsonObject object = element.getAsJsonObject();
            if (object.has("block")) {
                IBlockState stateDefinition = PredicateConfigUtils.parseBlockStateDefinition(object);
                return FillerEntry.createSimpleFiller(stateDefinition);
            }
            Preconditions.checkArgument((boolean)object.has("type"), (Object)"Missing required type for block state predicate");
            switch (predicateType = object.get("type").getAsString()) {
                case "weight_random": {
                    return FillerConfigUtils.createWeightRandomStateFiller(object);
                }
                case "state_match": {
                    return FillerConfigUtils.createStateMatchFiller(object);
                }
            }
            throw new IllegalArgumentException("Unknown filler match type: " + predicateType);
        }
        throw new IllegalArgumentException("Unknown block state type " + element);
    }

    private static FillerEntry createSimpleFiller(String stringDeclaration) {
        if (stringDeclaration.startsWith("block:")) {
            Block block = OreConfigUtils.getBlockByName(stringDeclaration.substring(6));
            return FillerEntry.createSimpleFiller(block.func_176223_P());
        }
        if (stringDeclaration.startsWith("fluid:")) {
            String fluidName = stringDeclaration.substring(6);
            Fluid fluid = FluidRegistry.getFluid((String)fluidName);
            Preconditions.checkNotNull((Object)fluid, (String)"Fluid not found with name %s", (Object)fluidName);
            Preconditions.checkNotNull((Object)fluid.getBlock(), (String)"Block is not defined for fluid %s", (Object)fluidName);
            return FillerEntry.createSimpleFiller(fluid.getBlock().func_176223_P());
        }
        if (stringDeclaration.startsWith("ore:")) {
            Map<StoneType, IBlockState> blockStateMap = OreConfigUtils.getOreStateMap(stringDeclaration);
            return new OreFilterEntry(blockStateMap);
        }
        if (stringDeclaration.startsWith("ore_dict:")) {
            String oreDictName = stringDeclaration.substring(9);
            IBlockState firstBlock = OreConfigUtils.getOreDictBlocks(oreDictName).get(0);
            return FillerEntry.createSimpleFiller(firstBlock);
        }
        throw new IllegalArgumentException("Unknown string block state declaration: " + stringDeclaration);
    }

    private static FillerEntry createStateMatchFiller(JsonObject object) {
        JsonArray valuesArray = object.get("values").getAsJsonArray();
        JsonElement defaultElement = object.get("default");
        ArrayList<Pair<WorldBlockPredicate, FillerEntry>> matchers = new ArrayList<Pair<WorldBlockPredicate, FillerEntry>>();
        for (JsonElement valueDefinition : valuesArray) {
            Preconditions.checkArgument((boolean)valueDefinition.isJsonObject(), (String)"Found invalid value definition: %s", (Object)valueDefinition.toString());
            JsonObject valueObject = valueDefinition.getAsJsonObject();
            WorldBlockPredicate predicate = PredicateConfigUtils.createBlockStatePredicate(valueObject.get("predicate"));
            FillerEntry filler = FillerConfigUtils.createBlockStateFiller(valueObject.get("value"));
            matchers.add((Pair<WorldBlockPredicate, FillerEntry>)Pair.of((Object)predicate, (Object)filler));
        }
        if (!defaultElement.isJsonNull()) {
            FillerEntry filler = FillerConfigUtils.createBlockStateFiller(defaultElement);
            WorldBlockPredicate predicate = (state, world, pos) -> true;
            matchers.add(Pair.of((Object)predicate, (Object)filler));
        } else {
            WorldBlockPredicate predicate = (state, world, pos) -> true;
            FillerEntry fillerEntry = (FillerEntry)((Pair)matchers.iterator().next()).getRight();
            matchers.add(Pair.of((Object)predicate, (Object)fillerEntry));
        }
        return new BlockStateMatcherEntry(matchers);
    }

    private static FillerEntry createWeightRandomStateFiller(JsonObject object) {
        JsonArray values = object.get("values").getAsJsonArray();
        ArrayList<Pair<Integer, FillerEntry>> randomList = new ArrayList<Pair<Integer, FillerEntry>>();
        for (JsonElement randomElement : values) {
            JsonObject randomObject = randomElement.getAsJsonObject();
            int weight = randomObject.get("weight").getAsInt();
            Preconditions.checkArgument((weight > 0 ? 1 : 0) != 0, (String)"Invalid weight: %d", (int)weight);
            FillerEntry filler = FillerConfigUtils.createBlockStateFiller(randomObject.get("value"));
            randomList.add((Pair<Integer, FillerEntry>)Pair.of((Object)weight, (Object)filler));
        }
        return new WeightRandomMatcherEntry(randomList);
    }

    public static LayeredFillerEntry createLayeredFiller(JsonObject object) {
        JsonArray values = object.get("values").getAsJsonArray();
        Preconditions.checkArgument((values.size() == 4 ? 1 : 0) != 0, (String)"Invalid number of ores in a Layered vein (should be 4, is actually %d", (int)values.size());
        return new LayeredFillerEntry(FillerConfigUtils.readLayerFiller(values.get(0).getAsJsonObject(), "primary"), FillerConfigUtils.readLayerFiller(values.get(1).getAsJsonObject(), "secondary"), FillerConfigUtils.readLayerFiller(values.get(2).getAsJsonObject(), "between"), FillerConfigUtils.createBlockStateFiller(values.get(3).getAsJsonObject().get("sporadic")));
    }

    private static Pair<FillerEntry, Integer> readLayerFiller(JsonObject object, String layerType) {
        FillerEntry filler = FillerConfigUtils.createBlockStateFiller(object.get(layerType));
        JsonElement layerElement = object.get("layers");
        int layers = -1;
        if (layerElement != null) {
            layers = layerElement.getAsInt();
        }
        return Pair.of((Object)filler, (Object)layers);
    }

    private static class OreFilterEntry
    implements FillerEntry {
        private final Map<StoneType, IBlockState> blockStateMap;
        private final ImmutableSet<IBlockState> allowedStates;
        private final StoneType defaultValue;

        public OreFilterEntry(Map<StoneType, IBlockState> blockStateMap) {
            this.blockStateMap = blockStateMap;
            this.defaultValue = blockStateMap.containsKey(StoneTypes.STONE) ? StoneTypes.STONE : blockStateMap.keySet().iterator().next();
            this.allowedStates = ImmutableSet.copyOf(blockStateMap.values());
        }

        @Override
        public IBlockState apply(IBlockState source, IBlockAccess blockAccess, BlockPos blockPos) {
            StoneType stoneType = StoneType.computeStoneType(source, blockAccess, blockPos);
            return this.blockStateMap.get(stoneType == null ? this.defaultValue : stoneType);
        }

        public Set<IBlockState> getPossibleResults() {
            return this.allowedStates;
        }
    }

    private static class BlockStateMatcherEntry
    implements FillerEntry {
        private final List<Pair<WorldBlockPredicate, FillerEntry>> matchers;
        private final ImmutableList<IBlockState> blockStates;

        public BlockStateMatcherEntry(List<Pair<WorldBlockPredicate, FillerEntry>> matchers) {
            this.matchers = matchers;
            ImmutableList.Builder stateBuilder = ImmutableList.builder();
            for (Pair<WorldBlockPredicate, FillerEntry> matcher : matchers) {
                stateBuilder.addAll(((FillerEntry)matcher.getRight()).getPossibleResults());
            }
            this.blockStates = stateBuilder.build();
        }

        @Override
        public IBlockState apply(IBlockState source, IBlockAccess blockAccess, BlockPos blockPos) {
            for (Pair<WorldBlockPredicate, FillerEntry> matcher : this.matchers) {
                if (!((WorldBlockPredicate)matcher.getLeft()).test(source, blockAccess, blockPos)) continue;
                return ((FillerEntry)matcher.getRight()).apply(source, blockAccess, blockPos);
            }
            return Blocks.field_150350_a.func_176223_P();
        }

        @Override
        public Collection<IBlockState> getPossibleResults() {
            return this.blockStates;
        }
    }

    private static class WeightRandomMatcherEntry
    implements FillerEntry {
        private final List<Pair<Integer, FillerEntry>> randomList;
        private final ImmutableList<IBlockState> blockStates;

        public WeightRandomMatcherEntry(List<Pair<Integer, FillerEntry>> randomList) {
            this.randomList = randomList;
            ImmutableList.Builder stateBuilder = ImmutableList.builder();
            for (Pair<Integer, FillerEntry> randomEntry : randomList) {
                stateBuilder.addAll(((FillerEntry)randomEntry.getRight()).getPossibleResults());
            }
            this.blockStates = stateBuilder.build();
        }

        @Override
        public IBlockState apply(IBlockState source, IBlockAccess blockAccess, BlockPos blockPos) {
            int functionIndex = GTUtility.getRandomItem(this.randomList, this.randomList.size());
            FillerEntry randomFunction = (FillerEntry)this.randomList.get(functionIndex).getValue();
            return randomFunction.apply(source, blockAccess, blockPos);
        }

        @Override
        public Collection<IBlockState> getPossibleResults() {
            return this.blockStates;
        }

        @Override
        public List<Pair<Integer, FillerEntry>> getEntries() {
            return this.randomList;
        }
    }

    public static class LayeredFillerEntry
    implements FillerEntry {
        private final FillerEntry primary;
        private final FillerEntry secondary;
        private final FillerEntry between;
        private final FillerEntry sporadic;
        private final int primaryLayers;
        private final int secondaryLayers;
        private final int betweenLayers;
        private final int sporadicDivisor;
        private final int startPrimary;
        private final int startBetween;
        private final ImmutableList<IBlockState> blockStates;

        public LayeredFillerEntry(Pair<FillerEntry, Integer> primary, Pair<FillerEntry, Integer> secondary, Pair<FillerEntry, Integer> between, FillerEntry sporadic) {
            this.primary = (FillerEntry)primary.getLeft();
            this.secondary = (FillerEntry)secondary.getLeft();
            this.between = (FillerEntry)between.getLeft();
            this.sporadic = sporadic;
            this.primaryLayers = (Integer)primary.getRight() == -1 ? 4 : (Integer)primary.getRight();
            this.secondaryLayers = (Integer)secondary.getRight() == -1 ? 3 : (Integer)secondary.getRight();
            this.betweenLayers = (Integer)between.getRight() == -1 ? 3 : (Integer)between.getRight();
            Preconditions.checkArgument((this.primaryLayers + this.secondaryLayers >= this.betweenLayers ? 1 : 0) != 0, (Object)"Error: cannot be more \"between\" layers than primary and secondary layers combined!");
            this.sporadicDivisor = this.primaryLayers + this.secondaryLayers - 1;
            this.startPrimary = this.secondaryLayers;
            this.startBetween = this.secondaryLayers - this.betweenLayers / 2;
            this.blockStates = ImmutableList.builder().addAll(this.primary.getPossibleResults()).addAll(this.secondary.getPossibleResults()).addAll(this.between.getPossibleResults()).addAll(this.sporadic.getPossibleResults()).build();
        }

        @Override
        public IBlockState apply(IBlockState source, IBlockAccess blockAccess, BlockPos blockPos) {
            return this.apply(source, blockAccess, blockPos, 1.0, new Random(), 0);
        }

        public IBlockState apply(IBlockState source, IBlockAccess blockAccess, BlockPos blockPos, double density, Random random, int layer) {
            if (layer >= this.startBetween && layer - this.startBetween + 1 <= this.betweenLayers && (double)random.nextFloat() <= density / 2.0) {
                return this.between.apply(source, blockAccess, blockPos);
            }
            if (layer >= this.startPrimary) {
                if ((double)random.nextFloat() <= density) {
                    return this.primary.apply(source, blockAccess, blockPos);
                }
            } else if ((double)random.nextFloat() <= density) {
                return this.secondary.apply(source, blockAccess, blockPos);
            }
            if ((double)random.nextFloat() <= density / (double)this.sporadicDivisor) {
                return this.sporadic.apply(source, blockAccess, blockPos);
            }
            return source;
        }

        @Override
        public Collection<IBlockState> getPossibleResults() {
            return this.blockStates;
        }

        @Override
        public List<Pair<Integer, FillerEntry>> getEntries() {
            return Collections.emptyList();
        }

        public FillerEntry getPrimary() {
            return this.primary;
        }

        public FillerEntry getSecondary() {
            return this.secondary;
        }

        public FillerEntry getBetween() {
            return this.between;
        }

        public FillerEntry getSporadic() {
            return this.sporadic;
        }

        public int getPrimaryLayers() {
            return this.primaryLayers;
        }

        public int getSecondaryLayers() {
            return this.secondaryLayers;
        }

        public int getBetweenLayers() {
            return this.betweenLayers;
        }
    }
}

