/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.input;

import gregtech.api.GregTechAPI;
import gregtech.api.util.GTLog;
import gregtech.core.network.packets.PacketKeysPressed;
import java.util.ArrayList;
import java.util.WeakHashMap;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.InputEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.tuple.MutablePair;
import org.lwjgl.input.Mouse;

public enum KeyBind {
    VANILLA_JUMP(() -> () -> Minecraft.func_71410_x().field_71474_y.field_74314_A),
    VANILLA_SNEAK(() -> () -> Minecraft.func_71410_x().field_71474_y.field_74311_E),
    VANILLA_FORWARD(() -> () -> Minecraft.func_71410_x().field_71474_y.field_74351_w),
    VANILLA_BACKWARD(() -> () -> Minecraft.func_71410_x().field_71474_y.field_74368_y),
    VANILLA_LEFT(() -> () -> Minecraft.func_71410_x().field_71474_y.field_74370_x),
    VANILLA_RIGHT(() -> () -> Minecraft.func_71410_x().field_71474_y.field_74366_z),
    ARMOR_MODE_SWITCH("gregtech.key.armor_mode_switch", (IKeyConflictContext)KeyConflictContext.IN_GAME, 50),
    ARMOR_HOVER("gregtech.key.armor_hover", (IKeyConflictContext)KeyConflictContext.IN_GAME, 35),
    ARMOR_CHARGING("gregtech.key.armor_charging", (IKeyConflictContext)KeyConflictContext.IN_GAME, 49),
    TOOL_AOE_CHANGE("gregtech.key.tool_aoe_change", (IKeyConflictContext)KeyConflictContext.IN_GAME, 47);

    public static final KeyBind[] VALUES;
    @SideOnly(value=Side.CLIENT)
    private KeyBinding keybinding;
    @SideOnly(value=Side.CLIENT)
    private boolean isPressed;
    @SideOnly(value=Side.CLIENT)
    private boolean isKeyDown;
    private final WeakHashMap<EntityPlayerMP, MutablePair<Boolean, Boolean>> mapping = new WeakHashMap();

    public static void init() {
        GTLog.logger.info("Registering KeyBinds");
        if (FMLCommonHandler.instance().getSide().isClient()) {
            MinecraftForge.EVENT_BUS.register(KeyBind.class);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public static void onInputEvent(InputEvent.KeyInputEvent event) {
        ArrayList<KeyBind> updating = new ArrayList<KeyBind>();
        for (KeyBind keybind : VALUES) {
            boolean previousPressed = keybind.isPressed;
            boolean previousKeyDown = keybind.isKeyDown;
            keybind.isPressed = keybind.isPressed();
            keybind.isKeyDown = keybind.isKeyDown();
            if (previousPressed == keybind.isPressed && previousKeyDown == keybind.isKeyDown) continue;
            updating.add(keybind);
        }
        if (!updating.isEmpty()) {
            GregTechAPI.networkHandler.sendToServer(new PacketKeysPressed(updating));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean scrollingUp() {
        return Mouse.getEventDWheel() > 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean notScrolling() {
        return Mouse.getEventDWheel() == 0;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean scrollingDown() {
        return Mouse.getEventDWheel() < 0;
    }

    private KeyBind(Supplier<Supplier<KeyBinding>> keybindingGetter) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.keybinding = keybindingGetter.get().get();
        }
    }

    private KeyBind(String langKey, int button) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.keybinding = new KeyBinding(langKey, button, "GregTech");
            ClientRegistry.registerKeyBinding((KeyBinding)this.keybinding);
        }
    }

    private KeyBind(String langKey, IKeyConflictContext ctx, int button) {
        if (FMLCommonHandler.instance().getSide().isClient()) {
            this.keybinding = new KeyBinding(langKey, ctx, button, "GregTech");
            ClientRegistry.registerKeyBinding((KeyBinding)this.keybinding);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public KeyBinding toMinecraft() {
        return this.keybinding;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isPressed() {
        return this.keybinding.func_151468_f();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean isKeyDown() {
        return this.keybinding.func_151470_d();
    }

    public void update(boolean pressed, boolean keyDown, EntityPlayerMP player) {
        MutablePair<Boolean, Boolean> pair = this.mapping.get(player);
        if (pair == null) {
            this.mapping.put(player, (MutablePair<Boolean, Boolean>)MutablePair.of((Object)pressed, (Object)keyDown));
        } else {
            pair.left = pressed;
            pair.right = keyDown;
        }
    }

    public boolean isPressed(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return this.isPressed();
        }
        MutablePair<Boolean, Boolean> pair = this.mapping.get((EntityPlayerMP)player);
        return pair != null && (Boolean)pair.left != false;
    }

    public boolean isKeyDown(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return this.isKeyDown();
        }
        MutablePair<Boolean, Boolean> pair = this.mapping.get((EntityPlayerMP)player);
        return pair != null && (Boolean)pair.right != false;
    }

    static {
        VALUES = KeyBind.values();
    }
}

