/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import org.jetbrains.annotations.NotNull;

public final class SmallDigits {
    private static final int SMALL_DOWN_NUMBER_BASE = 8320;
    private static final int SMALL_UP_NUMBER_BASE = 8320;
    private static final int NUMBER_BASE = 48;

    private SmallDigits() {
    }

    @NotNull
    public static String toSmallUpNumbers(String string) {
        return SmallDigits.convert(string, 8320);
    }

    @NotNull
    public static String toSmallDownNumbers(String string) {
        return SmallDigits.convert(string, 8320);
    }

    @NotNull
    private static String convert(@NotNull String string, int base) {
        boolean hasPrecedingDash = false;
        char[] charArray = string.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            int relativeIndex;
            boolean isDash;
            char c = charArray[i];
            boolean bl = isDash = c == '-';
            if (isDash) {
                hasPrecedingDash = true;
            }
            if ((relativeIndex = c - 48) >= 0 && relativeIndex <= 9) {
                if (hasPrecedingDash) continue;
                charArray[i] = (char)(base + relativeIndex);
                continue;
            }
            if (isDash || !hasPrecedingDash) continue;
            hasPrecedingDash = false;
        }
        return new String(charArray);
    }
}

