/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import net.minecraft.world.World;

public class PerTickIntCounter {
    private final int defaultValue;
    private long lastUpdatedWorldTime;
    private int lastValue;
    private int currentValue;

    public PerTickIntCounter(int defaultValue) {
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
        this.lastValue = defaultValue;
    }

    private void checkValueState(World world) {
        long currentWorldTime = world.func_82737_E();
        if (currentWorldTime != this.lastUpdatedWorldTime) {
            this.lastValue = currentWorldTime == this.lastUpdatedWorldTime + 1L ? this.currentValue : this.defaultValue;
            this.lastUpdatedWorldTime = currentWorldTime;
            this.currentValue = this.defaultValue;
        }
    }

    public int get(World world) {
        this.checkValueState(world);
        return this.currentValue;
    }

    public int getLast(World world) {
        this.checkValueState(world);
        return this.lastValue;
    }

    public void increment(World world, int value) {
        this.checkValueState(world);
        this.currentValue += value;
    }

    public void set(World world, int value) {
        this.checkValueState(world);
        this.currentValue = value;
    }
}

