/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import java.awt.Color;
import org.apache.commons.lang3.tuple.Pair;

public class GradientUtil {
    private GradientUtil() {
    }

    public static Pair<Color, Color> getGradient(Color rgb, int luminanceDifference) {
        float[] hsl = GradientUtil.RGBtoHSL(rgb);
        float[] upshade = new float[3];
        float[] downshade = new float[3];
        System.arraycopy(hsl, 0, upshade, 0, 3);
        System.arraycopy(hsl, 0, downshade, 0, 3);
        upshade[2] = upshade[2] + (float)luminanceDifference;
        if (upshade[2] > 100.0f) {
            upshade[2] = 100.0f;
        }
        downshade[2] = downshade[2] - (float)luminanceDifference;
        if (downshade[2] < 0.0f) {
            downshade[2] = 0.0f;
        }
        Color upshadeRgb = GradientUtil.toRGB(upshade);
        Color downshadeRgb = GradientUtil.toRGB(downshade);
        return Pair.of((Object)downshadeRgb, (Object)upshadeRgb);
    }

    public static Pair<Color, Color> getGradient(int rgb, int luminanceDifference) {
        return GradientUtil.getGradient(new Color(rgb), luminanceDifference);
    }

    public static float[] RGBtoHSL(Color rgbColor) {
        float[] rgb = rgbColor.getRGBColorComponents(null);
        float r = rgb[0];
        float g = rgb[1];
        float b = rgb[2];
        float min = Math.min(r, Math.min(g, b));
        float max = Math.max(r, Math.max(g, b));
        float h = 0.0f;
        if (max == min) {
            h = 0.0f;
        } else if (max == r) {
            h = (60.0f * (g - b) / (max - min) + 360.0f) % 360.0f;
        } else if (max == g) {
            h = 60.0f * (b - r) / (max - min) + 120.0f;
        } else if (max == b) {
            h = 60.0f * (r - g) / (max - min) + 240.0f;
        }
        float l = (max + min) / 2.0f;
        float s = max == min ? 0.0f : (l <= 0.5f ? (max - min) / (max + min) : (max - min) / (2.0f - max - min));
        return new float[]{h, s * 100.0f, l * 100.0f};
    }

    public static Color toRGB(float[] hsv) {
        return GradientUtil.toRGB(hsv[0], hsv[1], hsv[2]);
    }

    public static Color toRGB(float h, float s, float l) {
        h %= 360.0f;
        float q = (l /= 100.0f) < 0.5f ? l * (1.0f + s) : l + (s /= 100.0f) - s * l;
        float p = 2.0f * l - q;
        float r = Math.max(0.0f, GradientUtil.hueToRGB(p, q, (h /= 360.0f) + 0.33333334f));
        float g = Math.max(0.0f, GradientUtil.hueToRGB(p, q, h));
        float b = Math.max(0.0f, GradientUtil.hueToRGB(p, q, h - 0.33333334f));
        r = Math.min(r, 1.0f);
        g = Math.min(g, 1.0f);
        b = Math.min(b, 1.0f);
        return new Color(r, g, b);
    }

    private static float hueToRGB(float p, float q, float h) {
        if (h < 0.0f) {
            h += 1.0f;
        }
        if (h > 1.0f) {
            h -= 1.0f;
        }
        if (6.0f * h < 1.0f) {
            return p + (q - p) * 6.0f * h;
        }
        if (2.0f * h < 1.0f) {
            return q;
        }
        if (3.0f * h < 2.0f) {
            return p + (q - p) * 6.0f * (0.6666667f - h);
        }
        return p;
    }
}

