/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.capability.IMultipleTankHandler;
import gregtech.api.util.GTHashMaps;
import gregtech.api.util.OverlayedFluidHandler;
import gregtech.api.util.OverlayedItemHandler;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.NotNull;

public class GTTransferUtils {
    public static int transferFluids(@NotNull IFluidHandler sourceHandler, @NotNull IFluidHandler destHandler) {
        return GTTransferUtils.transferFluids(sourceHandler, destHandler, Integer.MAX_VALUE, fluidStack -> true);
    }

    public static int transferFluids(@NotNull IFluidHandler sourceHandler, @NotNull IFluidHandler destHandler, int transferLimit) {
        return GTTransferUtils.transferFluids(sourceHandler, destHandler, transferLimit, fluidStack -> true);
    }

    public static int transferFluids(@NotNull IFluidHandler sourceHandler, @NotNull IFluidHandler destHandler, int transferLimit, @NotNull Predicate<FluidStack> fluidFilter) {
        int fluidLeftToTransfer = transferLimit;
        for (IFluidTankProperties tankProperties : sourceHandler.getTankProperties()) {
            int canInsertAmount;
            FluidStack currentFluid = tankProperties.getContents();
            if (currentFluid == null || currentFluid.amount == 0 || !fluidFilter.test(currentFluid)) continue;
            currentFluid.amount = fluidLeftToTransfer;
            FluidStack fluidStack = sourceHandler.drain(currentFluid, false);
            if (fluidStack == null || fluidStack.amount == 0 || (canInsertAmount = destHandler.fill(fluidStack, false)) <= 0) continue;
            fluidStack.amount = canInsertAmount;
            if ((fluidStack = sourceHandler.drain(fluidStack, true)) == null || fluidStack.amount <= 0) continue;
            destHandler.fill(fluidStack, true);
            if ((fluidLeftToTransfer -= fluidStack.amount) == 0) break;
        }
        return transferLimit - fluidLeftToTransfer;
    }

    public static boolean transferExactFluidStack(@NotNull IFluidHandler sourceHandler, @NotNull IFluidHandler destHandler, FluidStack fluidStack) {
        int amount = fluidStack.amount;
        FluidStack sourceFluid = sourceHandler.drain(fluidStack, false);
        if (sourceFluid == null || sourceFluid.amount != amount) {
            return false;
        }
        int canInsertAmount = destHandler.fill(sourceFluid, false);
        if (canInsertAmount == amount && (sourceFluid = sourceHandler.drain(sourceFluid, true)) != null && sourceFluid.amount > 0) {
            destHandler.fill(sourceFluid, true);
            return true;
        }
        return false;
    }

    public static void moveInventoryItems(IItemHandler sourceInventory, IItemHandler targetInventory) {
        for (int srcIndex = 0; srcIndex < sourceInventory.getSlots(); ++srcIndex) {
            ItemStack sourceStack = sourceInventory.extractItem(srcIndex, Integer.MAX_VALUE, true);
            if (sourceStack.func_190926_b()) continue;
            ItemStack remainder = GTTransferUtils.insertItem(targetInventory, sourceStack, true);
            int amountToInsert = sourceStack.func_190916_E() - remainder.func_190916_E();
            if (amountToInsert <= 0) continue;
            sourceStack = sourceInventory.extractItem(srcIndex, amountToInsert, false);
            GTTransferUtils.insertItem(targetInventory, sourceStack, false);
        }
    }

    public static boolean addItemsToItemHandler(IItemHandler handler, boolean simulate, List<ItemStack> items) {
        if (simulate) {
            OverlayedItemHandler overlayedItemHandler = new OverlayedItemHandler(handler);
            Object2IntMap<ItemStack> stackKeyMap = GTHashMaps.fromItemStackCollection(items);
            for (Object2IntMap.Entry entry : stackKeyMap.object2IntEntrySet()) {
                int amountToInsert = entry.getIntValue();
                int amount = overlayedItemHandler.insertStackedItemStack((ItemStack)entry.getKey(), amountToInsert);
                if (amount <= 0) continue;
                return false;
            }
            return true;
        }
        items.forEach(stack -> GTTransferUtils.insertItem(handler, stack, false));
        return true;
    }

    public static boolean addFluidsToFluidHandler(IMultipleTankHandler fluidHandler, boolean simulate, List<FluidStack> fluidStacks) {
        if (simulate) {
            OverlayedFluidHandler overlayedFluidHandler = new OverlayedFluidHandler(fluidHandler);
            for (FluidStack fluidStack : fluidStacks) {
                int inserted = overlayedFluidHandler.insertFluid(fluidStack, fluidStack.amount);
                if (inserted == fluidStack.amount) continue;
                return false;
            }
            return true;
        }
        for (FluidStack fluidStack : fluidStacks) {
            fluidHandler.fill(fluidStack, true);
        }
        return true;
    }

    public static ItemStack insertItem(IItemHandler handler, ItemStack stack, boolean simulate) {
        if (handler == null || stack.func_190926_b()) {
            return stack;
        }
        if (!stack.func_77985_e()) {
            return GTTransferUtils.insertToEmpty(handler, stack, simulate);
        }
        IntArrayList emptySlots = new IntArrayList();
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (slotStack.func_190926_b()) {
                emptySlots.add(i);
                continue;
            }
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)slotStack) || !(stack = handler.insertItem(i, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        IntListIterator intListIterator = emptySlots.iterator();
        while (intListIterator.hasNext()) {
            int slot = (Integer)intListIterator.next();
            stack = handler.insertItem(slot, stack, simulate);
            if (!stack.func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static ItemStack insertToEmpty(IItemHandler handler, ItemStack stack, boolean simulate) {
        if (handler == null || stack.func_190926_b()) {
            return stack;
        }
        int slots = handler.getSlots();
        for (int i = 0; i < slots; ++i) {
            ItemStack slotStack = handler.getStackInSlot(i);
            if (!slotStack.func_190926_b() || !(stack = handler.insertItem(i, stack, simulate)).func_190926_b()) continue;
            return ItemStack.field_190927_a;
        }
        return stack;
    }

    public static void fillInternalTankFromFluidContainer(IFluidHandler fluidHandler, IItemHandlerModifiable itemHandler, int inputSlot, int outputSlot) {
        ItemStack inputContainerStack = itemHandler.extractItem(inputSlot, 1, true);
        FluidActionResult result = FluidUtil.tryEmptyContainer((ItemStack)inputContainerStack, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)false);
        if (result.isSuccess()) {
            ItemStack remainingItem = result.getResult();
            if (ItemStack.func_77989_b((ItemStack)inputContainerStack, (ItemStack)remainingItem)) {
                return;
            }
            if (!remainingItem.func_190926_b() && !itemHandler.insertItem(outputSlot, remainingItem, true).func_190926_b()) {
                return;
            }
            FluidUtil.tryEmptyContainer((ItemStack)inputContainerStack, (IFluidHandler)fluidHandler, (int)Integer.MAX_VALUE, null, (boolean)true);
            itemHandler.extractItem(inputSlot, 1, false);
            itemHandler.insertItem(outputSlot, remainingItem, false);
        }
    }
}

