/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import org.jetbrains.annotations.NotNull;

public class GTControlledRegistry<K, V>
extends RegistryNamespaced<K, V> {
    protected boolean frozen = true;
    protected final int maxId;

    public GTControlledRegistry(int maxId) {
        this.maxId = maxId;
    }

    public boolean isFrozen() {
        return this.frozen;
    }

    public void freeze() {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen!");
        }
        if (!GTControlledRegistry.checkActiveModContainerIsGregtech()) {
            return;
        }
        this.frozen = true;
    }

    public void unfreeze() {
        if (!this.frozen) {
            throw new IllegalStateException("Registry is already unfrozen!");
        }
        if (!GTControlledRegistry.checkActiveModContainerIsGregtech()) {
            return;
        }
        this.frozen = false;
    }

    private static boolean checkActiveModContainerIsGregtech() {
        ModContainer container = Loader.instance().activeModContainer();
        return container != null && container.getModId().equals("gregtech");
    }

    public void func_177775_a(int id, @NotNull K key, @NotNull V value) {
        if (id < 0 || id >= this.maxId) {
            throw new IndexOutOfBoundsException("Id is out of range: " + id);
        }
        super.func_82595_a(key, value);
        Object objectWithId = this.func_148754_a(id);
        if (objectWithId != null) {
            throw new IllegalArgumentException(String.format("Tried to reassign id %d to %s (%s), but it is already assigned to %s (%s)!", id, value, key, objectWithId, this.func_177774_c(objectWithId)));
        }
        this.field_148759_a.func_186814_a(value, id);
    }

    public void func_82595_a(@NotNull K key, @NotNull V value) {
        throw new UnsupportedOperationException("Use #register(int, String, T)");
    }

    public int getIdByObjectName(K key) {
        Object valueWithKey = this.func_82594_a(key);
        return valueWithKey == null ? 0 : this.func_148757_b(valueWithKey);
    }
}

