/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util;

import gregtech.api.unification.stack.ItemAndMetadata;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class CustomModPriorityComparator
implements Comparator<ItemAndMetadata> {
    private final List<String> modPriorityList;

    public CustomModPriorityComparator(List<String> modPriorities) {
        this.modPriorityList = new ArrayList<String>(modPriorities);
    }

    @Override
    public int compare(ItemAndMetadata first, ItemAndMetadata second) {
        String firstModId = Objects.requireNonNull(first.item.getRegistryName()).func_110624_b();
        String secondModId = Objects.requireNonNull(second.item.getRegistryName()).func_110624_b();
        int firstModIndex = this.modPriorityList.indexOf(firstModId);
        int secondModIndex = this.modPriorityList.indexOf(secondModId);
        if (firstModIndex == -1 && secondModIndex == -1) {
            return firstModId.compareTo(secondModId);
        }
        if (firstModIndex == -1) {
            return -1;
        }
        if (secondModIndex == -1) {
            return 1;
        }
        return Integer.compare(secondModIndex, firstModIndex);
    }
}

