/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.stack;

import gregtech.api.unification.stack.ItemVariantMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectMap;
import it.unimi.dsi.fastutil.shorts.Short2ObjectOpenHashMap;
import org.jetbrains.annotations.Nullable;

public final class MultiItemVariantMap<E>
implements ItemVariantMap.Mutable<E> {
    @Nullable
    private Short2ObjectOpenHashMap<E> itemDamageEntries;
    @Nullable
    private E wildcardEntry;

    @Override
    public boolean hasNonWildcardEntry() {
        return this.itemDamageEntries != null && !this.itemDamageEntries.isEmpty();
    }

    @Override
    public boolean has(short meta) {
        if (meta == Short.MAX_VALUE) {
            return this.wildcardEntry != null;
        }
        return this.itemDamageEntries != null && this.itemDamageEntries.containsKey(meta);
    }

    @Override
    @Nullable
    public E get(short meta) {
        if (meta == Short.MAX_VALUE) {
            return this.wildcardEntry;
        }
        if (this.itemDamageEntries != null) {
            return (E)this.itemDamageEntries.get(meta);
        }
        return null;
    }

    @Override
    @Nullable
    public E put(short meta, @Nullable E e) {
        if (meta == Short.MAX_VALUE) {
            E cache = this.wildcardEntry;
            this.wildcardEntry = e;
            return cache;
        }
        if (e != null) {
            if (this.itemDamageEntries == null) {
                this.itemDamageEntries = new Short2ObjectOpenHashMap();
            }
            return (E)this.itemDamageEntries.put(meta, e);
        }
        if (this.itemDamageEntries != null) {
            return (E)this.itemDamageEntries.remove(meta);
        }
        return null;
    }

    @Override
    public void clear() {
        this.itemDamageEntries = null;
        this.wildcardEntry = null;
    }

    public String toString() {
        StringBuilder stb = new StringBuilder().append("MultiItemVariantMap[");
        boolean first = true;
        if (this.itemDamageEntries != null) {
            for (Short2ObjectMap.Entry e : this.itemDamageEntries.short2ObjectEntrySet()) {
                if (first) {
                    first = false;
                } else {
                    stb.append(',');
                }
                stb.append(e.getShortKey()).append("=").append(e.getValue());
            }
        }
        if (this.wildcardEntry != null) {
            if (!first) {
                stb.append(',');
            }
            stb.append("*=").append(this.wildcardEntry);
        }
        return stb.append(']').toString();
    }
}

