/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.unification.material.registry;

import gregtech.api.unification.material.MarkerMaterial;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public final class MarkerMaterialRegistry {
    private static MarkerMaterialRegistry INSTANCE;
    private final Map<String, MarkerMaterial> map = new Object2ObjectOpenHashMap();

    private MarkerMaterialRegistry() {
    }

    public static MarkerMaterialRegistry getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new MarkerMaterialRegistry();
        }
        return INSTANCE;
    }

    @NotNull
    public MarkerMaterial registerMarkerMaterial(@NotNull MarkerMaterial markerMaterial) {
        MarkerMaterial existing = this.map.get(markerMaterial.getName());
        if (existing != null) {
            return existing;
        }
        this.map.put(markerMaterial.getName(), markerMaterial);
        return markerMaterial;
    }

    @Nullable
    public MarkerMaterial getMarkerMaterial(@NotNull String name) {
        return this.map.get(name);
    }

    @NotNull
    public @NotNull @UnmodifiableView Collection<@NotNull MarkerMaterial> getAll() {
        return Collections.unmodifiableCollection(this.map.values());
    }
}

